/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.packet;

import in.gov.uidai.ec.service.packet.EnrolSummary;
import in.gov.uidai.ec.service.packet.PacketDemoVerify;
import in.gov.uidai.ec.service.packet.PacketStatus;
import in.gov.uidai.ec.service.packet.PacketStatusType;
import in.gov.uidai.ec.service.packet.PacketSummary;
import in.gov.uidai.ec.service.packet.PacketType;
import in.gov.uidai.ec.service.packet.PacketVerifyType;
import in.gov.uidai.ec.service.packet.UenrolSummary;

public class PacketCombinedSummary {
    private String enrolId;
    private PacketType packetType;
    private PacketStatus latestPacketStatus;
    private PacketSummary packetSummary;
    private PacketDemoVerify packetDemoVerify;
    private EnrolSummary enrolSummary;
    private UenrolSummary uenrolSummary;
    private Long creationDate;

    public String getEnrolId() {
        return this.enrolId;
    }

    public PacketType getPacketType() {
        return this.packetType;
    }

    public PacketStatus getLatestPacketStatus() {
        return this.latestPacketStatus;
    }

    public void setLatestPacketStatus(PacketStatus latestPacketStatus) {
        this.latestPacketStatus = latestPacketStatus;
    }

    public PacketSummary getPacketSummary() {
        return this.packetSummary;
    }

    public void setPacketSummary(PacketSummary packetSummary) {
        this.packetSummary = packetSummary;
        this.packetType = PacketType.fromIntValue(packetSummary.getPktType());
        this.enrolId = packetSummary.getEnrolId();
    }

    public void setPacketDemoVerify(PacketDemoVerify packetDemoVerify) {
        this.packetDemoVerify = packetDemoVerify;
    }

    public void setEnrolSummary(EnrolSummary enrolSummary) {
        this.enrolSummary = enrolSummary;
    }

    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public void setUenrolSummary(UenrolSummary uenrolSummary) {
        this.uenrolSummary = uenrolSummary;
    }

    public PacketStatusType getPacketStatusType() {
        return PacketStatusType.fromIntValue(this.packetSummary.getStatus());
    }

    public String getTinNum() {
        return this.packetSummary.getTinNum();
    }

    public String getOpId() {
        return this.packetSummary.getOpId();
    }

    public String getReviewerId() {
        return this.packetSummary.getReviewerId();
    }

    public float getAmountCharged() {
        if (this.packetType.equals((Object)PacketType.NEW)) {
            return this.packetSummary.getAmountChargedForNewEnrolment();
        }
        if (this.packetType.equals((Object)PacketType.UPDATE) || this.packetType.equals((Object)PacketType.DOCUPDATE)) {
            return this.packetSummary.getAmountChargedForUpdateEnrolment();
        }
        return 0.0f;
    }

    public float getGstApplied() {
        return this.packetSummary.getGstApplied();
    }

    public float getTotalAmountCharged() {
        return this.packetSummary.getTotalAmountCharged();
    }

    public String getPreviousUid() {
        if (this.packetType.equals((Object)PacketType.UPDATE) || this.packetType.equals((Object)PacketType.DOCUPDATE) && this.uenrolSummary != null) {
            return this.uenrolSummary.getPreviousUid();
        }
        return null;
    }

    public PacketVerifyType getVerifyType() {
        return PacketVerifyType.fromIntValue((int)this.packetDemoVerify.getVerifyType());
    }

    public String getVerifierName() {
        return this.packetDemoVerify.getVerifierName();
    }

    public String getVerifierId() {
        return this.packetDemoVerify.getVerifierId();
    }

    public String getResidentName() {
        return this.packetSummary.getResidentName();
    }

    public String getIsNRI() {
        return this.packetSummary.getIsNRI();
    }

    public PacketStatusType getIntroStatus() {
        return PacketStatusType.fromIntValue(this.packetSummary.getIntroStatus());
    }

    public PacketStatusType getReviewerStatus() {
        return PacketStatusType.fromIntValue(this.packetSummary.getReviewerStatus());
    }

    public String getOnlyMandatoryBiometricUpdate() {
        return this.packetSummary.getOnlyMandatoryBiometricUpdate();
    }

    public String getBioException() {
        if (this.packetType.equals((Object)PacketType.NEW) && this.enrolSummary != null) {
            return this.enrolSummary.getBioException();
        }
        if (this.packetType.equals((Object)PacketType.UPDATE) || this.packetType.equals((Object)PacketType.DOCUPDATE) && this.uenrolSummary != null) {
            return this.uenrolSummary.getBioException();
        }
        return null;
    }

    public String getSupervisorId() {
        if (this.packetType.equals((Object)PacketType.NEW) && this.enrolSummary != null) {
            return this.enrolSummary.getSupervisorId();
        }
        if (this.packetType.equals((Object)PacketType.UPDATE) || this.packetType.equals((Object)PacketType.DOCUPDATE) && this.uenrolSummary != null) {
            return this.uenrolSummary.getSupervisorId();
        }
        return null;
    }

    public int getMissingIrisCount() {
        String bioexception = this.getBioException();
        int missingIrisCount = 0;
        if (bioexception != null && bioexception.length() >= 2) {
            char needle = '0';
            for (int i = 0; i <= 1; ++i) {
                if (bioexception.charAt(i) != needle) continue;
                ++missingIrisCount;
            }
        }
        return missingIrisCount;
    }

    public int getMissingFingerCount() {
        String bioexception = this.getBioException();
        int missingFingerCount = 0;
        if (bioexception != null) {
            for (int i = 2; i < bioexception.length(); ++i) {
                char needle = '0';
                if (bioexception.charAt(i) != needle) continue;
                ++missingFingerCount;
            }
        }
        return missingFingerCount;
    }

    public String getMobile() {
        return this.packetSummary.getMobile();
    }

    public String getAppointmentId() {
        return this.packetSummary.getAppointmentId();
    }

    public String isPacketSkipped() {
        return this.packetSummary.getIsPacketSkipped();
    }

    public String getProcessingStateDesc() {
        return this.packetSummary.getProcessingStateDesc();
    }

    public String getRejectReasonDesc() {
        return this.packetSummary.getRejectReasonDesc();
    }
}

