/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.packet;

import in.gov.uidai.ec.escapi.EnrolServiceClientApiService;
import in.gov.uidai.ec.escapi.enrollmentdetails.EnrollmentDetailsResponse;
import in.gov.uidai.ec.escapi.enrollmentdetails.PacketStatusSummary;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.oauthapi.OauthGWService;
import in.gov.uidai.ec.oauthapi.json.statusapi.EnrolmentStatus;
import in.gov.uidai.ec.oauthapi.json.statusapi.StageStatusRequest;
import in.gov.uidai.ec.oauthapi.json.statusapi.StageStatusResponse;
import in.gov.uidai.ec.service.autosyncupload.ProcessingStatusType;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.packet.IPacketReview;
import in.gov.uidai.ec.service.packet.IPacketSummaryDAO;
import in.gov.uidai.ec.service.packet.IUCPacketSummaryDAO;
import in.gov.uidai.ec.service.packet.PacketData;
import in.gov.uidai.ec.service.packet.PacketStatusType;
import in.gov.uidai.ec.service.packet.PacketType;
import in.gov.uidai.ec.service.packet.PacketVerifyType;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.report.PacketStatusWiseSummary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PacketReviewDelegate
implements IPacketReview {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketReviewDelegate.class);
    @Autowired
    private EnrolServiceClientApiService enrolServiceClientApiService;
    @Autowired
    private IUCPacketSummaryDAO ucPacketSummaryDAO;
    @Autowired
    private IPacketSummaryDAO packetSummaryDAO;
    private OauthGWService oauthGwApiService;
    private IRegistrationService registrationService;
    private static final String SEPERATOR = ",";
    private EnrollmentService enrollmentService;

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public OauthGWService getOauthGwApiService() {
        return this.oauthGwApiService;
    }

    public void setOauthGwApiService(OauthGWService oauthGwApiService) {
        this.oauthGwApiService = oauthGwApiService;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    @Override
    public List<PacketData> getDataForListing(String searchKey, List<String> searchValues) {
        LOGGER.debug("Fetching packet details for Supervisor.");
        Comparator eidComparator = (p1, p2) -> p2.getEnrolIdDate().substring(14).compareToIgnoreCase(p1.getEnrolIdDate().substring(14));
        TreeSet<PacketData> packetDataList = new TreeSet<PacketData>(eidComparator);
        if (this.enrollmentService == null || !this.enrollmentService.isUniversalClientTrnx()) {
            return this.getDataForListingEcmp(searchKey, searchValues);
        }
        try {
            StageStatusRequest request = new StageStatusRequest();
            ArrayList<String> operatorIds = new ArrayList<String>();
            operatorIds.add(this.enrollmentService.getOAuthSessionService().getOperatorDetails().getOperatorId());
            request.setOperatorIds(operatorIds);
            ArrayList<String> machineIds = new ArrayList<String>();
            machineIds.add(this.registrationService.getRegisteredMachineCode());
            request.setMachineCode(machineIds);
            StageStatusResponse stageStatusResponse = this.oauthGwApiService.getStageStatus(request, this.getClientIdentification());
            for (EnrolmentStatus enrolmentStatus : stageStatusResponse.getEnrolmentStatuses()) {
                PacketData packetDatum = new PacketData();
                String updateBitIndicator = enrolmentStatus.getProcessingStatus().getUpdateBitIndicator();
                String isNRI = updateBitIndicator.charAt(9) == '1' ? "true" : "false";
                packetDatum.setOpId((String)operatorIds.get(0));
                packetDatum.setEnrolIdDate(enrolmentStatus.getSid());
                String stageStatus = enrolmentStatus.getProcessingStatus().getStageStatus();
                String state = enrolmentStatus.getProcessingStatus().getPacketState();
                packetDatum.setStatus(PacketStatusType.fromString(stageStatus));
                packetDatum.setProcessingStateDesc(state);
                packetDatum.setType(enrolmentStatus.getProcessingStatus().getType());
                packetDatum.setRejectReasonDesc(enrolmentStatus.getProcessingStatus().getStageReasonCode());
                packetDatum.setSubRejectReasonDesc(enrolmentStatus.getProcessingStatus().getStageRejectReasonCode());
                packetDatum.setIsNRI(isNRI);
                packetDatum.setClient("UC");
                packetDatum.isPacketSkipped("false");
                packetDataList.add(packetDatum);
            }
            List reviewDetails = this.enrolServiceClientApiService.fetchEnrollmentDetails(searchKey, searchValues);
            for (EnrollmentDetailsResponse enrollmentDetails : reviewDetails) {
                PacketStatusType packetStatusType = PacketStatusType.forValue(enrollmentDetails.getStatus());
                if (packetStatusType.toIntValue() == PacketStatusType.DELETED.toIntValue()) continue;
                String processingState = enrollmentDetails.getProcessingState();
                if (packetStatusType.toIntValue() != PacketStatusType.REJECTED.toIntValue() && !this.isPacketTobeResent(processingState) && !this.isPacketPutOnHold(processingState) && this.packetReceivedStatus(processingState)) {
                    enrollmentDetails.setProcessingStateDesc("This enrollment is in progress");
                }
                PacketData packetData = new PacketData();
                packetData.setEnrolIdDate(enrollmentDetails.getEid());
                if (!enrollmentDetails.getPacketVerifyType().isEmpty() && PacketVerifyType.valueOf((String)enrollmentDetails.getPacketVerifyType()) == PacketVerifyType.INTRODUCER) {
                    packetData.setIntroId(enrollmentDetails.getIntroducerId());
                    packetData.setIntroName(enrollmentDetails.getIntroducerName());
                }
                packetData.setSupId(enrollmentDetails.getSupervisorId());
                packetData.setOpId(enrollmentDetails.getOperatorId());
                packetData.setOpName(enrollmentDetails.getOperatorName());
                packetData.setResidentName(enrollmentDetails.getResidentName());
                packetData.setStatus(packetStatusType);
                packetData.setType(enrollmentDetails.getPacketType());
                if (PacketType.fromEnrolFlagValue(enrollmentDetails.getPacketType()).toIntValue() == PacketType.NEW.toIntValue()) {
                    packetData.setType("E");
                } else if (PacketType.fromEnrolFlagValue(enrollmentDetails.getPacketType()).toIntValue() == PacketType.UPDATE.toIntValue()) {
                    packetData.setType("U");
                } else if (PacketType.fromEnrolFlagValue(enrollmentDetails.getPacketType()).toIntValue() == PacketType.DOCUPDATE.toIntValue()) {
                    packetData.setType("DU");
                }
                packetData.setIsNRI(String.valueOf(enrollmentDetails.getIsNRI()));
                packetData.setAppointmentId(enrollmentDetails.getAppointmentId());
                packetData.isPacketSkipped(String.valueOf(enrollmentDetails.getIsPacketSkipped()));
                packetData.setProcessingState(processingState);
                packetData.setRejectReasonDesc(enrollmentDetails.getRejectReasonDesc());
                packetData.setProcessingStateDesc(enrollmentDetails.getProcessingStateDesc());
                packetData.setSubRejectReasonDesc(enrollmentDetails.getSubRejectReasonDesc());
                packetData.setClient("ECMP");
                packetDataList.add(packetData);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to fetch enrollment details", (Throwable)e);
        }
        return new ArrayList<PacketData>(packetDataList);
    }

    private List<PacketData> getDataForListingEcmp(String searchKey, List<String> searchValues) {
        LOGGER.debug("Fetching packet details for Supervisor.");
        Comparator eidComparator = (p1, p2) -> p2.getEnrolIdDate().substring(14).compareToIgnoreCase(p1.getEnrolIdDate().substring(14));
        TreeSet<PacketData> packetDataList = new TreeSet<PacketData>(eidComparator);
        try {
            List reviewDetails = this.enrolServiceClientApiService.fetchEnrollmentDetails(searchKey, searchValues);
            for (EnrollmentDetailsResponse enrollmentDetails : reviewDetails) {
                PacketStatusType packetStatusType = PacketStatusType.forValue(enrollmentDetails.getStatus());
                if (packetStatusType.toIntValue() == PacketStatusType.DELETED.toIntValue()) continue;
                String processingState = enrollmentDetails.getProcessingState();
                if (packetStatusType.toIntValue() != PacketStatusType.REJECTED.toIntValue() && !this.isPacketTobeResent(processingState) && !this.isPacketPutOnHold(processingState) && this.packetReceivedStatus(processingState)) {
                    enrollmentDetails.setProcessingStateDesc("This enrollment is in progress");
                }
                PacketData packetData = new PacketData();
                packetData.setEnrolIdDate(enrollmentDetails.getEid());
                if (!enrollmentDetails.getPacketVerifyType().isEmpty() && PacketVerifyType.valueOf((String)enrollmentDetails.getPacketVerifyType()) == PacketVerifyType.INTRODUCER) {
                    packetData.setIntroId(enrollmentDetails.getIntroducerId());
                    packetData.setIntroName(enrollmentDetails.getIntroducerName());
                }
                packetData.setSupId(enrollmentDetails.getSupervisorId());
                packetData.setOpId(enrollmentDetails.getOperatorId());
                packetData.setOpName(enrollmentDetails.getOperatorName());
                packetData.setResidentName(enrollmentDetails.getResidentName());
                packetData.setStatus(packetStatusType);
                packetData.setType(enrollmentDetails.getPacketType());
                if (PacketType.fromEnrolFlagValue(enrollmentDetails.getPacketType()).toIntValue() == PacketType.NEW.toIntValue()) {
                    packetData.setType("E");
                } else if (PacketType.fromEnrolFlagValue(enrollmentDetails.getPacketType()).toIntValue() == PacketType.UPDATE.toIntValue()) {
                    packetData.setType("U");
                } else if (PacketType.fromEnrolFlagValue(enrollmentDetails.getPacketType()).toIntValue() == PacketType.DOCUPDATE.toIntValue()) {
                    packetData.setType("DU");
                }
                packetData.setIsNRI(String.valueOf(enrollmentDetails.getIsNRI()));
                packetData.setAppointmentId(enrollmentDetails.getAppointmentId());
                packetData.isPacketSkipped(String.valueOf(enrollmentDetails.getIsPacketSkipped()));
                packetData.setProcessingState(processingState);
                packetData.setRejectReasonDesc(enrollmentDetails.getRejectReasonDesc());
                packetData.setProcessingStateDesc(enrollmentDetails.getProcessingStateDesc());
                packetData.setSubRejectReasonDesc(enrollmentDetails.getSubRejectReasonDesc());
                packetDataList.add(packetData);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to fetch enrollment details", (Throwable)e);
        }
        return new ArrayList<PacketData>(packetDataList);
    }

    @Override
    public PacketStatusWiseSummary getPacketStatusWiseSummary() {
        PacketStatusWiseSummary summary = new PacketStatusWiseSummary();
        try {
            PacketStatusSummary packetStatusWiseSummary = this.enrolServiceClientApiService.fetchPacketStatusWiseSummary();
            summary.setApprovedCount(packetStatusWiseSummary.getApprovedCount());
            summary.setRejectedCount(packetStatusWiseSummary.getRejectedCount());
            summary.setSkippedCount(packetStatusWiseSummary.getSkippedCount());
            summary.setSyncedCount(packetStatusWiseSummary.getSyncedCount());
            summary.setUploadedCount(packetStatusWiseSummary.getUploadedCount());
        }
        catch (IOException e) {
            LOGGER.error("Failed to fetch packet status wise summary", (Throwable)e);
        }
        return summary;
    }

    private boolean packetReceivedStatus(String processingState) {
        return !processingState.isEmpty();
    }

    private boolean isPacketPutOnHold(String processingState) {
        return processingState.toUpperCase().equalsIgnoreCase(ProcessingStatusType.HOLD.toString());
    }

    private boolean isPacketTobeResent(String processingState) {
        return processingState.toUpperCase().startsWith(ProcessingStatusType.RESEND.toString());
    }

    private String getClientIdentification() {
        return this.registrationService.getRegistrarId() + SEPERATOR + this.registrationService.getAgencyId() + SEPERATOR + this.registrationService.getStationId() + SEPERATOR + ApplicationVersion.FULLDISPLAYVERSION + SEPERATOR + this.registrationService.getRegisteredMachineCode();
    }
}

