/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.packet;

import in.gov.uidai.ec.service.autosyncupload.EnrolmentCreationInformation;
import in.gov.uidai.ec.service.autosyncupload.PacketSkipReason;
import in.gov.uidai.ec.service.autosyncupload.ProcessingStatus;
import in.gov.uidai.ec.service.operatordisclosure.DisclosureInfoData;
import in.gov.uidai.ec.service.packet.EidSearchType;
import in.gov.uidai.ec.service.packet.EnrolSummary;
import in.gov.uidai.ec.service.packet.EnrolSummaryDAO;
import in.gov.uidai.ec.service.packet.IEnrolVerifySearch;
import in.gov.uidai.ec.service.packet.IPacketReview;
import in.gov.uidai.ec.service.packet.IPacketService;
import in.gov.uidai.ec.service.packet.PacketCombinedSummary;
import in.gov.uidai.ec.service.packet.PacketData;
import in.gov.uidai.ec.service.packet.PacketDemoVerifyDAO;
import in.gov.uidai.ec.service.packet.PacketStatusDAO;
import in.gov.uidai.ec.service.packet.PacketStatusType;
import in.gov.uidai.ec.service.packet.PacketSummary;
import in.gov.uidai.ec.service.packet.PacketSummaryDAO;
import in.gov.uidai.ec.service.packet.PacketType;
import in.gov.uidai.ec.service.packet.UenrolSummary;
import in.gov.uidai.ec.service.packet.UenrolSummaryDAO;
import in.gov.uidai.ec.service.presync.IServerSyncDAO;
import in.gov.uidai.ec.service.report.PacketStatusCount;
import in.gov.uidai.ec.service.report.PacketStatusWiseSummary;
import in.gov.uidai.ec.service.session.ISessionService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class PacketService
implements IPacketService {
    private IPacketReview review;
    private IEnrolVerifySearch enrolVerifySearch;
    private PacketStatusDAO packetStatusDAO;
    private PacketSummaryDAO packetSummaryDAO;
    private EnrolSummaryDAO enrolSummaryDAO;
    private UenrolSummaryDAO uenrolSummaryDAO;
    private PacketDemoVerifyDAO packetDemoVerifyDAO;
    private IServerSyncDAO serverSyncDAO;
    private ISessionService sessionService;
    private DisclosureInfoData disclosureInfoData;

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void setPacketSummaryDAO(PacketSummaryDAO packetSummaryDAO) {
        this.packetSummaryDAO = packetSummaryDAO;
    }

    public final void setReview(IPacketReview review) {
        this.review = review;
    }

    public final void setEnrolVerifySearch(IEnrolVerifySearch enrolVerifySearch) {
        this.enrolVerifySearch = enrolVerifySearch;
    }

    public void setPacketStatusDAO(PacketStatusDAO packetStatusDAO) {
        this.packetStatusDAO = packetStatusDAO;
    }

    public void setEnrolSummaryDAO(EnrolSummaryDAO enrolSummaryDAO) {
        this.enrolSummaryDAO = enrolSummaryDAO;
    }

    public void setUenrolSummaryDAO(UenrolSummaryDAO uenrolSummaryDAO) {
        this.uenrolSummaryDAO = uenrolSummaryDAO;
    }

    public void setPacketDemoVerifyDAO(PacketDemoVerifyDAO packetDemoVerifyDAO) {
        this.packetDemoVerifyDAO = packetDemoVerifyDAO;
    }

    public void setDisclosureInfoData(DisclosureInfoData disclosureInfoData) {
        this.disclosureInfoData = disclosureInfoData;
    }

    public void setServerSyncDAO(IServerSyncDAO serverSyncDAO) {
        this.serverSyncDAO = serverSyncDAO;
    }

    @Override
    public PacketSummary getPacketSummary(String enrolId) {
        return this.packetSummaryDAO.getPacketSummary(enrolId);
    }

    @Override
    public List<PacketData> getDataForListing(String searchKey, List<String> searchValues) {
        return this.review.getDataForListing(searchKey, searchValues);
    }

    @Override
    public PacketStatusWiseSummary getPacketStatusWiseSummary() {
        return this.review.getPacketStatusWiseSummary();
    }

    @Override
    public List<String> findByStatus(PacketStatusType type) {
        return this.enrolVerifySearch.findByStatus(type);
    }

    @Override
    public int getCountOfUnUploadedAndResendPackets() {
        return this.enrolVerifySearch.getCountOfUnUploadedAndResendPackets();
    }

    @Override
    public List<Map<String, String>> getUploadedPacketsCountByDate() throws ParseException {
        String operatorId = this.sessionService.getOperatorCredentials().getOperatorId();
        Map<String, String> result = this.disclosureInfoData.getDisclosedData();
        String date_of_disclosure = result.get(operatorId);
        long dateOfDisclosure = this.dateFormatter(date_of_disclosure);
        return this.packetSummaryDAO.getUploadedPacketsCountByDate(operatorId, dateOfDisclosure);
    }

    @Override
    public List<String> findByStatus(PacketStatusType status, long age) {
        return this.enrolVerifySearch.findByStatus(status, age);
    }

    @Override
    public List<EnrolmentCreationInformation> getPacketStatusList() {
        return this.enrolVerifySearch.getPacketStatusList();
    }

    @Override
    public List<String> findRejectedPackets(String operatorId) {
        return this.enrolVerifySearch.findRejectedPackets(operatorId);
    }

    @Override
    public EnrolSummary getNewEnrolSummary(String enrolid) {
        return this.enrolSummaryDAO.getEnrolSummary(enrolid);
    }

    @Override
    public UenrolSummary getUpdateEnrolSummary(String enrolid) {
        return this.uenrolSummaryDAO.getUenrolSummary(enrolid);
    }

    @Override
    public PacketCombinedSummary getCombinedSummary(String enrolId) {
        PacketCombinedSummary pcs = new PacketCombinedSummary();
        pcs.setPacketSummary(this.getPacketSummary(enrolId));
        pcs.setLatestPacketStatus(this.packetStatusDAO.getLatestPacketStatus(enrolId));
        pcs.setPacketDemoVerify(this.packetDemoVerifyDAO.getPacketDemoVerification(enrolId));
        pcs.setCreationDate(this.packetSummaryDAO.getPacketCreationDate(enrolId));
        if (pcs.getPacketType().equals((Object)PacketType.NEW)) {
            pcs.setEnrolSummary(this.getNewEnrolSummary(enrolId));
        } else if (pcs.getPacketType().equals((Object)PacketType.UPDATE) || pcs.getPacketType().equals((Object)PacketType.DOCUPDATE)) {
            pcs.setUenrolSummary(this.uenrolSummaryDAO.getUenrolSummary(enrolId));
        }
        return pcs;
    }

    @Override
    public List<String> getEidListByPeriod(EidSearchType eidsearch, Long fromDate, Long toDate) {
        return this.packetSummaryDAO.getEidList(eidsearch, fromDate, toDate);
    }

    @Override
    public PacketStatusType getPacketIntegrityFailedStatusType(String enrolId) {
        return this.packetSummaryDAO.getPacketIntegrityFailedStatusType(enrolId);
    }

    @Override
    public int getCountOfEnrolmentsAsOn(String date) {
        return this.packetStatusDAO.getCountOfEnrolmentsAsOn(date);
    }

    @Override
    public int getUnUploadedPacketCount() {
        return this.packetSummaryDAO.getUnUploadedPacketsCount();
    }

    @Override
    public List<String> getUnUploadedPackets() {
        return this.packetSummaryDAO.getUnUploadedPackets();
    }

    @Override
    public void updateReEnrolledStatusPktStatus(String enrolId) {
        this.packetSummaryDAO.updateReEnroledStatusPktStatus(enrolId);
    }

    @Override
    public List<PacketStatusCount> getPacketStatusCount(String userType) {
        return this.packetSummaryDAO.getPacketStatusCount(userType);
    }

    @Override
    public List<PacketStatusCount> getBEPacketStatusCount(String userType) {
        return this.packetSummaryDAO.getPacketStatusCount(userType);
    }

    @Override
    public void updatePacketStatusForEids(List<String> enrolIds, PacketStatusType packetStatus) {
        this.packetStatusDAO.updatePacketStatusForEids(enrolIds, packetStatus.toIntValue());
    }

    @Override
    public void updatePacketSummaryStatusForEids(List<String> enrolIds, PacketStatusType packetStatus) {
        this.packetSummaryDAO.updatePacketStatusForEids(enrolIds, packetStatus.toIntValue());
    }

    @Override
    public void upsertLastSync(long currentTimeMillis) {
        this.serverSyncDAO.upsertLastSync(currentTimeMillis);
    }

    @Override
    public void updatePacketSummaryProcessingStateForEids(List<String> eids, ProcessingStatus value) {
        this.packetSummaryDAO.updatePacketSummaryProcessingStatusForEids(eids, value);
    }

    @Override
    public void setAutoSyncUploadSkipped(Map<String, PacketSkipReason> eidMap, boolean isSkipped) {
        this.packetSummaryDAO.setAutoSyncUploadSkipped(eidMap, isSkipped);
    }

    @Override
    public List<Map<String, String>> getQcRejectedPackets(String operatorId) {
        return this.packetSummaryDAO.getQcRejectedPackets(operatorId);
    }

    public long dateFormatter(String dateOfDisclosure) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("IST"));
        String date = dateOfDisclosure + " 00:00:00";
        Date req_date = sdf.parse(date);
        long epoc = req_date.getTime();
        return epoc;
    }
}

