/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.packet;

import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.service.autosyncupload.EnrolmentCreationInformation;
import in.gov.uidai.ec.service.packet.IPacketStatusDAO;
import in.gov.uidai.ec.service.packet.PacketStatus;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketStatusDAO
implements IPacketStatusDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketStatusDAO.class);
    private SqlSession session;

    public void setSqlSession(SqlSession session) {
        this.session = session;
    }

    @Override
    public void putPacketStatus(PacketStatus summary) {
        try {
            this.session.update("insertPacketStatus", (Object)summary);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    @Override
    public void deletePacketStatus(String enrolId) {
        try {
            this.session.update("purgePacketStatus", (Object)enrolId);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    @Override
    public List<PacketStatus> findLastModified(String enrolId, int status) {
        List pktStatus = null;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("enrolId", enrolId);
        paramMap.put("status", status);
        try {
            pktStatus = this.session.selectList("getLastModified", paramMap);
        }
        catch (Exception e) {
            LOGGER.error("Error finding last modified packet status", (Throwable)e);
        }
        return pktStatus;
    }

    @Override
    public List<EnrolmentCreationInformation> getPacketStatusList() {
        try {
            return this.session.selectList("getAllPacketStatus");
        }
        catch (Exception e) {
            LOGGER.error("Error getting packet status list for eids", (Throwable)e);
            return null;
        }
    }

    @Override
    public PacketStatus getLatestPacketStatus(String enrolId) {
        try {
            return (PacketStatus)this.session.selectOne("getLatestReviewForEnrolId", (Object)enrolId);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    @Override
    public int getCountOfEnrolmentsAsOn(String date) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("date", date);
        try {
            return (Integer)this.session.selectOne("getCountOfEnrolmentsForTheDate", paramMap);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:report", (Throwable)e);
        }
    }

    @Override
    public void updatePacketStatusForEids(List<String> enrolIds, int packetStatus) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("status", packetStatus);
        paramMap.put("enrolIds", enrolIds);
        paramMap.put("statusEntryDate", System.currentTimeMillis());
        try {
            this.session.update("updatePacketsStatusForEids", paramMap);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }
}

