/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.packet;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum PacketStatusType {
    PENDING_APPROVAL(0),
    ON_HOLD(1),
    APPROVED(2),
    REJECTED(3),
    EXPORTED(4),
    DELETED(5),
    AUTO_REJECTED(6),
    REVIEWER_APPROVED(7),
    INTRO_APPROVED(8),
    RESEND(9),
    UPLOADED(10),
    PKTINTG_BEFORE_DOC(11),
    PKTINTG_AFTER_DOC(12),
    PKTINTG_BEFORE_EOD(13),
    PKTINTG_AFTER_EOD(14),
    PKTINTG_EXPORT(15),
    PKTINTG_FAILED(16),
    SYNCED(17),
    Completed(18),
    OnHold(19),
    InProcess(20);

    private final int value;

    private PacketStatusType(int value) {
        this.value = value;
    }

    public static PacketStatusType fromIntValue(int val) {
        PacketStatusType packetStatus;
        switch (val) {
            case 0: {
                packetStatus = PENDING_APPROVAL;
                break;
            }
            case 1: {
                packetStatus = ON_HOLD;
                break;
            }
            case 2: {
                packetStatus = APPROVED;
                break;
            }
            case 3: {
                packetStatus = REJECTED;
                break;
            }
            case 4: {
                packetStatus = EXPORTED;
                break;
            }
            case 5: {
                packetStatus = DELETED;
                break;
            }
            case 6: {
                packetStatus = AUTO_REJECTED;
                break;
            }
            case 7: {
                packetStatus = REVIEWER_APPROVED;
                break;
            }
            case 8: {
                packetStatus = INTRO_APPROVED;
                break;
            }
            case 9: {
                packetStatus = RESEND;
                break;
            }
            case 10: {
                packetStatus = UPLOADED;
                break;
            }
            case 11: {
                packetStatus = PKTINTG_BEFORE_DOC;
                break;
            }
            case 12: {
                packetStatus = PKTINTG_AFTER_DOC;
                break;
            }
            case 13: {
                packetStatus = PKTINTG_BEFORE_EOD;
                break;
            }
            case 14: {
                packetStatus = PKTINTG_AFTER_EOD;
                break;
            }
            case 15: {
                packetStatus = PKTINTG_EXPORT;
                break;
            }
            case 16: {
                packetStatus = PKTINTG_FAILED;
                break;
            }
            case 17: {
                packetStatus = SYNCED;
                break;
            }
            case 18: {
                packetStatus = Completed;
            }
            case 19: {
                packetStatus = OnHold;
            }
            case 20: {
                packetStatus = InProcess;
            }
            default: {
                packetStatus = APPROVED;
            }
        }
        return packetStatus;
    }

    public static PacketStatusType fromString(String status) {
        switch (status.toLowerCase()) {
            case "completed": {
                return Completed;
            }
            case "onhold": {
                return OnHold;
            }
            case "inprocess": {
                return InProcess;
            }
            case "rejected": {
                return REJECTED;
            }
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }

    @JsonCreator
    public static PacketStatusType forValue(String packetStatusString) {
        packetStatusString = packetStatusString.toUpperCase();
        return PacketStatusType.valueOf(packetStatusString);
    }

    public int toIntValue() {
        return this.value;
    }

    @JsonValue
    public String toValue() {
        return String.valueOf((Object)this).toLowerCase();
    }
}

