/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.packet;

import in.gov.uidai.ec.escapi.DerbyDbException;
import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.service.autosyncupload.PacketSkipReason;
import in.gov.uidai.ec.service.autosyncupload.ProcessingStatus;
import in.gov.uidai.ec.service.packet.EidSearchType;
import in.gov.uidai.ec.service.packet.IPacketSummaryDAO;
import in.gov.uidai.ec.service.packet.PacketStatusType;
import in.gov.uidai.ec.service.packet.PacketSummary;
import in.gov.uidai.ec.service.packet.PacketUploadType;
import in.gov.uidai.ec.service.report.PacketStatusCount;
import in.gov.uidai.ec.service.report.PacketStatusWiseSummary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketSummaryDAO
implements IPacketSummaryDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketSummaryDAO.class);
    private static final Integer DATE_DURATION = 30;
    private SqlSession session;

    public void setSqlSession(SqlSession session) {
        this.session = session;
    }

    @Override
    public PacketSummary getPacketSummary(String enrolId) {
        PacketSummary packetSummary;
        try {
            packetSummary = (PacketSummary)this.session.selectOne("getPacketSummary", (Object)enrolId);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
        return packetSummary;
    }

    @Override
    public void putPacketSummary(PacketSummary summary) throws DerbyDbException {
        try {
            this.session.update("insertPacketSummary", (Object)summary);
        }
        catch (Exception e) {
            throw new DerbyDbException("domain-errors:internal", e);
        }
    }

    @Override
    public void deletePacketSummary(String enrolId) {
        try {
            this.session.delete("purgePacketSummary", (Object)enrolId);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    @Override
    public long getPacketCreationDate(String enrolId) {
        long packetCreationDate;
        try {
            packetCreationDate = (Long)this.session.selectOne("getPacketCreationDate", (Object)enrolId);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
        return packetCreationDate;
    }

    @Override
    public PacketStatusType getPacketIntegrityFailedStatusType(String enrolId) {
        PacketStatusType packetStatusType;
        try {
            packetStatusType = (PacketStatusType)((Object)this.session.selectOne("getPacketSummaryStatus", (Object)enrolId));
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
        return packetStatusType;
    }

    @Override
    public void updateReEnroledStatusPktStatus(String enrolId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("enrolId", enrolId);
        paramMap.put("upload_status", PacketUploadType.RE_ENROLED.toIntValue());
        try {
            this.session.update("updateReEnroledStatus", paramMap);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    @Override
    public List<PacketStatusCount> getPacketStatusCount(String userType) {
        LOGGER.debug("In get method of EodReportSearch UpTO today");
        List packetStatusCountList = new ArrayList();
        try {
            if (userType.equalsIgnoreCase("Introducer")) {
                packetStatusCountList = this.session.selectList("getPacketIntroducerStatus");
            } else if (userType.equalsIgnoreCase("Reviewer")) {
                packetStatusCountList = this.session.selectList("getPacketReviewerStatus");
            }
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:report", (Throwable)e);
        }
        return packetStatusCountList;
    }

    @Override
    public List<String> getEidList(EidSearchType eidsearchtype, Long fromDate, Long toDate) {
        List eidList;
        try {
            if (fromDate == null) {
                eidList = this.session.selectList(eidsearchtype.toEidListSelectStatement());
            } else {
                HashMap<String, Long> paramMap = new HashMap<String, Long>();
                paramMap.put("fromDate", fromDate);
                paramMap.put("toDate", toDate);
                eidList = this.session.selectList(eidsearchtype.toEidListSelectStatement(), paramMap);
            }
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
        return eidList;
    }

    @Override
    public List<String> findByStatusAndAge(PacketStatusType type) {
        try {
            return this.session.selectList("selectPacketByStatus", (Object)type.toIntValue());
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    @Override
    public int getCountOfUnUploadedAndResendPackets() {
        try {
            return (Integer)this.session.selectOne("getCountOfUnUploadedAndResendPackets");
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    @Override
    public PacketStatusWiseSummary getPacketStatusWiseCountSummary() {
        try {
            return (PacketStatusWiseSummary)this.session.selectOne("getPacketStatusWiseCountSummary");
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    @Override
    public List<String> findBEByStatusAndAge(PacketStatusType type) {
        try {
            return this.session.selectList("selectBEPacketByStatus", (Object)type.toIntValue());
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    @Override
    public List<String> findByStatusAndAge(PacketStatusType status, long age) {
        List enrolIdList = null;
        HashMap<String, Number> statusAndDate = new HashMap<String, Number>();
        statusAndDate.put("status", status.toIntValue());
        statusAndDate.put("statusEntryDate", System.currentTimeMillis() - age);
        try {
            enrolIdList = this.session.selectList("selectByStatusEntryDate", statusAndDate);
            LOGGER.debug("Size of Enrolement Summary --  Status---" + enrolIdList.size() + "  " + (Object)((Object)status));
        }
        catch (Exception e) {
            LOGGER.error("Error finding summary by status and age", (Throwable)e);
        }
        return enrolIdList;
    }

    @Override
    public List<String> findRejectedPackets(String operatorId) {
        try {
            return this.session.selectList("selectReviewerRejectedPackets", (Object)operatorId);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    @Override
    public List<PacketSummary> getPacketsForUserReview() {
        List packets;
        try {
            packets = this.session.selectList("getPacketSummaryForUserReview");
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
        return packets;
    }

    @Override
    public void updatePacketStatusForEids(List<String> enrolIds, int packetStatus) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("status", packetStatus);
        paramMap.put("enrolIds", enrolIds);
        paramMap.put("lastSyncDate", System.currentTimeMillis());
        try {
            this.session.update("updatePacketsSummaryStatusForEids", paramMap);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    @Override
    public void updatePacketSummaryProcessingStatusForEids(List<String> eids, ProcessingStatus processingStatus) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("processingStatus", processingStatus.getPacketState());
        paramMap.put("processingStatusDesc", processingStatus.getPacketStateDesc());
        paramMap.put("rejectReasonCode", processingStatus.getRejectReasonCode());
        paramMap.put("rejectReasonDesc", processingStatus.getRejectReasonDescription());
        paramMap.put("subRejectReasonCode", processingStatus.getSubRejectReasonCode());
        paramMap.put("subRejectReasonDesc", processingStatus.getSubRejectReasonDescription());
        paramMap.put("lastProcessedTime", processingStatus.getTimestampEpoch());
        paramMap.put("enrolIds", eids);
        try {
            this.session.update("updatePacketSummaryProcessingStatusForEids", paramMap);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    @Override
    public int getUnUploadedPacketsCount() {
        try {
            return (Integer)this.session.selectOne("getCountOfUnUploadedPackets");
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:report", (Throwable)e);
        }
    }

    @Override
    public List<String> getUnUploadedPackets() {
        try {
            return this.session.selectList("getUnUploadedPackets");
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:report", (Throwable)e);
        }
    }

    @Override
    public void setAutoSyncUploadSkipped(Map<String, PacketSkipReason> enrolMap, boolean skipped) {
        enrolMap.forEach((eid, pktSkipReason) -> {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            int isSkipped = skipped ? 1 : 0;
            paramMap.put("isSkipped", isSkipped);
            paramMap.put("enrolId", eid);
            if (skipped) {
                PacketSkipReason.Error error = pktSkipReason.getError();
                String skipReasonCode = error != null ? error.getSkipReasonCode() : "error reading skip.json file";
                String skipReasonDescription = error != null ? error.getSkipReasonDescription() : "error reading skip.json file";
                paramMap.put("skipReasonCode", skipReasonCode);
                paramMap.put("skipReasonDescription", skipReasonDescription);
            } else {
                paramMap.put("skipReasonCode", null);
                paramMap.put("skipReasonDescription", null);
            }
            this.session.update("setAutoSyncAndUploadSkipped", paramMap);
        });
    }

    @Override
    public List<Map<String, String>> getQcRejectedPackets(String operatorId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("operatorId", operatorId);
        data.put("days", DATE_DURATION);
        try {
            return this.session.selectList("getQcRejectedPacketStatus", data);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:report", (Throwable)e);
        }
    }

    @Override
    public List<Map<String, String>> getUploadedPacketsCountByDate(String operatorId, long date_disclosure) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("operatorId", operatorId);
        data.put("disclosure_date", date_disclosure);
        try {
            return this.session.selectList("getUploadedPacketsCountByDate", data);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:report", (Throwable)e);
        }
    }
}

