/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.packetgenerator;

import in.gov.uidai.ec.ecmpapi.RequestEncryptionHelper;
import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.service.packetgenerator.xml.Bir;
import in.gov.uidai.ec.service.packetgenerator.xml.IntroducerDetails;
import in.gov.uidai.ec.service.packetgenerator.xml.Metadata;
import in.gov.uidai.ec.service.packetgenerator.xml.OperatorDetails;
import in.gov.uidai.ec.service.packetgenerator.xml.Review;
import in.gov.uidai.ec.service.packetgenerator.xml.SupervisorDetails;
import in.gov.uidai.ec.service.packetgenerator.xml.UidEnrolmentAudit;
import in.gov.uidai.ec.service.packetgenerator.xml.UidEnrolmentProfile;
import in.gov.uidai.ec.service.packetgenerator.xml.UidEnrolmentResidentAuth;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EnrollmentPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrollmentPacket.class);
    private static final String RESIDENT_DEMO_FILE = "resident-demographics.xml";
    private static final String RESIDENT_BIO_FILE = "resident-biometrics.xml";
    private static final String RESIDENT_AUTH_FILE = "resident-details.xml";
    private static final String RESIDENT_SIGN_FILE = "resident-signature.xml";
    private static final String RESIDENT_EXCEPTION_FILE = "resident-exception-biometrics.xml";
    private static final String OPERATOR_DETAILS_FILE = "operator-details.xml";
    private static final String OPERATOR_SIGN_FILE = "operator-signature.xml";
    private static final String INTRODUCER_DETAILS_FILE = "introducer-details.xml";
    private static final String INTRODUCER_SIGN_FILE = "introducer-signature.xml";
    private static final String SUPERVISOR_DETAILS_FILE = "supervisor-details.xml";
    private static final String SUPERVISOR_SIGN_FILE = "supervisor-signature.xml";
    private static final String AUDIT_FILE = "audit.xml";
    private static final String REVIEW_FILE = "review.xml";
    private static final String METADATA_FILE = "metadata.xml";
    private static final String PRINT_LAYOUT_FILE = "print-layout.xml";
    private byte[] resDemo;
    private byte[] resBio;
    private byte[] resAuth;
    private byte[] resSign;
    private byte[] resBiox;
    private byte[] opDemo;
    private byte[] opSign;
    private byte[] supDemo;
    private byte[] supSign;
    private byte[] introDemo;
    private byte[] introSign;
    private byte[] audit;
    private byte[] reviewData;
    private byte[] metaData;
    private byte[] printLayoutData;
    private int iOrigSize = 0;

    EnrollmentPacket() {
    }

    public void setResidentDemographics(UidEnrolmentProfile profile) {
        this.resDemo = this.marshal(profile);
        if (this.resDemo != null) {
            this.iOrigSize += this.resDemo.length;
        }
    }

    public void setOperatorDemographics(OperatorDetails operator) {
        this.opDemo = this.marshal(operator);
        if (this.opDemo != null) {
            this.iOrigSize += this.opDemo.length;
        }
    }

    public void setSupervisorDemographics(SupervisorDetails supervisor) {
        this.supDemo = this.marshal(supervisor);
        if (this.supDemo != null) {
            this.iOrigSize += this.supDemo.length;
        }
    }

    public void setIntroducerDemographics(IntroducerDetails introducer) {
        this.introDemo = this.marshal(introducer);
        if (this.introDemo != null) {
            this.iOrigSize += this.introDemo.length;
        }
    }

    public void setResidentAuthorization(UidEnrolmentResidentAuth resAuth) {
        this.resAuth = this.marshal(resAuth);
        if (this.resAuth != null) {
            this.iOrigSize += this.resAuth.length;
        }
    }

    public void setResidentSignature(Object signature) {
        this.resSign = this.marshal(signature);
        if (this.resSign != null) {
            this.iOrigSize += this.resSign.length;
        }
    }

    public void setResidentBiometrics(Bir bir) {
        this.resBio = this.marshal(bir);
        if (this.resBio != null) {
            this.iOrigSize += this.resBio.length;
        }
    }

    public void setResidentBiox(Bir bir) {
        this.resBiox = this.marshal(bir);
        if (this.resBiox != null) {
            this.iOrigSize += this.resBiox.length;
        }
    }

    public void setOperatorSignature(Object signature) {
        this.opSign = this.marshal(signature);
        if (this.opSign != null) {
            this.iOrigSize += this.opSign.length;
        }
    }

    public void setSupervisorSignature(Bir bir) {
        this.supSign = this.marshal(bir);
        if (this.supSign != null) {
            this.iOrigSize += this.supSign.length;
        }
    }

    public void setIntroducerSignature(Object signature) {
        this.introSign = this.marshal(signature);
        if (this.introSign != null) {
            this.iOrigSize += this.introSign.length;
        }
    }

    public void setAudit(UidEnrolmentAudit uidaudit) {
        this.audit = this.marshal(uidaudit);
        if (this.audit != null) {
            this.iOrigSize += this.audit.length;
        }
    }

    public void setReview(Review review) {
        this.reviewData = this.marshal(review);
        if (this.reviewData != null) {
            this.iOrigSize += this.reviewData.length;
        }
    }

    public void setMetaData(Metadata md) {
        this.metaData = this.marshal(md);
        if (this.metaData != null) {
            this.iOrigSize += this.metaData.length;
        }
    }

    public void setPrintLayoutData(byte[] printLayoutData) {
        this.printLayoutData = printLayoutData;
        this.iOrigSize += printLayoutData.length;
    }

    byte[] createEncryptedPacket() throws IOException {
        byte[] encData;
        int iWritSize = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        iWritSize += this.writeByteArray(zos, RESIDENT_DEMO_FILE, this.resDemo);
        iWritSize += this.writeByteArray(zos, RESIDENT_BIO_FILE, this.resBio);
        iWritSize += this.writeByteArray(zos, RESIDENT_AUTH_FILE, this.resAuth);
        iWritSize += this.writeByteArray(zos, RESIDENT_SIGN_FILE, this.resSign);
        iWritSize += this.writeByteArray(zos, RESIDENT_EXCEPTION_FILE, this.resBiox);
        iWritSize += this.writeByteArray(zos, OPERATOR_DETAILS_FILE, this.opDemo);
        iWritSize += this.writeByteArray(zos, OPERATOR_SIGN_FILE, this.opSign);
        iWritSize += this.writeByteArray(zos, SUPERVISOR_DETAILS_FILE, this.supDemo);
        iWritSize += this.writeByteArray(zos, SUPERVISOR_SIGN_FILE, this.supSign);
        iWritSize += this.writeByteArray(zos, INTRODUCER_DETAILS_FILE, this.introDemo);
        iWritSize += this.writeByteArray(zos, INTRODUCER_SIGN_FILE, this.introSign);
        iWritSize += this.writeRawByteArray(zos, REVIEW_FILE, this.reviewData);
        iWritSize += this.writeRawByteArray(zos, METADATA_FILE, this.metaData);
        iWritSize += this.writeRawByteArray(zos, PRINT_LAYOUT_FILE, this.printLayoutData);
        zos.close();
        baos.flush();
        baos.close();
        if (this.iOrigSize != (iWritSize += this.writeByteArray(zos, AUDIT_FILE, this.audit))) {
            LOGGER.info("packet creation failed due to mismatch in the size of the xml!");
            LOGGER.info("The total Size of all the xml put into JDBM :" + this.iOrigSize);
            LOGGER.info("The total Size of all the xml get from JDBM :" + iWritSize);
            throw new ClientException("Packet creation failed: Error while Retrieving data from JDBM.");
        }
        try {
            encData = RequestEncryptionHelper.encryptRequest((ByteArrayOutputStream)baos, null);
        }
        catch (Exception e) {
            throw new ClientException("Exception while creating packet", (Throwable)e);
        }
        return encData;
    }

    private byte[] marshal(Object target) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            JAXB.marshal((Object)target, (OutputStream)bos);
            bos.flush();
            bos.close();
            return bos.toByteArray();
        }
        catch (Exception exep) {
            LOGGER.error("while marshalling " + target.getClass(), (Throwable)exep);
            return null;
        }
    }

    private int writeByteArray(ZipOutputStream zos, String name, byte[] barray) throws IOException {
        if (barray == null) {
            return 0;
        }
        return this.writeRawByteArray(zos, name, barray);
    }

    private int writeRawByteArray(ZipOutputStream zos, String name, byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return 0;
        }
        ZipEntry entry = new ZipEntry(name);
        zos.putNextEntry(entry);
        zos.write(data);
        zos.flush();
        return data.length;
    }
}

