/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.packetgenerator;

import in.gov.uidai.ec.ecmpapi.RequestEncryptionHelper;
import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.enrol.ECMPDateFormatHelper;
import in.gov.uidai.ec.service.enrol.ECMPDateFormats;
import in.gov.uidai.ec.service.enrol.EID;
import in.gov.uidai.ec.service.enrol.dynaddr.IDynaddrTemplateManager;
import in.gov.uidai.ec.service.enrollment.BiometricsCaptureTrail;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.UserDetails;
import in.gov.uidai.ec.service.enrollment.model.document.DocumentsManager;
import in.gov.uidai.ec.service.packetgenerator.EnrollmentPacket;
import in.gov.uidai.ec.service.packetgenerator.IEnrolPacketGeneratorService;
import in.gov.uidai.ec.service.packetgenerator._AuditDOMBuilder;
import in.gov.uidai.ec.service.packetgenerator._BiometricsDOMBuilder;
import in.gov.uidai.ec.service.packetgenerator._DemoDOMBuilder;
import in.gov.uidai.ec.service.packetgenerator._UserDetailsDOMBuilder;
import in.gov.uidai.ec.service.packetgenerator.xml.EnrolmentType;
import in.gov.uidai.ec.service.packetgenerator.xml.Metadata;
import in.gov.uidai.ec.service.packetgenerator.xml.Review;
import in.gov.uidai.ec.service.packetgenerator.xml.ReviewStatusType;
import in.gov.uidai.ec.service.packetgenerator.xml.ReviewType;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrolmentPacketGeneratorService
implements IEnrolPacketGeneratorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrolmentPacketGeneratorService.class);
    private IDynaddrTemplateManager dynaddrTplManager;
    private IRegistrationService registrationService;
    private EnrollmentService enrollmentService;
    private _AuditDOMBuilder auditDOM;
    private _DemoDOMBuilder demodom;
    private _BiometricsDOMBuilder biodom;
    private _UserDetailsDOMBuilder operatorDOM;
    private IOucDataStore oucDataStore;

    public void setDynaddrTplManager(IDynaddrTemplateManager dynaddrTplManager) {
        this.dynaddrTplManager = dynaddrTplManager;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public void setOucDataStore(IOucDataStore dataStore) {
        this.oucDataStore = dataStore;
    }

    private void initializeDomBuilders() {
        this.auditDOM = new _AuditDOMBuilder(this.enrollmentService, this.registrationService, this.oucDataStore);
        this.demodom = new _DemoDOMBuilder(this.enrollmentService);
        this.biodom = new _BiometricsDOMBuilder();
        this.operatorDOM = new _UserDetailsDOMBuilder(this.enrollmentService);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] generatePacket() throws ClientException {
        try {
            EnrollmentPacket packet = this.getEnrollmentPacket();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                try (ZipOutputStream zos = new ZipOutputStream(baos);){
                    EID enrolId = this.enrollmentService.getEnrolId();
                    byte[] encryptedEnrollmentPacket = packet.createEncryptedPacket();
                    this.writeRawByteArray(zos, enrolId.getEnrolNum() + ".zip", encryptedEnrollmentPacket);
                    DocumentsManager manager = this.enrollmentService.getDocManager();
                    Set<DocumentType> documentTypes = manager.getDocumentTypes();
                    LOGGER.info("documentTypes-----" + documentTypes.toArray() + " , DocumentsManager Validate " + manager.isValid());
                    for (DocumentType type : documentTypes) {
                        String documentFileName = this.getDocumentFileName(enrolId, type);
                        LOGGER.info("document File Name ::: " + documentFileName);
                        byte[] data = manager.getDocumentBytes(type);
                        LOGGER.info("document Size ::: " + data.length);
                        this.writeRawByteArray(zos, documentFileName, data);
                    }
                }
                byte[] byArray = RequestEncryptionHelper.encryptRequest((ByteArrayOutputStream)baos, null);
                return byArray;
            }
        }
        catch (Exception e) {
            LOGGER.error("Problem while generating the actual packet.", (Throwable)e);
            throw new ClientException(e.getMessage());
        }
    }

    private String getDocumentFileName(EID enrolId, DocumentType type) {
        if (null != type) {
            return enrolId.toString() + "_" + type.toString().toLowerCase() + "." + "pdf";
        }
        throw new ClientException("Mandatory Document missing");
    }

    private void writeRawByteArray(ZipOutputStream zos, String name, byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            LOGGER.error("Problem while generating the actual packet.");
            this.showPopupMessageDocMissing();
        }
        ZipEntry entry = new ZipEntry(name);
        zos.putNextEntry(entry);
        zos.write(data);
        zos.flush();
    }

    private EnrollmentPacket getEnrollmentPacket() throws Exception {
        UserDetails introducer;
        this.initializeDomBuilders();
        EnrollmentPacket packet = new EnrollmentPacket();
        packet.setResidentDemographics(this.demodom.getResidentDemographicsProfile());
        if (StringUtils.isNotBlank((String)this.enrollmentService.getDemoContactDetails().getAddress().getPinCodeValue())) {
            packet.setPrintLayoutData(this.dynaddrTplManager.getCurrentPrintLayout());
        }
        boolean isPhotographCaptureEnabled = this.enrollmentService.isPhotographCaptureEnabled();
        boolean demoOnlyUpdate = this.enrollmentService.isUpdateEnrollment() && !this.enrollmentService.isBiometricUpdate();
        boolean isRDBasedUpdate = this.enrollmentService.isRDBasedUpdate();
        LinkedHashMap<CaptureModality, BiometricsCaptureTrail> biometricsTrailMap = this.enrollmentService.getBiometricsTrailMap();
        if (demoOnlyUpdate) {
            packet.setResidentAuthorization(_BiometricsDOMBuilder.toResidentAuth(biometricsTrailMap, this.enrollmentService.getEnrolId().toString(), !isPhotographCaptureEnabled));
            packet.setResidentSignature(isRDBasedUpdate ? this.enrollmentService.getPhotograph().getResidentConfirmation().getRdSignature() : this.biodom.toBir4Resident(biometricsTrailMap));
            if (isPhotographCaptureEnabled) {
                LinkedHashMap<CaptureModality, BiometricsCaptureTrail> emptyTrial = new LinkedHashMap<CaptureModality, BiometricsCaptureTrail>();
                packet.setResidentBiometrics(this.biodom.toBir4Resident(emptyTrial));
            }
        } else {
            packet.setResidentBiometrics(this.biodom.toBir4Resident(biometricsTrailMap));
        }
        if (this.enrollmentService.getBiometricsException().getExceptionDetail().isBiometricExceptionApplied()) {
            packet.setResidentBiox(this.biodom.toBir4Resident(this.enrollmentService.getBiometricsExceptionTrailMap()));
        }
        packet.setOperatorDemographics(this.operatorDOM.toOperatorDetails());
        packet.setOperatorSignature(isRDBasedUpdate ? this.enrollmentService.getConfirmerDetails().getOperator().getSignature() : this.biodom.toBir4User(this.enrollmentService.getConfirmerDetails().getOperator().getBiometrics()));
        if (this.enrollmentService.getConfirmerDetails().getSupervisor() != null) {
            packet.setSupervisorSignature(this.biodom.toBir4User(this.enrollmentService.getConfirmerDetails().getSupervisor().getBiometrics()));
            packet.setSupervisorDemographics(this.operatorDOM.toSupervisorDetails());
        }
        if ((introducer = this.enrollmentService.getConfirmerDetails().getIntroducer()) != null) {
            packet.setIntroducerDemographics(this.operatorDOM.toIntroducerDetails());
            if (!isRDBasedUpdate) {
                if (introducer.getBiometrics() != null) {
                    packet.setIntroducerSignature(this.biodom.toBir4User(introducer.getBiometrics()));
                }
            } else {
                packet.setIntroducerSignature(introducer.getSignature());
            }
        }
        packet.setAudit(this.auditDOM.toEnrolmentAudit());
        try {
            Review review = new Review();
            review.setReviewStatus(ReviewStatusType.APPROVED);
            review.setReviewType(ReviewType.AUTO);
            review.setReviewDate(ECMPDateFormatHelper.getDateStr(new Date(), ECMPDateFormats.FULL_DATE_FORMAT));
            packet.setReview(review);
        }
        catch (Exception e) {
            LOGGER.error("Problem while creating review details", (Throwable)e);
            throw new ClientException(e.getMessage());
        }
        try {
            Metadata metaData = new Metadata();
            metaData.setType(EnrolmentType.RESIDENT);
            metaData.setFilename(this.enrollmentService.getEnrolId().toString() + ".zip");
            packet.setMetaData(metaData);
        }
        catch (Exception e) {
            LOGGER.error("Problem while creating metadata details", (Throwable)e);
            throw new ClientException(e.getMessage());
        }
        return packet;
    }

    private void showPopupMessageDocMissing() {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("Documents are missing for the current enrolment packet.");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "Aadhaar Message", 2);
    }
}

