/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.packetgenerator;

import in.gov.uidai.ec.escapi.GpsInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.service.enrol.ECMPDateFormatHelper;
import in.gov.uidai.ec.service.enrol.ECMPDateFormats;
import in.gov.uidai.ec.service.enrollment.BiometricsCapture;
import in.gov.uidai.ec.service.enrollment.BiometricsCaptureTrail;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.UserDetails;
import in.gov.uidai.ec.service.packetgenerator.xml.ComplianceType;
import in.gov.uidai.ec.service.packetgenerator.xml.FaceQssType;
import in.gov.uidai.ec.service.packetgenerator.xml.FaceQualityFeedbackType;
import in.gov.uidai.ec.service.packetgenerator.xml.FingerCaptureType;
import in.gov.uidai.ec.service.packetgenerator.xml.FingerQssType;
import in.gov.uidai.ec.service.packetgenerator.xml.FingerQualityFeedbackType;
import in.gov.uidai.ec.service.packetgenerator.xml.GpsDataType;
import in.gov.uidai.ec.service.packetgenerator.xml.IrisCaptureType;
import in.gov.uidai.ec.service.packetgenerator.xml.IrisQssType;
import in.gov.uidai.ec.service.packetgenerator.xml.IrisQualityFeedbackType;
import in.gov.uidai.ec.service.packetgenerator.xml.ManualInterventionType;
import in.gov.uidai.ec.service.packetgenerator.xml.OperatorSupervisorType;
import in.gov.uidai.ec.service.packetgenerator.xml.PhotoCaptureType;
import in.gov.uidai.ec.service.packetgenerator.xml.Point;
import in.gov.uidai.ec.service.packetgenerator.xml.StepTransitionType;
import in.gov.uidai.ec.service.packetgenerator.xml.UidEnrolmentAudit;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.qssitv.model.Compliance;
import in.gov.uidai.qssitv.model.FaceQSS;
import in.gov.uidai.qssitv.model.FingerSegment;
import in.gov.uidai.qssitv.model.FingerprintQSS;
import in.gov.uidai.qssitv.model.IrisQSS;
import java.io.IOException;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class _AuditDOMBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(_AuditDOMBuilder.class);
    private static final DecimalFormat GPS_FORMAT = new DecimalFormat("00000.00");
    private static final SimpleDateFormat ISO_8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final String FACE = "face";
    private static final String IRIS = "iris";
    private static final String FINGER = "finger";
    private final EnrollmentService enrollmentService;
    private final IRegistrationService registrationService;
    private final IOucDataStore oucDataStore;
    String regex = "([a-z])([A-Z])";
    String replacement = "$1_$2";

    _AuditDOMBuilder(EnrollmentService enrollmentService, IRegistrationService registrationService, IOucDataStore oucDataStore) {
        this.enrollmentService = enrollmentService;
        this.registrationService = registrationService;
        this.oucDataStore = oucDataStore;
    }

    UidEnrolmentAudit toEnrolmentAudit() throws IOException, StationInfoStoreException {
        UidEnrolmentAudit audit = this.populateGenericInfo();
        if (!this.enrollmentService.isRDBasedUpdate()) {
            this.populateBiometricInfo(audit);
        }
        audit.setStepTransitions(this.toStepTransitions());
        this.setUpdateType(audit);
        return audit;
    }

    private void setUpdateType(UidEnrolmentAudit audit) {
        if (this.enrollmentService.isUpdateEnrollment()) {
            UidEnrolmentAudit.UpdateType type = new UidEnrolmentAudit.UpdateType();
            type.setUpdateMode(this.enrollmentService.isRDBasedUpdate() ? "ONLINE" : "OFFLINE");
            type.setType("UpdateStandard");
            audit.setUpdateType(type);
        } else {
            UidEnrolmentAudit.EnrolmentType type = new UidEnrolmentAudit.EnrolmentType();
            type.setClientType("ECMP");
            type.setEnrolmentMode("OFFLINE");
            audit.setEnrolmentType(type);
        }
    }

    private UidEnrolmentAudit populateGenericInfo() throws IOException, StationInfoStoreException {
        UidEnrolmentAudit audit = new UidEnrolmentAudit();
        audit.setVersion(ApplicationVersion.VERSION);
        audit.setStartDate(this.getTimestamp(this.enrollmentService.getStartTime()));
        audit.setEndDate(this.getTimestamp(this.enrollmentService.getEndTime()));
        audit.setRegistrarId(this.registrationService.getRegistrarId());
        audit.setRegistrarName(this.registrationService.getRegistrarName());
        audit.setAgencyName(this.registrationService.getAgencyName());
        audit.setAgencyId(this.registrationService.getAgencyId());
        audit.setCurrentOperator(this.toOpSupType(this.enrollmentService.getConfirmerDetails().getOperator()));
        if (this.enrollmentService.getConfirmerDetails().getSupervisor() != null) {
            audit.setCurrentSupervisor(this.toOpSupType(this.enrollmentService.getConfirmerDetails().getSupervisor()));
        }
        audit.setClientId(this.registrationService.getStationId());
        String strSystemMachineCode = this.registrationService.getSystemMachineCode();
        String strRegisteredMachineCode = this.registrationService.getRegisteredMachineCode();
        LOGGER.info("System : " + strSystemMachineCode + " Registered:" + strRegisteredMachineCode);
        if (!strSystemMachineCode.equalsIgnoreCase(strRegisteredMachineCode)) {
            this.showMachineCodeMismatchPopupInfoMessage();
        }
        audit.setClientMachineId(strSystemMachineCode);
        audit.setClientVersion(ApplicationVersion.VERSION);
        audit.setGps(this.getGpsData());
        String location = this.registrationService.getClientLocation();
        if (StringUtils.isNotBlank((String)location)) {
            audit.setLocation(location);
        }
        if (StringUtils.isNotBlank((String)this.enrollmentService.getDemographicsOverride())) {
            audit.setDemoOverride(this.enrollmentService.getDemographicsOverride());
        }
        return audit;
    }

    private void showMachineCodeMismatchPopupInfoMessage() {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("Please ensure registered machine and enrolment machine are same");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "Aadhaar", 1);
    }

    private GpsDataType getGpsData() throws IOException, StationInfoStoreException {
        GpsDataType gpsDataType = new GpsDataType();
        GpsInfo gpsInfo = this.oucDataStore.getGpsInfo();
        float latitude = gpsInfo.getLatitude().floatValue();
        float longitude = gpsInfo.getLongitude().floatValue();
        float altitude = gpsInfo.getAltitude().floatValue();
        if (latitude == -1.0f && longitude == -1.0f && altitude == -1.0f) {
            return null;
        }
        if (latitude >= 0.0f) {
            gpsDataType.setLatitude(GPS_FORMAT.format(latitude));
        }
        if (longitude >= 0.0f) {
            gpsDataType.setLongitude(GPS_FORMAT.format(longitude));
        }
        if (altitude >= 0.0f) {
            gpsDataType.setAltitude(GPS_FORMAT.format(altitude));
        }
        return gpsDataType;
    }

    private UidEnrolmentAudit.StepTransitions toStepTransitions() {
        UidEnrolmentAudit.StepTransitions transitions = new UidEnrolmentAudit.StepTransitions();
        this.enrollmentService.getEnrolSteps().forEach(stepInfo -> {
            StepTransitionType stepTransType = new StepTransitionType();
            stepTransType.setFromStep(stepInfo.getFromStep());
            stepTransType.setToStep(stepInfo.getToStep());
            stepTransType.setTimestamp(this.getTimestamp(stepInfo.getTimeStamp()));
            transitions.getTransitions().add(stepTransType);
        });
        return transitions;
    }

    private OperatorSupervisorType toOpSupType(UserDetails opsup) {
        OperatorSupervisorType opsupDetails = new OperatorSupervisorType();
        opsupDetails.setVersion(ApplicationVersion.VERSION);
        opsupDetails.setName(opsup.getFullName());
        opsupDetails.setOpid(opsup.getUserId());
        opsupDetails.setTimestamp(ECMPDateFormatHelper.getDateStr(new Date(), ECMPDateFormats.ISO_8601_DATE_FORMAT));
        return opsupDetails;
    }

    private void populateBiometricInfo(UidEnrolmentAudit audit) {
        LinkedHashMap<CaptureModality, BiometricsCaptureTrail> biometrics = this.enrollmentService.getBiometricsTrailMap();
        UidEnrolmentAudit.FingerCaptureList fplist = new UidEnrolmentAudit.FingerCaptureList();
        UidEnrolmentAudit.IrisCaptureList irlist = new UidEnrolmentAudit.IrisCaptureList();
        UidEnrolmentAudit.PhotoCaptureList facelist = new UidEnrolmentAudit.PhotoCaptureList();
        for (Object key : biometrics.keySet()) {
            String modalityType;
            BiometricsCaptureTrail biometricCaptureTrail = (BiometricsCaptureTrail)biometrics.get(key);
            String position = key.toString();
            switch (modalityType = StringUtils.trimToEmpty((String)biometricCaptureTrail.getModality().getType()).toLowerCase()) {
                case "finger": {
                    biometricCaptureTrail.getCaptureHistory().forEach(capture -> fplist.getFingerCaptures().add(this.populateFingerCaptureType(position, (BiometricsCapture)capture)));
                    if (biometricCaptureTrail.getBestCapture() != null) {
                        fplist.getFingerCaptures().add(this.populateFingerCaptureType(position, biometricCaptureTrail.getBestCapture()));
                    }
                    audit.setFingerCaptureList(fplist);
                    break;
                }
                case "iris": {
                    biometricCaptureTrail.getCaptureHistory().forEach(capture -> irlist.getIrisCaptures().add(this.populateIrisCaptureType(position, (BiometricsCapture)capture)));
                    if (biometricCaptureTrail.getBestCapture() != null) {
                        irlist.getIrisCaptures().add(this.populateIrisCaptureType(position, biometricCaptureTrail.getBestCapture()));
                    }
                    audit.setIrisCaptureList(irlist);
                    break;
                }
                case "face": {
                    biometricCaptureTrail.getCaptureHistory().forEach(capture -> facelist.getPhotoCaptures().add(this.populatePhotoCaptureType((BiometricsCapture)capture)));
                    if (biometricCaptureTrail.getBestCapture() != null) {
                        facelist.getPhotoCaptures().add(this.populatePhotoCaptureType(biometricCaptureTrail.getBestCapture()));
                    }
                    audit.setPhotoCaptureList(facelist);
                }
            }
        }
    }

    private String getTimestamp(long time) {
        return ISO_8601_DATE_FORMAT.format(time);
    }

    private FingerCaptureType populateFingerCaptureType(String position, BiometricsCapture biometricCapture) {
        FingerCaptureType fingerCaptureType = new FingerCaptureType();
        fingerCaptureType.setSlapPosition(position);
        fingerCaptureType.setStartTime(this.getTimestamp(biometricCapture.getStartTime()));
        fingerCaptureType.setEndTime(this.getTimestamp(biometricCapture.getEndTime()));
        fingerCaptureType.setManualIntervention(biometricCapture.isForcedCapture() ? ManualInterventionType.FORCED : ManualInterventionType.NONE);
        FingerprintQSS fingerprintQss = (FingerprintQSS)biometricCapture.getQss();
        FingerQssType fingerQssType = new FingerQssType();
        if (fingerprintQss != null) {
            fingerQssType.setOverallCompliance(ComplianceType.valueOf(fingerprintQss.getOverallCompliance().name()));
            fingerQssType.setOverallScore(fingerprintQss.getOverallScore());
            fingerQssType.setOverallComments(fingerprintQss.getOverallComments());
            fingerQssType.setOverallConfidenence(fingerprintQss.getOverallConfidence());
            fingerQssType.setHandedness(fingerprintQss.getHandedness());
            FingerQssType.FingerQualityFeedbackList qualityFeedbackList = new FingerQssType.FingerQualityFeedbackList();
            fingerprintQss.getQualityFeedback().forEach(fingerprintQualityFeedback -> {
                FingerQualityFeedbackType fingerQualityFeedbackType = new FingerQualityFeedbackType();
                fingerQualityFeedbackType.setCompliance(ComplianceType.valueOf(fingerprintQualityFeedback.getCompliance().name()));
                fingerQualityFeedbackType.setScore(fingerprintQualityFeedback.getScore());
                fingerQualityFeedbackType.setComments(fingerprintQualityFeedback.getComments());
                fingerQualityFeedbackType.setFingerQualityAttribute(fingerprintQualityFeedback.getQualityAttribute().name().replaceAll(" ", "_").toUpperCase());
                qualityFeedbackList.getFingerQualityFeedbacks().add(fingerQualityFeedbackType);
            });
            fingerQssType.setFingerQualityFeedbackList(qualityFeedbackList);
            FingerQssType.FingerSegmentList fingersegmentList = new FingerQssType.FingerSegmentList();
            for (FingerSegment fingerSegment : fingerprintQss.getFingerSegments()) {
                FingerQssType.FingerSegmentList.FingerSegments fingersegments = new FingerQssType.FingerSegmentList.FingerSegments();
                fingersegments.setFingerPosition(fingerSegment.getFingerPosition().name());
                fingersegments.setQuality(fingerSegment.getQuality());
                fingersegments.setTopleft(this.getPoint(fingerSegment.getTopLeft()));
                fingersegments.setTopright(this.getPoint(fingerSegment.getTopRight()));
                fingersegments.setBottomleft(this.getPoint(fingerSegment.getBottomLeft()));
                fingersegments.setBottomright(this.getPoint(fingerSegment.getBottomRight()));
                if (biometricCapture.isFtcFlag()) {
                    fingersegments.setFailureToCapture(biometricCapture.isFtcFlag());
                }
                fingersegmentList.getFingerSegments().add(fingersegments);
            }
            fingerQssType.setFingerSegmentList(fingersegmentList);
        }
        fingerCaptureType.setQss(fingerQssType);
        return fingerCaptureType;
    }

    private IrisCaptureType populateIrisCaptureType(String position, BiometricsCapture biometricsCapture) {
        IrisCaptureType irisCaptureType = new IrisCaptureType();
        irisCaptureType.setIrisPosition(position);
        irisCaptureType.setStartTime(this.getTimestamp(biometricsCapture.getStartTime()));
        irisCaptureType.setEndTime(this.getTimestamp(biometricsCapture.getEndTime()));
        irisCaptureType.setManualIntervention(biometricsCapture.isForcedCapture() ? ManualInterventionType.FORCED : ManualInterventionType.NONE);
        IrisQSS irisQss = (IrisQSS)biometricsCapture.getQss();
        IrisQssType irisQssType = new IrisQssType();
        if (irisQss != null) {
            Compliance compliance = irisQss.getOverallCompliance();
            irisQssType.setOverallCompliance(ComplianceType.valueOf(compliance.name()));
            irisQssType.setOverallScore(irisQss.getOverallScore());
            irisQssType.setOverallComments(irisQss.getOverallComments());
            IrisQssType.IrisQualityFeedbackList qualityFeedbackList = new IrisQssType.IrisQualityFeedbackList();
            irisQss.getQualityFeedback().forEach(irisQualityFeedback -> {
                IrisQualityFeedbackType irisQualityFeedbackType = new IrisQualityFeedbackType();
                irisQualityFeedbackType.setCompliance(ComplianceType.valueOf(irisQualityFeedback.getCompliance().name()));
                irisQualityFeedbackType.setScore(irisQualityFeedback.getScore());
                irisQualityFeedbackType.setComments(irisQualityFeedback.getComments());
                irisQualityFeedbackType.setIrisQualityAttribute(irisQualityFeedback.getQualityAttribute().toString().replaceAll(" ", "_").toUpperCase());
                qualityFeedbackList.getIrisQualityFeedbacks().add(irisQualityFeedbackType);
            });
            irisQssType.setIrisQualityFeedbackList(qualityFeedbackList);
            IrisQssType.IrisLandmarkList landmarkList = new IrisQssType.IrisLandmarkList();
            irisQss.getLandMarkList().forEach(landmrk -> {
                IrisQssType.IrisLandmarkList.Landmark lmark = new IrisQssType.IrisLandmarkList.Landmark();
                lmark.setLandmarkType(landmrk.getLandMarkType().toString().replaceAll(this.regex, this.replacement).toUpperCase());
                lmark.setValue(new BigInteger("" + landmrk.getValue()));
                lmark.setX(new BigInteger("" + landmrk.getX()));
                lmark.setY(new BigInteger("" + landmrk.getY()));
                irisQssType.setIrisLandmarkList(landmarkList);
                irisQssType.getIrisLandmarkList().getLandmarks().add(lmark);
            });
        }
        irisCaptureType.setQss(irisQssType);
        return irisCaptureType;
    }

    private PhotoCaptureType populatePhotoCaptureType(BiometricsCapture biometricCapture) {
        PhotoCaptureType photoCaptureType = new PhotoCaptureType();
        photoCaptureType.setStartTime(this.getTimestamp(biometricCapture.getStartTime()));
        photoCaptureType.setEndTime(this.getTimestamp(biometricCapture.getEndTime()));
        photoCaptureType.setManualIntervention(biometricCapture.isForcedCapture() ? ManualInterventionType.FORCED : ManualInterventionType.NONE);
        FaceQssType faceQssType = new FaceQssType();
        FaceQSS faceQss = (FaceQSS)biometricCapture.getQss();
        if (faceQss != null) {
            faceQssType.setOverallCompliance(ComplianceType.valueOf(faceQss.getOverallCompliance().name()));
            faceQssType.setOverallScore(faceQss.getOverallScore());
            faceQssType.setOverallComments(faceQss.getOverallComments());
            FaceQssType.FaceQualityFeedbackList qualityFeedbackList = new FaceQssType.FaceQualityFeedbackList();
            faceQss.getQualityFeedback().forEach(faceQualityFeedback -> {
                FaceQualityFeedbackType faceQualityFeedbackType = new FaceQualityFeedbackType();
                faceQualityFeedbackType.setComments(faceQualityFeedback.getComments());
                faceQualityFeedbackType.setFaceQualityAttribute(faceQualityFeedback.getQualityAttribute().toString().replaceAll(" ", "_").toUpperCase());
                faceQualityFeedbackType.setScore(faceQualityFeedback.getScore());
                faceQualityFeedbackType.setCompliance(ComplianceType.valueOf(faceQualityFeedback.getCompliance().name()));
                qualityFeedbackList.getFaceQualityFeedbacks().add(faceQualityFeedbackType);
            });
            faceQssType.setFaceQualityFeedbackList(qualityFeedbackList);
            FaceQssType.FaceLandmarkList landmarkList = new FaceQssType.FaceLandmarkList();
            faceQss.getLandMarkList().forEach(landMark -> {
                FaceQssType.FaceLandmarkList.Landmark landmark = new FaceQssType.FaceLandmarkList.Landmark();
                landmark.setLandmarkType(landMark.getLandMarkType().toString().replaceAll(this.regex, this.replacement).toUpperCase());
                landmark.setValue(new BigInteger("" + landMark.getValue()));
                landmark.setX(new BigInteger("" + landMark.getX()));
                landmark.setY(new BigInteger("" + landMark.getY()));
                landmarkList.getLandmarks().add(landmark);
            });
            faceQssType.setFaceLandmarkList(landmarkList);
        }
        photoCaptureType.setQss(faceQssType);
        return photoCaptureType;
    }

    private Point getPoint(java.awt.Point pt) {
        Point point = new Point();
        point.setX(pt.x);
        point.setY(pt.y);
        return point;
    }
}

