/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.packetgenerator;

import in.gov.uidai.ec.escapi.PacketStructureMissingException;
import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.service.enrol.BodyPart;
import in.gov.uidai.ec.service.enrol.ECMPDateFormatHelper;
import in.gov.uidai.ec.service.enrol.ECMPDateFormats;
import in.gov.uidai.ec.service.enrollment.BiometricsCapture;
import in.gov.uidai.ec.service.enrollment.BiometricsCaptureTrail;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.packetgenerator._CbeffGenerator;
import in.gov.uidai.ec.service.packetgenerator._DemoDOMBuilder;
import in.gov.uidai.ec.service.packetgenerator.xml.BDBInfoType;
import in.gov.uidai.ec.service.packetgenerator.xml.BIRInfoType;
import in.gov.uidai.ec.service.packetgenerator.xml.BiometricCaptureType;
import in.gov.uidai.ec.service.packetgenerator.xml.Bir;
import in.gov.uidai.ec.service.packetgenerator.xml.RevisionType;
import in.gov.uidai.ec.service.packetgenerator.xml.UidEnrolmentResidentAuth;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class _BiometricsDOMBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(_BiometricsDOMBuilder.class);
    private static final String FACE = "face";
    private static final String IRIS = "iris";
    private static final String FINGER = "finger";
    private static final String FORMAT_TYPE_FACE = "8";
    private static final String FORMAT_TYPE_IRIS = "9";
    private static final String FORMAT_TYPE_FINGER = "7";
    private static final String FORMAT_OWNER = "257";

    _BiometricsDOMBuilder() {
    }

    private static BIRInfoType getBIRInfoType(CaptureModality modality, int attempt, long captureTime) {
        BIRInfoType birInfo = new BIRInfoType();
        birInfo.setCreationDate(ECMPDateFormatHelper.getDateStr(new Date(captureTime), ECMPDateFormats.BIO_XML_PACKET_DATE_FORMAT));
        birInfo.setIntegrity(false);
        birInfo.setIndex(_CbeffGenerator.getCbeffIndex(modality, attempt));
        return birInfo;
    }

    private static BIRInfoType getBIRInfoType(long creationTime) {
        BIRInfoType birInfo = new BIRInfoType();
        birInfo.setCreationDate(ECMPDateFormatHelper.getDateStr(new Date(creationTime), ECMPDateFormats.BIO_XML_PACKET_DATE_FORMAT));
        birInfo.setIntegrity(false);
        birInfo.setIndex("0");
        return birInfo;
    }

    private static RevisionType getVersionInfo() {
        RevisionType version = new RevisionType();
        version.setMajor(1);
        version.setMinor(0);
        return version;
    }

    private static RevisionType getCBEFFVersionInfo() {
        RevisionType cbeffVersion = new RevisionType();
        cbeffVersion.setMajor(2);
        cbeffVersion.setMinor(0);
        return cbeffVersion;
    }

    private static BDBInfoType getBDBInfoType(String type, String subType, String formatType, long creationTime) {
        BDBInfoType bdbInfo = new BDBInfoType();
        bdbInfo.setEncryption(false);
        bdbInfo.setCreationDate(ECMPDateFormatHelper.getDateStr(new Date(creationTime), ECMPDateFormats.BIO_XML_PACKET_DATE_FORMAT));
        bdbInfo.setFormatOwner(FORMAT_OWNER);
        bdbInfo.setFormatType(formatType);
        if (subType == null) {
            bdbInfo.setType(type);
        } else {
            bdbInfo.setSubtype(subType);
        }
        return bdbInfo;
    }

    private static String getSubTypeForIris(List<BodyPart> bodyPartList) {
        for (BodyPart bodyPart : bodyPartList) {
            switch (bodyPart) {
                case IRIS_LEFT: {
                    return "left";
                }
                case IRIS_RIGHT: {
                    return "right";
                }
            }
        }
        return null;
    }

    private static String getSubTypeForFingerSlap(List<BodyPart> bodyPartList) {
        StringBuilder sBuffer = new StringBuilder();
        String subTypeMod = null;
        for (BodyPart bodyPart : bodyPartList) {
            String bodyPartName = bodyPart.name();
            if (subTypeMod == null) {
                subTypeMod = bodyPartName.substring(bodyPartName.lastIndexOf("_") + 1);
                sBuffer.append(subTypeMod.toLowerCase());
                sBuffer.append(" ");
            }
            String subTypeElements = bodyPartName.substring(0, bodyPartName.lastIndexOf("_"));
            sBuffer.append(subTypeElements.toLowerCase().replaceAll("_", "-"));
            sBuffer.append(" ");
        }
        return sBuffer.toString().trim();
    }

    private static String getSubTypeForThumbSlap(List<BodyPart> bodyPartList) {
        StringBuilder sBuffer = new StringBuilder();
        String subTypeElements = "";
        for (BodyPart bodyPart : bodyPartList) {
            String bodyPartName = bodyPart.name();
            String subTypeMod = bodyPartName.substring(bodyPartName.lastIndexOf("_") + 1);
            sBuffer.append(subTypeMod.toLowerCase());
            sBuffer.append(" ");
            subTypeElements = bodyPartName.substring(0, bodyPartName.lastIndexOf("_"));
        }
        sBuffer.append(subTypeElements.toLowerCase().replaceAll("_", "-"));
        sBuffer.append(" ");
        return sBuffer.toString().trim();
    }

    private static String getSubType(CaptureModality bodyPart, List<BodyPart> bodyPartList) {
        switch (bodyPart) {
            case LEFT_SLAP: 
            case RIGHT_SLAP: {
                return _BiometricsDOMBuilder.getSubTypeForFingerSlap(bodyPartList);
            }
            case THUMB_SLAP: {
                return _BiometricsDOMBuilder.getSubTypeForThumbSlap(bodyPartList);
            }
            case LEFT_IRIS: 
            case RIGHT_IRIS: {
                return _BiometricsDOMBuilder.getSubTypeForIris(bodyPartList);
            }
        }
        return null;
    }

    static BiometricCaptureType toBioCapture4User(BiometricsCapture biometrics, CaptureModality modality) throws Exception {
        if (biometrics == null) {
            return null;
        }
        BiometricCaptureType biometricsDOM = new BiometricCaptureType();
        biometricsDOM.setBestAttempt(true);
        biometricsDOM.setDeleted(biometrics.isDeleted());
        BiometricCaptureType.BodyPartList bodyPartList = new BiometricCaptureType.BodyPartList();
        bodyPartList.getBodyParts().addAll(_DemoDOMBuilder.toBodyPartList(biometrics.getBodyParts()));
        biometricsDOM.setBodyPartList(bodyPartList);
        biometricsDOM.setCbeffIndex(_CbeffGenerator.getCbeffIndex(modality, 0));
        if (biometrics.getDeviceAttributes() != null && biometrics.getDeviceAttributes().size() > 0) {
            biometricsDOM.setDeviceInfo(_DemoDOMBuilder.toDeviceInfo(biometrics.getDeviceAttributes()));
        }
        biometricsDOM.setEndDate(ECMPDateFormatHelper.getDateStr(new Date(biometrics.getEndTime()), ECMPDateFormats.ISO_8601_DATE_FORMAT));
        biometricsDOM.setForced(biometrics.isForcedCapture());
        if (!biometrics.getMissingBodyParts().isEmpty()) {
            BiometricCaptureType.MissingPartList missingPartList = new BiometricCaptureType.MissingPartList();
            missingPartList.getBodyParts().addAll(_DemoDOMBuilder.toBodyPartList(biometrics.getMissingBodyParts()));
            biometricsDOM.setMissingPartList(missingPartList);
        }
        biometricsDOM.setQuality((int)biometrics.getQuality());
        biometricsDOM.setStartDate(ECMPDateFormatHelper.getDateStr(new Date(biometrics.getStartTime()), ECMPDateFormats.ISO_8601_DATE_FORMAT));
        return biometricsDOM;
    }

    static UidEnrolmentResidentAuth toResidentAuth(Map<CaptureModality, BiometricsCaptureTrail> biometrics, String eid, boolean addFaceTrail) throws Exception {
        UidEnrolmentResidentAuth auth = new UidEnrolmentResidentAuth();
        biometrics.keySet().stream().map(biometrics::get).filter(trail -> trail != null && (addFaceTrail || !trail.getModality().toString().equals("FACE"))).forEach(trail -> {
            try {
                auth.setBiometricCapture(_BiometricsDOMBuilder.toBioCapture4User(trail.getBestCapture(), trail.getModality()));
            }
            catch (Exception e) {
                try {
                    throw new PacketStructureMissingException(e.getMessage());
                }
                catch (PacketStructureMissingException ex) {
                    throw new RuntimeException(ex);
                }
            }
            auth.setModality(trail.getModality().toGroupName());
            auth.setEid(eid);
        });
        return auth;
    }

    public Bir toBir4Resident(Map<CaptureModality, BiometricsCaptureTrail> biometrics) {
        Bir residentBir = new Bir();
        residentBir.setVersion(_BiometricsDOMBuilder.getVersionInfo());
        residentBir.setCbeffVersion(_BiometricsDOMBuilder.getCBEFFVersionInfo());
        residentBir.setBirInfo(_BiometricsDOMBuilder.getBIRInfoType(System.currentTimeMillis()));
        Set distinctBodyPartTypes = biometrics.keySet().stream().map(CaptureModality::getType).collect(Collectors.toSet());
        for (String bodyPartType : distinctBodyPartTypes) {
            Bir distinctBodyPartBir = null;
            String formatType = null;
            if (StringUtils.equalsIgnoreCase((String)FACE, (String)bodyPartType)) {
                formatType = FORMAT_TYPE_FACE;
            } else if (StringUtils.equalsIgnoreCase((String)IRIS, (String)bodyPartType)) {
                formatType = FORMAT_TYPE_IRIS;
            } else if (StringUtils.equalsIgnoreCase((String)FINGER, (String)bodyPartType)) {
                formatType = FORMAT_TYPE_FINGER;
            }
            for (CaptureModality bodyPart : biometrics.keySet()) {
                if (!bodyPartType.equalsIgnoreCase(bodyPart.getType())) continue;
                BiometricsCaptureTrail trail = biometrics.get((Object)bodyPart);
                int index = 0;
                BiometricsCapture bestCapture = trail.getBestCapture();
                if ((bestCapture == null || bestCapture.getQuality() < 50.0) && trail.getCaptureHistory() != null && !trail.getCaptureHistory().isEmpty()) {
                    for (BiometricsCapture capture : trail.getCaptureHistory()) {
                        distinctBodyPartBir = this.getDistinctBodyPartBir(bodyPartType, distinctBodyPartBir, formatType, bodyPart, index, capture);
                        ++index;
                    }
                }
                if (bestCapture == null) continue;
                distinctBodyPartBir = this.getDistinctBodyPartBir(bodyPartType, distinctBodyPartBir, formatType, bodyPart, index, bestCapture);
            }
            if (distinctBodyPartBir == null) continue;
            residentBir.getBir().add(distinctBodyPartBir);
        }
        return residentBir;
    }

    private Bir getDistinctBodyPartBir(String bodyPartType, Bir distinctBodyPartBir, String formatType, CaptureModality bodyPart, int index, BiometricsCapture capture) {
        Bir captureBir = new Bir();
        captureBir.setBirInfo(_BiometricsDOMBuilder.getBIRInfoType(bodyPart, index, capture.getEndTime()));
        String subType = _BiometricsDOMBuilder.getSubType(bodyPart, capture.getBodyParts());
        captureBir.setBdbInfo(_BiometricsDOMBuilder.getBDBInfoType(bodyPartType, subType, formatType, capture.getEndTime()));
        try {
            if (null != capture.getBodyParts()) {
                if (bodyPartType.equalsIgnoreCase("FACE")) {
                    byte[] imgData = capture.getSampleDataByteArray();
                    if (imgData != null && imgData.length > 0) {
                        imgData[35] = 1;
                        captureBir.setBdb(imgData);
                    } else {
                        captureBir.setBdb(imgData);
                    }
                } else if (bodyPartType.equalsIgnoreCase("FINGER")) {
                    captureBir.setBdb(capture.getSampleDataByteArray());
                } else if (bodyPartType.equalsIgnoreCase("IRIS")) {
                    captureBir.setBdb(capture.getSampleDataByteArray());
                } else {
                    LOGGER.error("Missing Biometric Body parts");
                    throw new ClientException("Biometric Missing");
                }
                if (distinctBodyPartBir == null && capture.getSampleDataByteArray() != null) {
                    distinctBodyPartBir = new Bir();
                    distinctBodyPartBir.setBirInfo(_BiometricsDOMBuilder.getBIRInfoType(capture.getEndTime()));
                    distinctBodyPartBir.setBdbInfo(_BiometricsDOMBuilder.getBDBInfoType(bodyPartType, null, formatType, capture.getEndTime()));
                }
                if (distinctBodyPartBir != null && captureBir.getBdb() != null) {
                    distinctBodyPartBir.getBir().add(captureBir);
                }
            }
        }
        catch (ClientException e) {
            throw new ClientException("Biometric Missing");
        }
        return distinctBodyPartBir;
    }

    public final Bir toBir4User(BiometricsCapture bioCapture) {
        Bir rootBir = new Bir();
        rootBir.setVersion(_BiometricsDOMBuilder.getVersionInfo());
        rootBir.setCbeffVersion(_BiometricsDOMBuilder.getCBEFFVersionInfo());
        rootBir.setBirInfo(_BiometricsDOMBuilder.getBIRInfoType(bioCapture.getEndTime()));
        Bir userBioBir = new Bir();
        userBioBir.setBirInfo(_BiometricsDOMBuilder.getBIRInfoType(bioCapture.getEndTime()));
        userBioBir.setBdbInfo(_BiometricsDOMBuilder.getBDBInfoType(FINGER, null, FORMAT_TYPE_FINGER, bioCapture.getEndTime()));
        rootBir.getBir().add(userBioBir);
        Bir actualBioBir = new Bir();
        actualBioBir.setBirInfo(_BiometricsDOMBuilder.getBIRInfoType(bioCapture.getEndTime()));
        actualBioBir.setBdbInfo(_BiometricsDOMBuilder.getBDBInfoType(null, "unknown", FORMAT_TYPE_FINGER, bioCapture.getEndTime()));
        actualBioBir.setBdb(bioCapture.getSampleDataByteArray());
        userBioBir.getBir().add(actualBioBir);
        return rootBir;
    }
}

