/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.packetgenerator;

import in.gov.uidai.ec.service.enrol.BodyPart;
import in.gov.uidai.ec.service.enrollment.CaptureModality;

class _CbeffGenerator {
    private static final int LEFT_SLAP_SUB_TYPE = BodyPart.POINTER_FINGER_LEFT.getSubType() | BodyPart.MIDDLE_FINGER_LEFT.getSubType() | BodyPart.RING_FINGER_LEFT.getSubType() | BodyPart.LITTLE_FINGER_LEFT.getSubType();
    private static final int RIGHT_SLAP_SUB_TYPE = BodyPart.POINTER_FINGER_RIGHT.getSubType() | BodyPart.MIDDLE_FINGER_RIGHT.getSubType() | BodyPart.RING_FINGER_RIGHT.getSubType() | BodyPart.LITTLE_FINGER_RIGHT.getSubType();
    private static final int THUMB_SLAP_SUB_TYPE = BodyPart.THUMB_LEFT.getSubType() | BodyPart.THUMB_RIGHT.getSubType();
    private static final int RIGHT_INDEX_SUB_TYPE = BodyPart.POINTER_FINGER_RIGHT.getSubType();

    _CbeffGenerator() {
    }

    public static String getCbeffIndex(CaptureModality modality, int attempt) {
        int subType = 0;
        int type = 0;
        switch (modality) {
            case RIGHT_SLAP: {
                subType = RIGHT_SLAP_SUB_TYPE;
                type = BodyPart.POINTER_FINGER_RIGHT.getType();
                break;
            }
            case LEFT_SLAP: {
                subType = LEFT_SLAP_SUB_TYPE;
                type = BodyPart.POINTER_FINGER_LEFT.getType();
                break;
            }
            case FACE: {
                subType = BodyPart.FACE.getSubType();
                type = BodyPart.FACE.getType();
                break;
            }
            case LEFT_IRIS: {
                subType = BodyPart.IRIS_LEFT.getSubType();
                type = BodyPart.IRIS_LEFT.getType();
                break;
            }
            case RIGHT_IRIS: {
                subType = BodyPart.IRIS_RIGHT.getSubType();
                type = BodyPart.IRIS_RIGHT.getType();
                break;
            }
            case THUMB_SLAP: {
                subType = THUMB_SLAP_SUB_TYPE;
                type = BodyPart.THUMB_LEFT.getType();
                break;
            }
            default: {
                subType = RIGHT_INDEX_SUB_TYPE;
                type = BodyPart.POINTER_FINGER_RIGHT.getType();
            }
        }
        String cbeffIndex = type * 10000 + subType * 100 + attempt + "";
        return cbeffIndex;
    }
}

