/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.packetgenerator;

import in.gov.uidai.ec.escapi.DateMismatchException;
import in.gov.uidai.ec.escapi.DocumentDetailsException;
import in.gov.uidai.ec.escapi.LanguageCodeMissingException;
import in.gov.uidai.ec.escapi.PacketStructureMissingException;
import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.service.document.Document;
import in.gov.uidai.ec.service.document.DocumentService;
import in.gov.uidai.ec.service.enrol.BodyPart;
import in.gov.uidai.ec.service.enrol.EID;
import in.gov.uidai.ec.service.enrol.GuardianIdType;
import in.gov.uidai.ec.service.enrollment.BiometricsCapture;
import in.gov.uidai.ec.service.enrollment.BiometricsCaptureTrail;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.Demographics;
import in.gov.uidai.ec.service.enrollment.model.Gender;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.ReferenceDocument;
import in.gov.uidai.ec.service.enrollment.model.ReferenceIntroducer;
import in.gov.uidai.ec.service.enrollment.model.ReferenceRelative;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.service.packetgenerator._CbeffGenerator;
import in.gov.uidai.ec.service.packetgenerator.xml.BiometricCaptureTrailType;
import in.gov.uidai.ec.service.packetgenerator.xml.BiometricCaptureType;
import in.gov.uidai.ec.service.packetgenerator.xml.BodyPartType;
import in.gov.uidai.ec.service.packetgenerator.xml.DateOfBirthType;
import in.gov.uidai.ec.service.packetgenerator.xml.DeviceParameterType;
import in.gov.uidai.ec.service.packetgenerator.xml.DocumentType;
import in.gov.uidai.ec.service.packetgenerator.xml.ExtendedAttributes;
import in.gov.uidai.ec.service.packetgenerator.xml.GenderType;
import in.gov.uidai.ec.service.packetgenerator.xml.HeadOfFamilyType;
import in.gov.uidai.ec.service.packetgenerator.xml.IntroducerType;
import in.gov.uidai.ec.service.packetgenerator.xml.LinkEnrolmentType;
import in.gov.uidai.ec.service.packetgenerator.xml.ModeType;
import in.gov.uidai.ec.service.packetgenerator.xml.RelationType;
import in.gov.uidai.ec.service.packetgenerator.xml.ResidentBiometricType;
import in.gov.uidai.ec.service.packetgenerator.xml.UidEnrolmentProfile;
import in.gov.uidai.ec.service.packetgenerator.xml.VerificationProofType;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class _DemoDOMBuilder {
    private static final SimpleDateFormat ISO_8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final SimpleDateFormat INCOMING_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    SimpleDateFormat LOCAL_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final Logger LOGGER = LoggerFactory.getLogger(_DemoDOMBuilder.class);
    private static final String DEFAULT_OPTION = "Select";
    private final EnrollmentService enrollmentService;

    _DemoDOMBuilder(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    static BiometricCaptureType.DeviceInfo toDeviceInfo(Map<String, String> devAttributes) {
        BiometricCaptureType.DeviceInfo devInfo = new BiometricCaptureType.DeviceInfo();
        devAttributes.keySet().forEach(key -> {
            DeviceParameterType devParam = new DeviceParameterType();
            if (((String)devAttributes.get(key)).isEmpty()) {
                try {
                    throw new PacketStructureMissingException("Packet Structure validation error");
                }
                catch (PacketStructureMissingException e) {
                    throw new RuntimeException(e);
                }
            }
            devParam.setName((String)key);
            devParam.setValue((String)devAttributes.get(key));
            devInfo.getParameters().add(devParam);
        });
        return devInfo;
    }

    static List<BodyPartType> toBodyPartList(List<BodyPart> listOfBodyParts) {
        ArrayList<BodyPartType> bodyPartTypeList = new ArrayList<BodyPartType>(listOfBodyParts.size());
        listOfBodyParts.forEach(bodyPart -> {
            BodyPartType bodyPartType = new BodyPartType();
            bodyPartType.setType(bodyPart.getType());
            bodyPartType.setSubType(bodyPart.getSubType());
            bodyPartTypeList.add(bodyPartType);
        });
        return bodyPartTypeList;
    }

    public UidEnrolmentProfile getResidentDemographicsProfile() throws LanguageCodeMissingException, DocumentDetailsException, DateMismatchException, PacketStructureMissingException {
        ModeType modeType = this.enrollmentService.isUpdateEnrollment() ? ModeType.UPDATE : ModeType.NEW;
        EID enrolmentId = this.enrollmentService.getEnrolId();
        Demographics demographics = this.enrollmentService.getDemographics();
        PersonalDetail personalDetail = this.enrollmentService.getDemoPersonalDetails();
        Contact contact = demographics.getContact();
        Address address = contact.getAddress();
        UidEnrolmentProfile result = new UidEnrolmentProfile();
        result.setVersion(ApplicationVersion.VERSION);
        result.setEid(enrolmentId.toString());
        result.setEnrolmentNumber(enrolmentId.getEnrolNum());
        result.setMode(modeType);
        result.setInformationSharingConsent(true);
        switch (modeType) {
            case NEW: {
                result.setResName(personalDetail.getName().english());
                result.setLocalResName(personalDetail.getName().local());
                break;
            }
            case UPDATE: {
                result.setResOriginalName(personalDetail.getName().english());
                result.setLocalResOriginalName(personalDetail.getName().local());
                result.setNameChanged(personalDetail.getName().isUpdated());
                if (personalDetail.getName().isUpdated()) {
                    result.setResName(personalDetail.getName().newEnglish());
                    result.setLocalResName(personalDetail.getName().newNameLocal());
                }
                result.setLanguageChanged(this.enrollmentService.isLanguageUpdated());
                result.setAddressChanged(address.isUpdated());
                result.setGenderChanged(personalDetail.getApplicantGender().isUpdated());
                result.setMobileVerified(contact.getMobile().isUpdated());
                result.setEmailVerified(contact.getEmail().isUpdated());
                result.setDobChanged(personalDetail.getAgeDob().isUpdated());
                result.setBiometricsChanged(this.enrollmentService.isBiometricUpdate());
                result.setPhotoChanged(this.enrollmentService.isBiometricUpdate());
                result.setChildUpdate(personalDetail.getAgeDob().isChild());
                LinkEnrolmentType link = new LinkEnrolmentType();
                link.setLinkId(demographics.getPersonalDetail().getAadhaarNumber().getAadhaarNumber());
                link.setLinkIdType("UID");
                result.setLinkedEnrolment(link);
            }
        }
        if (modeType == ModeType.NEW || result.isBiometricsChanged() != null && result.isBiometricsChanged().booleanValue()) {
            ArrayList<BiometricsCaptureTrail> trailList = new ArrayList<BiometricsCaptureTrail>(this.enrollmentService.getBiometricsTrailMap().values());
            trailList.addAll(this.enrollmentService.getBiometricsExceptionTrailMap().values());
            result.setBiometricCapture(this.toResidentBiometricType(trailList));
        }
        try {
            String eidDateAndTime = ISO_8601_DATE_FORMAT.format(INCOMING_DATE_FORMAT.parse(result.getEid().substring(14)));
            String eidDate = eidDateAndTime.substring(0, 10).replace("-", "");
            LocalDate current = LocalDate.now();
            String convertedLocalDate = this.DATE_FORMAT.format(this.LOCAL_DATE_FORMAT.parse(String.valueOf(current)));
            LOGGER.debug("Eid Date :- " + eidDate + " Local date :- " + convertedLocalDate);
            if (!eidDate.equalsIgnoreCase(convertedLocalDate)) {
                throw new DateMismatchException("Enrolmemt and Local date Mismatch Error");
            }
            result.setEnrolmentDate(eidDateAndTime);
        }
        catch (ParseException e) {
            LOGGER.error("unable to parse", (Throwable)e);
        }
        result.setGender(this.toGenderType(personalDetail.getApplicantGender().getGender()));
        result.setDob(this.toDOBType(personalDetail.getAgeDob()));
        if (this.enrollmentService.getReferences().getPob().isMandatory() && null == result.getDob() || this.enrollmentService.getReferences().getPob().isMandatory() && null != result.getDob() && null != result.getDob().getPOB() && (StringUtils.isBlank((String)result.getDob().getPOB().getDocumentId()) || StringUtils.isBlank((String)result.getDob().getPOB().getDocumentType()))) {
            LOGGER.error("Verification tag missing  :: POB= " + this.enrollmentService.getReferences().getPob().isMandatory());
            throw new PacketStructureMissingException("Packet structure is invalid");
        }
        if (this.enrollmentService.isHofEnrollment() && (modeType.equals((Object)ModeType.NEW) || contact.getAddress().isUpdated())) {
            result.setCareof(StringUtils.isNotBlank((String)this.enrollmentService.getRelativeDetails().getName()) ? String.format("%s: %s", address.getCareOf(), this.enrollmentService.getRelativeDetails().getName()) : "");
        } else {
            result.setCareof("");
        }
        result.setBuilding(address.getBuilding());
        result.setStreet(address.getStreet());
        result.setLandmark(address.getLandmark());
        result.setLocality(address.getLocality());
        result.setBuildingLabel(address.getBuildingLabel());
        result.setStreetLabel(address.getStreetLabel());
        result.setLandmarkLabel(address.getLandmarkLabel());
        result.setLocalityLabel(address.getLocalityLabel());
        result.setVtcName(address.getVTC());
        result.setVtc(address.getVTCCode());
        result.setDistrictName(address.getDistrict());
        result.setDistrict(address.getDistrictCode());
        result.setSubDistrictName(address.getSubDistrict());
        result.setSubDistrict(address.getSubDistrictCode());
        result.setStateName(address.getState());
        result.setState(address.getStateCode());
        result.setPincode(address.getPinCodeValue());
        result.setPoName(address.isMandatory() ? address.getPoName() : null);
        result.setPoType(address.isMandatory() ? address.getPoType().toString() : null);
        result.setCountry(address.isMandatory() ? address.getCountryCode() : null);
        result.setDefaultPoName(address.isMandatory() ? address.getDefaultPoName() : null);
        result.setMobile(contact.getMobile().number());
        result.setIsdCode(contact.getMobile().isdCode());
        result.setEmail(contact.getEmail().email());
        result.setNRI(this.enrollmentService.getDemoResidentialStatus().isNriResidentAsString());
        if (!StringUtils.isNotBlank((String)this.enrollmentService.getEnrollmentLangCode())) {
            LOGGER.error("Language Code missing :: " + (StringUtils.isNotBlank((String)this.enrollmentService.getEnrollmentLangCode()) ? this.enrollmentService.getEnrollmentLangCode() : null));
            throw new LanguageCodeMissingException("Language Code missing");
        }
        result.setLangCode(this.enrollmentService.getEnrollmentLangCode());
        if (this.enrollmentService.isHofEnrollment() && (modeType.equals((Object)ModeType.NEW) || contact.getAddress().isUpdated())) {
            result.setLocalCareof(StringUtils.isNotBlank((String)this.enrollmentService.getRelativeDetails().getNameLocal()) ? String.format("%s: %s", address.getCareOfLocal(), this.enrollmentService.getRelativeDetails().getNameLocal()) : "");
        } else {
            result.setLocalCareof("");
        }
        result.setLocalBuilding(address.getBuildingLocal());
        result.setLocalStreet(address.getStreetLocal());
        result.setLocalLandmark(address.getLandmarkLocal());
        result.setLocalLocality(address.getLocalityLocal());
        result.setLocalBuildingLabel(address.getBuildingLabelLocal());
        result.setLocalStreetLabel(address.getStreetLabelLocal());
        result.setLocalLandmarkLabel(address.getLandmarkLabelLocal());
        result.setLocalLocalityLabel(address.getLocalityLabelLocal());
        result.setLocalVtc(address.getVTCLocal());
        result.setLocalDistrict(address.getDistrictLocal());
        result.setLocalSubDistrict(address.getSubDistrictLocal());
        result.setLocalState(address.getStateLocal());
        result.setLocalCountry(address.getCountryCode());
        result.setPoNameLocal(address.getPoNameLocal());
        result.setRelation(this.toRelationType());
        if (this.enrollmentService.getRelativeDetails().isMandatory() && (StringUtils.isBlank((String)this.enrollmentService.getRelativeDetails().getAadhaarNumber()) && StringUtils.isBlank((String)this.enrollmentService.getRelativeDetails().getEnrolmentId()) || StringUtils.isBlank((String)this.enrollmentService.getRelativeDetails().getRelationshipType().toString()) || StringUtils.isBlank((String)this.enrollmentService.getRelativeDetails().getName()))) {
            LOGGER.error("Verification tag missing  :: Aadhaar Number= " + this.enrollmentService.getRelativeDetails().getAadhaarNumber() + " Relation Type = " + this.enrollmentService.getRelativeDetails().getRelationshipType().toString() + " Name= " + this.enrollmentService.getRelativeDetails().getName());
            throw new PacketStructureMissingException("Packet structure is invalid :: Relation tag missing");
        }
        if (this.enrollmentService.isUpdateEnrollment()) {
            result.setVerification(this.toVerificationProofType(address, personalDetail.getName().isUpdated(), this.enrollmentService.isDocumentUpdate(), this.enrollmentService.isOffLineDocumentUpdate(), this.enrollmentService.isNRIEnrolment()));
        } else {
            result.setVerification(this.toVerificationProofType());
        }
        LOGGER.info("Verification tag missing  :: POA= " + this.enrollmentService.getReferences().getPoa().isMandatory() + " POI= " + this.enrollmentService.getReferences().getPoi().isMandatory() + " POR= " + this.enrollmentService.getReferences().getPor().isMandatory());
        if ((this.enrollmentService.getReferences().getPoa().isMandatory() || this.enrollmentService.getReferences().getPoi().isMandatory() || this.enrollmentService.getReferences().getPor().isMandatory()) && null == result.getVerification() || this.enrollmentService.getReferences().getPoa().isMandatory() && null != result.getVerification() && (StringUtils.isBlank((String)result.getVerification().getDocument().getPOA().getDocumentId()) || StringUtils.isBlank((String)result.getVerification().getDocument().getPOA().getDocumentType())) || this.enrollmentService.getReferences().getPoi().isMandatory() && null != result.getVerification() && (StringUtils.isBlank((String)result.getVerification().getDocument().getPOI().getDocumentId()) || StringUtils.isBlank((String)result.getVerification().getDocument().getPOI().getDocumentType())) || this.enrollmentService.getReferences().getPor().isMandatory() && null == result.getVerification() && (StringUtils.isBlank((String)result.getVerification().getHeadOfFamily().getDocumentId()) || StringUtils.isBlank((String)result.getVerification().getHeadOfFamily().getHofVerificationType()) || StringUtils.isBlank((String)result.getVerification().getHeadOfFamily().getName()))) {
            LOGGER.error("Verification tag missing  :: POA= " + this.enrollmentService.getReferences().getPoa().isMandatory() + " POI= " + this.enrollmentService.getReferences().getPoi().isMandatory() + " POR= " + this.enrollmentService.getReferences().getPor().isMandatory());
            throw new PacketStructureMissingException("Packet structure is invalid :: Verification tag missing");
        }
        result.setNoOfDocumentPages(new BigInteger("1"));
        ExtendedAttributes xattr = new ExtendedAttributes();
        this.addExtendedAttribute(xattr, "ecmp-client-version", ApplicationVersion.FULLDISPLAYVERSION);
        this.addExtendedAttribute(xattr, "ecmp-client-os", ApplicationVersion.OS);
        this.addExtendedAttribute(xattr, "ecmp-client-arch", ApplicationVersion.ARCH);
        if (StringUtils.isNotBlank((String)this.enrollmentService.getAppointmentId())) {
            this.addExtendedAttribute(xattr, "ecmp-appointment-id", this.enrollmentService.getAppointmentId());
        }
        this.addExtendedAttribute(xattr, "ecmp-is-nri", this.enrollmentService.isNRIEnrolment() ? "Y" : "N");
        this.addExtendedAttribute(xattr, "NPR Receipt Number", StringUtils.isBlank((String)this.enrollmentService.getNPRNumber()) ? "Not Given" : this.enrollmentService.getNPRNumber());
        this.addExtendedAttribute(xattr, "Document Update", this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOffLineDocumentUpdate() ? "Y" : "N");
        result.setExtendedAttributes(xattr);
        return result;
    }

    private void addExtendedAttribute(ExtendedAttributes xattr, String userDefDataKey, String value) {
        ExtendedAttributes.Attribute attribute = new ExtendedAttributes.Attribute();
        attribute.setKey(userDefDataKey);
        attribute.setValue(value);
        xattr.getAttributes().add(attribute);
    }

    private GenderType toGenderType(Gender gender) {
        if (gender == null) {
            return null;
        }
        switch (gender) {
            case MALE: {
                return GenderType.M;
            }
            case FEMALE: {
                return GenderType.F;
            }
            case TRANSGENDER: {
                return GenderType.T;
            }
        }
        return null;
    }

    private DateOfBirthType toDOBType(AgeDob dob) {
        try {
            if (dob == null || !dob.isValid() || !dob.isMandatory()) {
                return null;
            }
            DateOfBirthType result = new DateOfBirthType();
            result.setDay(dob.getDay());
            result.setMonth(dob.getMonth());
            result.setYear(dob.getYear());
            if (dob.getStatus() != null) {
                result.setStatus(dob.getStatus());
                if (result.getStatus().toString().equals(dob.getStatus().toString())) {
                    result.setPOB(this.getPOB());
                }
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("DocumentID or DocumentName");
            throw new ClientException("Relative details missing");
        }
    }

    private DateOfBirthType.POB getPOB() {
        ReferenceDocument pob = this.enrollmentService.getReferences().getPob();
        DateOfBirthType.POB pobNode = null;
        if (StringUtils.isNotBlank((String)pob.getProof().getDocName()) && !StringUtils.equalsIgnoreCase((String)pob.getProof().getDocName(), (String)DEFAULT_OPTION)) {
            pobNode = new DateOfBirthType.POB();
            pobNode.setDocumentType(pob.getProof().getDocName());
            pobNode.setDocumentId(pob.getProof().getDocId());
        }
        return pobNode;
    }

    private RelationType toRelationType() {
        try {
            ReferenceRelative relativeDetails = this.enrollmentService.getRelativeDetails();
            if (!relativeDetails.isMandatory() || StringUtils.isBlank((String)relativeDetails.getName())) {
                return null;
            }
            RelationType relation = new RelationType();
            relation.setRelName(relativeDetails.getName());
            relation.setLocalRelName(relativeDetails.getNameLocal());
            relation.setRelType(relativeDetails.getRelationshipType().toMnemonic());
            if (relativeDetails.isAadhaarNumberMandatory()) {
                relation.setRelIdType(GuardianIdType.UID.toString());
                relation.setRelId(relativeDetails.getAadhaarNumber());
            } else if (relativeDetails.isEnrolmentIdMandatory()) {
                relation.setRelIdType(GuardianIdType.EID.toString());
                relation.setRelId(relativeDetails.getRelativeEID());
            }
            return relation;
        }
        catch (Exception e) {
            LOGGER.error("DocumentID or DocumentName");
            throw new ClientException("Relative details missing");
        }
    }

    private VerificationProofType toVerificationProofType(Address address, boolean nameUpdate, boolean isOnlineDocumentUpdate, boolean isOfflineDocumentUpdate, boolean isNRIUpdate) throws DocumentDetailsException {
        try {
            VerificationProofType vpt = null;
            References references = this.enrollmentService.getReferences();
            ReferenceDocument poi = references.getPoi();
            ReferenceDocument poa = references.getPoa();
            ReferenceDocument hofDoc = references.getHofDoc();
            ReferenceIntroducer referenceIntroducer = references.getReferenceIntroducer();
            DocumentService documentService = this.enrollmentService.getDocumentService();
            if (poa.isMandatory() && (address.isUpdated() || isOnlineDocumentUpdate || isOfflineDocumentUpdate) || poi.isMandatory() && (nameUpdate || isOnlineDocumentUpdate || isOfflineDocumentUpdate || isNRIUpdate)) {
                vpt = new VerificationProofType();
                DocumentType docType = new DocumentType();
                if (StringUtils.isNotBlank((String)poa.getProof().getDocId()) && StringUtils.isNotBlank((String)poa.getProof().getDocName())) {
                    Document document = documentService.getDocument(in.gov.uidai.ec.service.document.DocumentType.POA, poa.getProof().getDocName());
                    DocumentType.POA poaNode = new DocumentType.POA();
                    if (!document.getDocumentId().equalsIgnoreCase(poa.getProof().getDocId()) || !document.getDocumentName().equalsIgnoreCase(poa.getProof().getDocName())) {
                        throw new DocumentDetailsException("POA DocumentID or DocumentName is not matching.");
                    }
                    poaNode.setDocumentType(poa.getProof().getDocName());
                    poaNode.setDocumentId(poa.getProof().getDocId());
                    docType.setPOA(poaNode);
                } else if (poa.isMandatory()) {
                    LOGGER.error("POA ::: Doc ID missing :: " + (StringUtils.isNotBlank((String)poa.getProof().getDocId()) ? poa.getProof().getDocId() : null) + " ::: Doc Name ::" + (StringUtils.isNotBlank((String)poa.getProof().getDocName()) ? poa.getProof().getDocName() : null));
                    throw new DocumentDetailsException("POA Document Details are Missing.");
                }
                if (StringUtils.isNotBlank((String)poi.getProof().getDocId()) && StringUtils.isNotBlank((String)poi.getProof().getDocName())) {
                    DocumentType.POI poiNode = new DocumentType.POI();
                    Document document = documentService.getDocument(in.gov.uidai.ec.service.document.DocumentType.POI, poi.getProof().getDocName());
                    if (!document.getDocumentId().equalsIgnoreCase(poi.getProof().getDocId()) || !document.getDocumentName().equalsIgnoreCase(poi.getProof().getDocName())) {
                        throw new DocumentDetailsException("POI DocumentID or DocumentName is not matching.");
                    }
                    poiNode.setDocumentType(poi.getProof().getDocName());
                    poiNode.setDocumentId(poi.getProof().getDocId());
                    docType.setPOI(poiNode);
                } else if (poi.isMandatory()) {
                    LOGGER.error("POI Doc ID missing :: " + (StringUtils.isNotBlank((String)poi.getProof().getDocId()) ? poi.getProof().getDocId() : null) + " ::: Doc Name ::" + (StringUtils.isNotBlank((String)poi.getProof().getDocName()) ? poi.getProof().getDocName() : null));
                    throw new DocumentDetailsException("POI Document Details are Missing.");
                }
                vpt.setDocument(docType);
            } else if (referenceIntroducer.isMandatory()) {
                IntroducerType itype = new IntroducerType();
                itype.setId(referenceIntroducer.getAadhaarNumber());
                itype.setName(referenceIntroducer.getName());
                vpt.setIntroducer(itype);
            } else if (hofDoc.isMandatory()) {
                vpt = new VerificationProofType();
                ReferenceRelative relativeDetails = this.enrollmentService.getRelativeDetails();
                HeadOfFamilyType hofNode = new HeadOfFamilyType();
                if (relativeDetails.isAadhaarNumberMandatory()) {
                    hofNode.setHeadOfFamilyId(relativeDetails.getAadhaarNumber());
                    hofNode.setHeadOfFamilyIdType(GuardianIdType.UID.toString());
                } else if (relativeDetails.isEnrolmentIdMandatory()) {
                    hofNode.setHeadOfFamilyId(relativeDetails.getRelativeEID());
                    hofNode.setHeadOfFamilyIdType(GuardianIdType.EID.toString());
                }
                hofNode.setHofVerificationType(hofDoc.getProof().getDocName());
                hofNode.setDocumentId(hofDoc.getProof().getDocId());
                hofNode.setName(relativeDetails.getName());
                vpt.setHeadOfFamily(hofNode);
            }
            return vpt;
        }
        catch (DocumentDetailsException e) {
            LOGGER.error("DocumentID or DocumentName");
            throw new DocumentDetailsException("POI/POA Document Details are Missing.");
        }
    }

    private VerificationProofType toVerificationProofType() throws DocumentDetailsException {
        try {
            VerificationProofType vpt = null;
            References references = this.enrollmentService.getReferences();
            ReferenceDocument poi = references.getPoi();
            ReferenceDocument poa = references.getPoa();
            ReferenceDocument hofDoc = references.getHofDoc();
            ReferenceIntroducer referenceIntroducer = references.getReferenceIntroducer();
            DocumentService documentService = this.enrollmentService.getDocumentService();
            if (poa.isMandatory() || poi.isMandatory()) {
                vpt = new VerificationProofType();
                DocumentType docType = new DocumentType();
                if (StringUtils.isNotBlank((String)poa.getProof().getDocId()) && StringUtils.isNotBlank((String)poa.getProof().getDocName())) {
                    Document document = documentService.getDocument(in.gov.uidai.ec.service.document.DocumentType.POA, poa.getProof().getDocName());
                    DocumentType.POA poaNode = new DocumentType.POA();
                    if (!document.getDocumentId().equalsIgnoreCase(poa.getProof().getDocId()) || !document.getDocumentName().equalsIgnoreCase(poa.getProof().getDocName())) {
                        throw new DocumentDetailsException("POA DocumentID or DocumentName is not matching.");
                    }
                    poaNode.setDocumentType(poa.getProof().getDocName());
                    poaNode.setDocumentId(poa.getProof().getDocId());
                    docType.setPOA(poaNode);
                } else if (poa.isMandatory()) {
                    LOGGER.error("POA ::: Doc ID missing :: " + (StringUtils.isNotBlank((String)poa.getProof().getDocId()) ? poa.getProof().getDocId() : null) + " ::: Doc Name ::" + (StringUtils.isNotBlank((String)poa.getProof().getDocName()) ? poa.getProof().getDocName() : null));
                    throw new DocumentDetailsException("POA Document Details are Missing.");
                }
                if (StringUtils.isNotBlank((String)poi.getProof().getDocId()) && StringUtils.isNotBlank((String)poi.getProof().getDocName())) {
                    DocumentType.POI poiNode = new DocumentType.POI();
                    Document document = documentService.getDocument(in.gov.uidai.ec.service.document.DocumentType.POI, poi.getProof().getDocName());
                    if (!document.getDocumentId().equalsIgnoreCase(poi.getProof().getDocId()) || !document.getDocumentName().equalsIgnoreCase(poi.getProof().getDocName())) {
                        throw new DocumentDetailsException("POI DocumentID or DocumentName is not matching.");
                    }
                    poiNode.setDocumentType(poi.getProof().getDocName());
                    poiNode.setDocumentId(poi.getProof().getDocId());
                    docType.setPOI(poiNode);
                } else if (poi.isMandatory()) {
                    LOGGER.error("POI Doc ID missing :: " + (StringUtils.isNotBlank((String)poi.getProof().getDocId()) ? poi.getProof().getDocId() : null) + " ::: Doc Name ::" + (StringUtils.isNotBlank((String)poi.getProof().getDocName()) ? poi.getProof().getDocName() : null));
                    throw new DocumentDetailsException("POI Document Details are Missing.");
                }
                vpt.setDocument(docType);
            } else if (referenceIntroducer.isMandatory()) {
                IntroducerType itype = new IntroducerType();
                itype.setId(referenceIntroducer.getAadhaarNumber());
                itype.setName(referenceIntroducer.getName());
                vpt.setIntroducer(itype);
            } else if (hofDoc.isMandatory()) {
                vpt = new VerificationProofType();
                ReferenceRelative relativeDetails = this.enrollmentService.getRelativeDetails();
                HeadOfFamilyType hofNode = new HeadOfFamilyType();
                if (relativeDetails.isAadhaarNumberMandatory()) {
                    hofNode.setHeadOfFamilyId(relativeDetails.getAadhaarNumber());
                    hofNode.setHeadOfFamilyIdType(GuardianIdType.UID.toString());
                } else if (relativeDetails.isEnrolmentIdMandatory()) {
                    hofNode.setHeadOfFamilyId(relativeDetails.getRelativeEID());
                    hofNode.setHeadOfFamilyIdType(GuardianIdType.EID.toString());
                }
                hofNode.setHofVerificationType(hofDoc.getProof().getDocName());
                hofNode.setDocumentId(hofDoc.getProof().getDocId());
                hofNode.setName(relativeDetails.getName());
                vpt.setHeadOfFamily(hofNode);
            }
            return vpt;
        }
        catch (DocumentDetailsException e) {
            LOGGER.error("DocumentID or DocumentName");
            throw new DocumentDetailsException("POI/POA Document Details are Missing.");
        }
    }

    private ResidentBiometricType toResidentBiometricType(List<BiometricsCaptureTrail> trailList) {
        ResidentBiometricType result = new ResidentBiometricType();
        if (null != trailList && trailList.size() > 0) {
            for (BiometricsCaptureTrail trail : trailList) {
                BiometricCaptureTrailType trailType = new BiometricCaptureTrailType();
                trailType.setGroup(trail.getModality().toGroupName());
                int index = 0;
                BiometricsCapture bestCapture = trail.getBestCapture();
                if (bestCapture == null || bestCapture.getQuality() < 50.0) {
                    for (BiometricsCapture capture : trail.getCaptureHistory()) {
                        BiometricCaptureType capType = this.toBiometricCaptureType(capture);
                        capType.setCbeffIndex(_CbeffGenerator.getCbeffIndex(trail.getModality(), index));
                        capType.setBestAttempt(false);
                        capType.setDeleted(capture.isDeleted());
                        trailType.getBiometricCaptures().add(capType);
                        ++index;
                    }
                }
                if (bestCapture != null) {
                    BiometricCaptureType capType = this.toBiometricCaptureType(bestCapture);
                    capType.setCbeffIndex(_CbeffGenerator.getCbeffIndex(trail.getModality(), index));
                    trailType.getBiometricCaptures().add(capType);
                    capType.setBestAttempt(true);
                    capType.setDeleted(bestCapture.isDeleted());
                }
                result.getBiometricCaptureTrails().add(trailType);
            }
        } else {
            throw new ClientException("Biometric capture is missing");
        }
        return result;
    }

    private BiometricCaptureType toBiometricCaptureType(BiometricsCapture capture) {
        BiometricCaptureType result = new BiometricCaptureType();
        result.setForced(capture.isForcedCapture());
        Map<String, String> devAttributes = capture.getDeviceAttributes();
        if (devAttributes != null && devAttributes.size() > 0) {
            result.setDeviceInfo(_DemoDOMBuilder.toDeviceInfo(devAttributes));
        }
        if (!capture.getBodyParts().isEmpty()) {
            BiometricCaptureType.BodyPartList bodyPartList = new BiometricCaptureType.BodyPartList();
            bodyPartList.getBodyParts().addAll(_DemoDOMBuilder.toBodyPartList(capture.getBodyParts()));
            result.setBodyPartList(bodyPartList);
            result.setStartDate(ISO_8601_DATE_FORMAT.format(new Date(capture.getStartTime())));
            result.setEndDate(ISO_8601_DATE_FORMAT.format(new Date(capture.getEndTime())));
            result.setQuality((int)capture.getQuality());
        }
        if (!capture.getMissingBodyParts().isEmpty()) {
            BiometricCaptureType.MissingPartList missingPartList = new BiometricCaptureType.MissingPartList();
            missingPartList.getBodyParts().addAll(_DemoDOMBuilder.toBodyPartList(capture.getMissingBodyParts()));
            result.setMissingPartList(missingPartList);
        }
        return result;
    }

    private void showPopupMessageDocIDorDocNameMissing() {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("DocId or DocName are missing for the current enrolment packet. Please do the enrolment again");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "Aadhaar Message", 2);
    }
}

