/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.packetgenerator;

import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.UserDetails;
import in.gov.uidai.ec.service.packetgenerator._BiometricsDOMBuilder;
import in.gov.uidai.ec.service.packetgenerator.xml.IntroducerDetails;
import in.gov.uidai.ec.service.packetgenerator.xml.LVSDetails;
import in.gov.uidai.ec.service.packetgenerator.xml.OperatorDetails;
import in.gov.uidai.ec.service.packetgenerator.xml.SupervisorDetails;
import java.text.SimpleDateFormat;
import java.util.Date;

class _UserDetailsDOMBuilder {
    private final EnrollmentService enrollmentService;

    _UserDetailsDOMBuilder(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    OperatorDetails toOperatorDetails() throws Exception {
        UserDetails operator = this.enrollmentService.getConfirmerDetails().getOperator();
        OperatorDetails operatorDetails = new OperatorDetails();
        operatorDetails.setVersion(ApplicationVersion.VERSION);
        operatorDetails.setName(operator.getFullName());
        operatorDetails.setOpid(operator.getUserId());
        operatorDetails.setUid(operator.getUid());
        operatorDetails.setTimestamp(this.getDateForXML(new Date()));
        operatorDetails.setBiometricCapture(_BiometricsDOMBuilder.toBioCapture4User(operator.getBiometrics(), CaptureModality.UNKNOWN));
        operatorDetails.setLvsDetails(this.getLVSDetails(operator));
        return operatorDetails;
    }

    public SupervisorDetails toSupervisorDetails() throws Exception {
        UserDetails userDetails = this.enrollmentService.getConfirmerDetails().getSupervisor();
        SupervisorDetails supervisorDetails = new SupervisorDetails();
        supervisorDetails.setVersion(ApplicationVersion.VERSION);
        supervisorDetails.setName(userDetails.getFullName());
        supervisorDetails.setOpid(userDetails.getUserId());
        supervisorDetails.setUid(userDetails.getUid());
        supervisorDetails.setTimestamp(this.getDateForXML(new Date()));
        supervisorDetails.setBiometricCapture(_BiometricsDOMBuilder.toBioCapture4User(userDetails.getBiometrics(), CaptureModality.UNKNOWN));
        supervisorDetails.setLvsDetails(this.getLVSDetails(userDetails));
        return supervisorDetails;
    }

    public IntroducerDetails toIntroducerDetails() throws Exception {
        UserDetails introducer = this.enrollmentService.getConfirmerDetails().getIntroducer();
        IntroducerDetails introducerDetails = new IntroducerDetails();
        introducerDetails.setVersion(ApplicationVersion.VERSION);
        if (this.enrollmentService.getReferences().getReferenceIntroducer().isMandatory()) {
            introducerDetails.setName(introducer.getFullName());
            introducerDetails.setUid(introducer.getUserId().replaceAll("-", ""));
            introducerDetails.setLvsDetails(this.getLVSDetails(introducer));
        }
        introducerDetails.setTimestamp(this.getDateForXML(new Date()));
        introducerDetails.setBiometricCapture(_BiometricsDOMBuilder.toBioCapture4User(introducer.getBiometrics(), CaptureModality.UNKNOWN));
        return introducerDetails;
    }

    private String getDateForXML(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(date);
    }

    private LVSDetails getLVSDetails(UserDetails ud) {
        LVSDetails lvsDetails = new LVSDetails();
        lvsDetails.setAllowedLvsStatus(ud.getAllowedLvsStatus());
        lvsDetails.setCurrentLvsStatus(ud.getCurrentLvsStatus());
        lvsDetails.setLvsCheck(ud.isLvsCheck());
        return lvsDetails;
    }
}

