/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.pincode;

import in.gov.uidai.ec.oauthapi.OauthGWService;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.json.mda.pinapi.DistrictInfo;
import in.gov.uidai.ec.oauthapi.json.mda.pinapi.PinCodeResponse;
import in.gov.uidai.ec.oauthapi.json.mda.pinapi.PincodeDetail;
import in.gov.uidai.ec.oauthapi.json.mda.pinapi.PostOfficeInfo;
import in.gov.uidai.ec.oauthapi.json.mda.pinapi.StateInfo;
import in.gov.uidai.ec.oauthapi.json.mda.pinapi.SubDistrictInfo;
import in.gov.uidai.ec.oauthapi.json.mda.pinapi.VillageInfo;
import in.gov.uidai.ec.service.pincode.IOnlinePinCodeCache;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostalAddress;
import in.gov.uidai.ec.service.pincode.PostalAddressElement;
import in.gov.uidai.ec.telemetry.TelemetryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OnlinePinCodeCache
implements IOnlinePinCodeCache {
    static final int MAX_CACHE_SIZE = 100;
    private final Map<String, PinCodeNode> pinCodeCacheMap;
    private PinCodeNode pinCodeQueueHead;
    private PinCodeNode pinCodeQueueTail;
    private OauthGWService oauthGWApiService;
    private final PinCodeNode emptyNode = new PinCodeNode("", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());

    OnlinePinCodeCache() {
        this.pinCodeCacheMap = new HashMap<String, PinCodeNode>();
    }

    public void setOauthGWApiService(OauthGWService oauthGWApiService) {
        this.oauthGWApiService = oauthGWApiService;
    }

    @Override
    public List<PostalAddress> getOnlinePostalAddress(String pinCode) {
        if (!this.isValidPinCode(pinCode)) {
            return this.emptyNode.postalAddressList;
        }
        return this.getPinCodeNode((String)pinCode).orElse((PinCodeNode)this.emptyNode).postalAddressList;
    }

    @Override
    public List<PostalAddress> getOnlineLocalPostalAddress(String pinCode) {
        if (!this.isValidPinCode(pinCode)) {
            return this.emptyNode.localPostalAddressList;
        }
        return this.getPinCodeNode((String)pinCode).orElse((PinCodeNode)this.emptyNode).localPostalAddressList;
    }

    @Override
    public List<PostOffice> getPostOffice(String pinCode) {
        if (!this.isValidPinCode(pinCode)) {
            return this.emptyNode.postOfficeList;
        }
        return this.getPinCodeNode((String)pinCode).orElse((PinCodeNode)this.emptyNode).postOfficeList;
    }

    @Override
    public List<PostOffice> getLocalPostOffice(String pinCode) {
        if (!this.isValidPinCode(pinCode)) {
            return this.emptyNode.localPostOfficeList;
        }
        return this.getPinCodeNode((String)pinCode).orElse((PinCodeNode)this.emptyNode).localPostOfficeList;
    }

    private Optional<PinCodeNode> getPinCodeNode(String pinCode) {
        PinCodeNode curPinCodeNode = null;
        if (this.pinCodeCacheMap.containsKey(pinCode)) {
            curPinCodeNode = this.pinCodeCacheMap.get(pinCode);
            if (curPinCodeNode != this.pinCodeQueueHead) {
                PinCodeNode nextPinCodeNode = curPinCodeNode.next;
                PinCodeNode prevPinCodeNode = curPinCodeNode.prev;
                prevPinCodeNode.next = nextPinCodeNode;
                if (nextPinCodeNode != null) {
                    nextPinCodeNode.prev = prevPinCodeNode;
                }
                curPinCodeNode.next = this.pinCodeQueueHead;
                curPinCodeNode.prev = null;
                this.pinCodeQueueHead.prev = curPinCodeNode;
                this.pinCodeQueueHead = curPinCodeNode;
            }
        } else {
            try {
                String pinCodeQuery = String.format("{\"query\":\"query{ pincodeDetails(pincode:\\\"%s\\\") { stateInfo { stateName, stateCodeOld, stateCodeNew, stateNameLocal,districtInfo { districtName, districtCodeOld, districtCodeNew, districtNameLocal, subDistrictInfo { subDistrictName, subDistrictCodeOld, subDistrictCodeNew, subDistrictNameLocal, villageInfo { villageName, villageCodeOld, villageCodeNew, villageNameLocal, postofficeInfo { pincode postOfficeName, postOfficeCode, postOfficeNameLocal, postOfficeType } } } } } } }\",\"variables\":{}}", pinCode);
                PinCodeResponse pinCodeResponse = this.oauthGWApiService.pincodeRequestSubmit(pinCodeQuery);
                curPinCodeNode = this.toPostalAddressNode(pinCode, pinCodeResponse).orElse(null);
            }
            catch (OnlineGatewayException e) {
                TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
            }
            if (curPinCodeNode == null) {
                return Optional.empty();
            }
            if (this.pinCodeCacheMap.size() >= 100) {
                this.pinCodeCacheMap.remove(this.pinCodeQueueTail.pinCode);
                this.pinCodeQueueTail = this.pinCodeQueueTail.prev;
            }
            if (this.pinCodeQueueHead == null) {
                this.pinCodeQueueHead = this.pinCodeQueueTail = curPinCodeNode;
            } else {
                curPinCodeNode.next = this.pinCodeQueueHead;
                this.pinCodeQueueHead.prev = curPinCodeNode;
                this.pinCodeQueueHead = curPinCodeNode;
            }
            this.pinCodeCacheMap.put(pinCode, curPinCodeNode);
        }
        return Optional.of(curPinCodeNode);
    }

    private Optional<PinCodeNode> toPostalAddressNode(String pinCode, PinCodeResponse pinCodeResponse) {
        if (pinCodeResponse == null || pinCodeResponse.getData() == null) {
            return Optional.empty();
        }
        PincodeDetail pincodeDetail = pinCodeResponse.getData().getPincodeDetail();
        if (pincodeDetail == null || pincodeDetail.getStateInfo() == null || pincodeDetail.getStateInfo().size() == 0) {
            return Optional.empty();
        }
        ArrayList<PostalAddress> postalAddressList = new ArrayList<PostalAddress>();
        ArrayList<PostalAddress> localPostalAddressList = new ArrayList<PostalAddress>();
        ArrayList<PostOffice> postOfficeList = new ArrayList<PostOffice>();
        ArrayList<PostOffice> localPostOfficeList = new ArrayList<PostOffice>();
        for (StateInfo stateInfo : pincodeDetail.getStateInfo()) {
            PostalAddressElement stateElement = new PostalAddressElement(stateInfo.getStateCodeOld(), stateInfo.getStateName());
            PostalAddressElement localStateElement = new PostalAddressElement(stateInfo.getStateCodeOld(), stateInfo.getStateNameLocal());
            for (DistrictInfo districtInfo : stateInfo.getDistrictInfo()) {
                PostalAddressElement districtElement = new PostalAddressElement(districtInfo.getDistrictCodeOld(), districtInfo.getDistrictName());
                PostalAddressElement localDistrictElement = new PostalAddressElement(districtInfo.getDistrictCodeOld(), districtInfo.getDistrictNameLocal());
                for (SubDistrictInfo subDistrictInfo : districtInfo.getSubDistrictInfo()) {
                    PostalAddressElement subdistrictElement = new PostalAddressElement(subDistrictInfo.getSubDistrictCodeOld(), subDistrictInfo.getSubDistrictName());
                    PostalAddressElement localSubdistrictElement = new PostalAddressElement(subDistrictInfo.getSubDistrictCodeOld(), subDistrictInfo.getSubDistrictNameLocal());
                    for (VillageInfo villageInfo : subDistrictInfo.getVillageInfo()) {
                        PostalAddressElement villageElement = new PostalAddressElement(villageInfo.getVillageCodeOld(), villageInfo.getVillageName());
                        PostalAddressElement localVillageElement = new PostalAddressElement(villageInfo.getVillageCodeOld(), villageInfo.getVillageNameLocal());
                        for (PostOfficeInfo postOfficeInfo : villageInfo.getPostofficeInfo()) {
                            PostalAddressElement pinCodeElement = new PostalAddressElement(postOfficeInfo.getPincode(), postOfficeInfo.getPincode());
                            PostalAddress postalAddress = new PostalAddress();
                            postalAddress.setState(stateElement);
                            postalAddress.setDistrict(districtElement);
                            postalAddress.setSubDistrict(subdistrictElement);
                            postalAddress.setVtc(villageElement);
                            postalAddress.setPinCode(pinCodeElement);
                            postalAddressList.add(postalAddress);
                            PostalAddress localPostalAddress = new PostalAddress();
                            localPostalAddress.setState(localStateElement);
                            localPostalAddress.setDistrict(localDistrictElement);
                            localPostalAddress.setSubDistrict(localSubdistrictElement);
                            localPostalAddress.setVtc(localVillageElement);
                            localPostalAddress.setPinCode(pinCodeElement);
                            localPostalAddressList.add(localPostalAddress);
                            postOfficeList.add(this.createPostOffice(postOfficeInfo, villageInfo));
                            localPostOfficeList.add(this.createLocalPostOffice(postOfficeInfo, villageInfo));
                        }
                    }
                }
            }
        }
        return Optional.of(new PinCodeNode(pinCode, postalAddressList, localPostalAddressList, postOfficeList, localPostOfficeList));
    }

    private PostOffice createPostOffice(PostOfficeInfo postOfficeInfo, VillageInfo villageInfo) {
        PostOffice postOffice = new PostOffice();
        postOffice.setName(postOfficeInfo.getPostOfficeName());
        postOffice.setExistingName(postOfficeInfo.getPostOfficeName());
        postOffice.setVTCCode(villageInfo.getVillageCodeOld());
        postOffice.setVTCName(villageInfo.getVillageName());
        postOffice.setExistingVtc_name(villageInfo.getVillageName());
        postOffice.setExistingCode(postOfficeInfo.getPostOfficeCode());
        postOffice.setLocaleName(postOfficeInfo.getPostOfficeNameLocal());
        postOffice.setExistingLocaleName(postOfficeInfo.getPostOfficeNameLocal());
        postOffice.setPincode(postOfficeInfo.getPincode());
        postOffice.setExistingPincode(postOfficeInfo.getPincode());
        postOffice.setType(postOfficeInfo.getPostOfficeType());
        return postOffice;
    }

    private PostOffice createLocalPostOffice(PostOfficeInfo postOfficeInfo, VillageInfo villageInfo) {
        PostOffice postOffice = new PostOffice();
        postOffice.setName(postOfficeInfo.getPostOfficeName());
        postOffice.setExistingName(postOfficeInfo.getPostOfficeName());
        postOffice.setVTCCode(villageInfo.getVillageCodeOld());
        postOffice.setVTCName(villageInfo.getVillageNameLocal());
        postOffice.setExistingVtc_name(villageInfo.getVillageNameLocal());
        postOffice.setExistingCode(postOfficeInfo.getPostOfficeCode());
        postOffice.setLocaleName(postOfficeInfo.getPostOfficeNameLocal());
        postOffice.setExistingLocaleName(postOfficeInfo.getPostOfficeNameLocal());
        postOffice.setPincode(postOfficeInfo.getPincode());
        postOffice.setExistingPincode(postOfficeInfo.getPincode());
        postOffice.setType(postOfficeInfo.getPostOfficeType());
        return postOffice;
    }

    private boolean isValidPinCode(String pinCode) {
        return pinCode != null && pinCode.length() == 6;
    }

    static class PinCodeNode {
        String pinCode;
        List<PostalAddress> postalAddressList;
        List<PostalAddress> localPostalAddressList;
        List<PostOffice> postOfficeList;
        List<PostOffice> localPostOfficeList;
        PinCodeNode next;
        PinCodeNode prev;

        public PinCodeNode(String pinCode, List<PostalAddress> postalAddressList, List<PostalAddress> localPostalAddressList, List<PostOffice> postOfficeList, List<PostOffice> localPostOfficeList) {
            this.pinCode = pinCode;
            this.postalAddressList = postalAddressList;
            this.localPostalAddressList = localPostalAddressList;
            this.postOfficeList = postOfficeList;
            this.localPostOfficeList = localPostOfficeList;
        }
    }
}

