/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.pincode;

import in.gov.uidai.ec.service.pincode.IOnlinePinCodeCache;
import in.gov.uidai.ec.service.pincode.IPinCodeService;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostOfficeType;
import in.gov.uidai.ec.service.pincode.PostalAddress;
import in.gov.uidai.ec.service.pincode.PostalAddressElement;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class OnlinePinCodeService
implements IPinCodeService {
    private IOnlinePinCodeCache onlinePinCodeCache;

    public void setOnlinePinCodeCache(IOnlinePinCodeCache onlinePinCodeCache) {
        this.onlinePinCodeCache = onlinePinCodeCache;
    }

    @Override
    public List<PostalAddress> findByPinCode(int pinCode, boolean partial) {
        String pinCodeString = String.valueOf(pinCode);
        return this.onlinePinCodeCache.getOnlinePostalAddress(pinCodeString);
    }

    @Override
    public List<PostalAddressElement> findAllStates() {
        return Collections.emptyList();
    }

    @Override
    public List<PostalAddressElement> findAllDistricts() {
        return Collections.emptyList();
    }

    @Override
    public List<PostOffice> findPostOffices(int pincode, PostalAddressElement vtc) {
        String pinCodeStr = String.valueOf(pincode);
        List<PostOffice> postOfficeList = this.onlinePinCodeCache.getPostOffice(pinCodeStr);
        return postOfficeList.stream().filter(postOffice -> pinCodeStr.equals(postOffice.getPincode()) && postOffice.getVTCCode().equals(vtc.getAddressCode()) && postOffice.getVTCName().equals(vtc.getAddressValue())).collect(Collectors.toList());
    }

    @Override
    public List<PostOffice> findPostOfficesUC(String pinCodeStr, String vtcName) {
        List<PostOffice> postOfficeList = this.onlinePinCodeCache.getPostOffice(pinCodeStr);
        return postOfficeList.stream().filter(postOffice -> pinCodeStr.equals(postOffice.getPincode()) && postOffice.getVTCName().equals(vtcName)).collect(Collectors.toList());
    }

    @Override
    public List<PostOffice> findHeadAndSubPostOffices(int pincode) {
        String pinCodeStr = String.valueOf(pincode);
        List<PostOffice> postOfficeList = this.onlinePinCodeCache.getPostOffice(pinCodeStr);
        return postOfficeList.stream().filter(postOffice -> pinCodeStr.equals(postOffice.getPincode()) && (PostOfficeType.HEAD_OFFICE.equals((Object)postOffice.getType()) || PostOfficeType.SUB_OFFICE.equals((Object)postOffice.getType()))).collect(Collectors.toList());
    }

    @Override
    public List<PostalAddressElement> findDistrictNames(String statecode) {
        return null;
    }

    @Override
    public String findStateCode(String stateName) {
        return null;
    }

    @Override
    public PostalAddress findLocalePostalAddress(String pincode, String vtcCode, String subDistrictCode, String districtCode, String stateCode, String languageCode) {
        return null;
    }

    @Override
    public PostOffice findLocalePostOffice(String pincode, String vtcCode, String postOfficeName, String languageCode) {
        return null;
    }

    @Override
    public PostOffice findPostOffice(String pincode, String vtcCode, String postOfficeName) {
        List<PostOffice> postOfficeList = this.onlinePinCodeCache.getPostOffice(pincode);
        return postOfficeList.stream().filter(postOffice -> pincode.equals(postOffice.getPincode()) && vtcCode.equals(postOffice.getVTCCode()) && postOfficeName.equals(postOffice.getName())).findAny().orElse(null);
    }
}

