/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.pincode;

import in.gov.uidai.ec.service.pincode.IPinCodeService;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostOfficeRepository;
import in.gov.uidai.ec.service.pincode.PostalAddress;
import in.gov.uidai.ec.service.pincode.PostalAddressElement;
import in.gov.uidai.ec.service.pincode.PostalAddressRepository;
import in.gov.uidai.ec.service.pincode.StateDistrictRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinCodeService
implements IPinCodeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinCodeService.class);
    private final PostalAddressRepository postalAddressRepository = new PostalAddressRepository();
    private final PostOfficeRepository postOfficeRepository = new PostOfficeRepository();
    private final StateDistrictRepository stateDistrictRepository = new StateDistrictRepository();
    public static final String ENGLISH_LANGUAGE_CODE = "23";

    @Override
    public List<PostalAddress> findByPinCode(int pinCode, boolean partial) {
        String pinCodeString = String.valueOf(pinCode);
        if (pinCodeString.length() < 4) {
            return null;
        }
        ArrayList<PostalAddress> postalAddressList = new ArrayList();
        try {
            postalAddressList = this.postalAddressRepository.getForPincode(pinCode);
        }
        catch (Exception e) {
            LOGGER.warn("Could not find data for PIN code.");
            LOGGER.debug("details: ", (Throwable)e);
        }
        return postalAddressList;
    }

    @Override
    public PostalAddress findLocalePostalAddress(String pincode, String vtcCode, String subDistrictCode, String districtCode, String stateCode, String languageCode) {
        int pinCodeStringLength = pincode.length();
        if (pinCodeStringLength < 4) {
            return null;
        }
        try {
            List<PostalAddress> localePostalAddresses = this.postalAddressRepository.getForPincodeAndLanguage(Integer.parseInt(pincode), languageCode);
            Optional<PostalAddress> first = localePostalAddresses.stream().filter(pa -> vtcCode.equals(pa.getVtc().getAddressCode())).findFirst();
            return first.orElse(null);
        }
        catch (Exception e) {
            LOGGER.warn("Postal address in local language was not found. Attempting transliteration.");
            LOGGER.debug("details: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<PostalAddressElement> findAllStates() {
        try {
            return this.stateDistrictRepository.getStateList();
        }
        catch (Exception e) {
            LOGGER.warn("Could not get the list of states");
            LOGGER.debug("details: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<PostalAddressElement> findAllDistricts() {
        try {
            return this.stateDistrictRepository.getAllDistricts();
        }
        catch (Exception e) {
            LOGGER.warn("Could not get the list of all districts");
            LOGGER.debug("details: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<PostOffice> findPostOffices(int pinCode, PostalAddressElement vtc) {
        try {
            return this.postOfficeRepository.getForPincode(pinCode, vtc.getAddressCode());
        }
        catch (Exception e) {
            LOGGER.warn("Could not get post office details for PIN code: " + pinCode);
            LOGGER.debug("details: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<PostOffice> findPostOfficesUC(String pincode, String vtcName) {
        return null;
    }

    @Override
    public List<PostOffice> findHeadAndSubPostOffices(int pincode) {
        try {
            return this.postOfficeRepository.getHeadAndSubPostofficesForPincode(pincode);
        }
        catch (Exception e) {
            LOGGER.warn("Could not get post office details for PIN code");
            LOGGER.debug("details: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<PostalAddressElement> findDistrictNames(String statecode) {
        try {
            return this.stateDistrictRepository.getDistrictsForStateCode(statecode);
        }
        catch (Exception e) {
            LOGGER.warn("Could not get district details for state code");
            LOGGER.debug("details: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public String findStateCode(String stateName) {
        return this.stateDistrictRepository.getStateCode(stateName);
    }

    @Override
    public PostOffice findLocalePostOffice(String pinCodeString, String vtcCode, String postOfficeName, String languageCode) {
        try {
            return this.postOfficeRepository.getForPincodeAndPostOfficeName(pinCodeString, postOfficeName, languageCode);
        }
        catch (Exception e) {
            LOGGER.warn("Post office details in local language was not found. Attempting transliteration.");
            LOGGER.debug("details: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public PostOffice findPostOffice(String pinCodeString, String vtcCode, String postOfficeName) {
        try {
            return this.postOfficeRepository.getForPincodeVtcPostOfficeName(pinCodeString, vtcCode, postOfficeName);
        }
        catch (Exception e) {
            LOGGER.warn("Post office details was not found.");
            LOGGER.debug("details: ", (Throwable)e);
            return null;
        }
    }
}

