/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.pincode;

import in.gov.uidai.ec.service.pincode.HasPinCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvMapReader;
import org.supercsv.prefs.CsvPreference;

class PincodeCSVReader<T extends HasPinCode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PincodeCSVReader.class);
    private static final String CSV_RESOURCE_BASE_PATH = "po_res/";

    PincodeCSVReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, List<T>> readCsv(String[] csvPath, Function<Map<String, Object>, T> mapper, String languageCode) throws IOException {
        InputStreamReader reader = null;
        CsvMapReader listReader = null;
        InputStream csvResourceStream = null;
        try {
            Map fieldsInCurrentRow;
            String resourcePath = CSV_RESOURCE_BASE_PATH + String.join((CharSequence)"/", csvPath);
            csvResourceStream = ClassLoader.getSystemResourceAsStream(resourcePath);
            if (csvResourceStream == null) {
                HashMap<String, List<T>> hashMap = new HashMap<String, List<T>>();
                return hashMap;
            }
            reader = new InputStreamReader(csvResourceStream);
            listReader = new CsvMapReader((Reader)reader, CsvPreference.STANDARD_PREFERENCE);
            ArrayList<T> collectedData = new ArrayList<T>();
            String[] csvHeader = listReader.getCSVHeader(true);
            Object[] processors = new CellProcessor[csvHeader.length];
            Arrays.fill(processors, new NotNull());
            while ((fieldsInCurrentRow = listReader.read(csvHeader, (CellProcessor[])processors)) != null) {
                collectedData.add(mapper.apply(fieldsInCurrentRow));
            }
            HashMap<String, List> map = new HashMap<String, List>();
            for (HasPinCode collectedDatum : collectedData) {
                map.computeIfAbsent(collectedDatum.getPincode() + languageCode, k -> new ArrayList()).add(collectedDatum);
            }
            HashMap<String, List> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            LOGGER.error("Error while fetching pincode details: " + e.getMessage());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (listReader != null) {
                listReader.close();
            }
            if (csvResourceStream != null) {
                csvResourceStream.close();
            }
        }
        return new HashMap<String, List<T>>();
    }
}

