/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.pincode;

import in.gov.uidai.ec.service.pincode.PincodeCSVReader;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostOfficeType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

class PostOfficeRepository {
    private static final List<PostOffice> EMPTY = new ArrayList<PostOffice>();
    private static final Map<String, List<PostOffice>> cachedPostOfficesByPincode = new ConcurrentHashMap<String, List<PostOffice>>();
    private static final Function<Map<String, Object>, PostOffice> mapCsvToPostOffice = postOfficeEntry -> {
        PostOffice po = new PostOffice();
        po.setVTCCode((String)postOfficeEntry.get("VTC_CODE"));
        po.setName((String)postOfficeEntry.get("PO_NAME"));
        po.setType((String)postOfficeEntry.get("PO_TYPE"));
        po.setPincode((String)postOfficeEntry.get("PINCODE"));
        po.setLanguageCode((String)postOfficeEntry.get("LANGUAGE_CODE"));
        po.setLocaleName((String)postOfficeEntry.get("PO_LOCALE_NAME"));
        return po;
    };
    private final PincodeCSVReader<PostOffice> postOfficeCSVReader = new PincodeCSVReader();

    PostOfficeRepository() {
    }

    List<PostOffice> getForPincode(int pinCode, String vtcCode) throws Exception {
        String languageCode = "23";
        String pincode = this.updatePostOfficesCacheForPincode(pinCode, languageCode);
        ArrayList<PostOffice> result = new ArrayList<PostOffice>();
        this.getKnownPincodesMatching(pincode + languageCode).forEach(p -> {
            List poByVTCCode = cachedPostOfficesByPincode.get(p).stream().filter(po -> vtcCode.equals(po.getVTCCode()) || PostOfficeType.SUB_OFFICE.equals((Object)po.getType()) || PostOfficeType.HEAD_OFFICE.equals((Object)po.getType())).distinct().collect(Collectors.toList());
            result.addAll(poByVTCCode);
        });
        return result;
    }

    PostOffice getForPincodeAndPostOfficeName(String pincode, String postOfficeName, String languageCode) throws IOException {
        this.updatePostOfficesCacheForPincode(Integer.parseInt(pincode), languageCode);
        List<PostOffice> postOfficeList = cachedPostOfficesByPincode.getOrDefault(pincode + languageCode, EMPTY);
        return postOfficeList.stream().filter(po -> postOfficeName.equals(po.getName()) && languageCode.equals(po.getLanguageCode())).findFirst().orElse(null);
    }

    private String updatePostOfficesCacheForPincode(int pinCode, String languageCode) throws IOException {
        String[] csvPath = new String[]{"postOffice", String.valueOf(pinCode).substring(0, 4) + ".csv"};
        String pincode = String.valueOf(pinCode);
        List<String> matchedPincodes = this.getKnownPincodesMatching(pincode + languageCode);
        if (matchedPincodes.size() == 0) {
            Map<String, List<PostOffice>> postOfficeByPincode = this.postOfficeCSVReader.readCsv(csvPath, mapCsvToPostOffice, languageCode);
            cachedPostOfficesByPincode.putAll(postOfficeByPincode);
        }
        return pincode;
    }

    PostOffice getForPincodeVtcPostOfficeName(String pincode, String vtcCode, String postOfficeName) throws IOException {
        String languageCode = "23";
        this.updatePostOfficesCacheForPincode(Integer.parseInt(pincode), languageCode);
        List<PostOffice> postOfficeList = cachedPostOfficesByPincode.getOrDefault(pincode + languageCode, EMPTY);
        return postOfficeList.stream().filter(po -> vtcCode.equals(po.getVTCCode()) && postOfficeName.equals(po.getName())).findFirst().orElse(null);
    }

    private List<String> getKnownPincodesMatching(String key) {
        return cachedPostOfficesByPincode.keySet().stream().filter(s -> s.equals(key)).collect(Collectors.toList());
    }

    List<PostOffice> getHeadAndSubPostofficesForPincode(int pinCode) throws Exception {
        String languageCode = "23";
        String pincode = this.updatePostOfficesCacheForPincode(pinCode, languageCode);
        ArrayList<PostOffice> result = new ArrayList<PostOffice>();
        HashSet poNameTypes = new HashSet();
        this.getKnownPincodesMatching(pincode + languageCode).forEach(p -> {
            List poByVTCName = cachedPostOfficesByPincode.get(p).stream().filter(po -> {
                if (PostOfficeType.HEAD_OFFICE.equals((Object)po.getType()) || PostOfficeType.SUB_OFFICE.equals((Object)po.getType())) {
                    if (poNameTypes.contains(po.getName() + po.getType().toString())) {
                        return false;
                    }
                    poNameTypes.add(po.getName() + po.getType().toString());
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            result.addAll(poByVTCName);
        });
        return result;
    }
}

