/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.pincode;

import in.gov.uidai.ec.service.pincode.PincodeCSVReader;
import in.gov.uidai.ec.service.pincode.PostalAddress;
import in.gov.uidai.ec.service.pincode.PostalAddressElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

class PostalAddressRepository {
    private static final Map<String, List<PostalAddress>> cachedPostalAddressesByPincode = new HashMap<String, List<PostalAddress>>();
    private static final Map<String, List<PostalAddress>> cachedLocalePostalAddressesByPincode = new HashMap<String, List<PostalAddress>>();
    private static final Function<Map<String, Object>, PostalAddress> mapCsvToPostalAddress = postalAddressEntry -> {
        PostalAddress pa = new PostalAddress();
        pa.setVtc(new PostalAddressElement((String)postalAddressEntry.get("VTC_CODE"), (String)postalAddressEntry.get("VTC_NAME")));
        pa.setDistrict(new PostalAddressElement((String)postalAddressEntry.get("DISTRICT_CODE"), (String)postalAddressEntry.get("DISTRICT_NAME")));
        pa.setSubDistrict(new PostalAddressElement((String)postalAddressEntry.get("SUBDISTRICT_CODE"), (String)postalAddressEntry.get("SUBDISTRICT_NAME")));
        pa.setState(new PostalAddressElement((String)postalAddressEntry.get("STATE_CODE"), (String)postalAddressEntry.get("STATE_NAME")));
        pa.setPinCode(new PostalAddressElement((String)postalAddressEntry.get("PINCODE"), (String)postalAddressEntry.get("PINCODE")));
        return pa;
    };
    private final PincodeCSVReader<PostalAddress> postalAddressPostOfficeCSVReader = new PincodeCSVReader();

    PostalAddressRepository() {
    }

    List<PostalAddress> getForPincode(int pinCode) throws Exception {
        String pincodePrefix = String.valueOf(pinCode);
        String[] csvPath = new String[]{"vtc", pincodePrefix.substring(0, 4) + ".csv"};
        return this.getPostalAddresses(pincodePrefix, csvPath, cachedPostalAddressesByPincode, "23");
    }

    List<PostalAddress> getForPincodeAndLanguage(int pinCode, String languageCode) throws Exception {
        String pincodePrefix = String.valueOf(pinCode);
        String[] csvPath = new String[]{"vtc", languageCode, pincodePrefix.substring(0, 4) + ".csv"};
        return this.getPostalAddresses(pincodePrefix, csvPath, cachedLocalePostalAddressesByPincode, languageCode);
    }

    private ArrayList<PostalAddress> getPostalAddresses(String pincode, String[] csvPath, Map<String, List<PostalAddress>> cache, String languageCode) throws Exception {
        List<String> matchedPincodes = this.getKnownPincodesMatching(cache, pincode + languageCode);
        if (matchedPincodes.size() == 0) {
            Map<String, List<PostalAddress>> postalAddressesByPincode = this.postalAddressPostOfficeCSVReader.readCsv(csvPath, mapCsvToPostalAddress, languageCode);
            cache.putAll(postalAddressesByPincode);
        }
        ArrayList<PostalAddress> result = new ArrayList<PostalAddress>();
        this.getKnownPincodesMatching(cache, pincode + languageCode).forEach(p -> result.addAll((Collection)cache.get(p)));
        return result;
    }

    private List<String> getKnownPincodesMatching(Map<String, List<PostalAddress>> cache, String pincode) {
        List<String> knownPincodesMatching = cache.keySet().stream().filter(s -> s.equals(pincode)).collect(Collectors.toList());
        Collections.sort(knownPincodesMatching);
        return knownPincodesMatching;
    }
}

