/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.pincode;

import in.gov.uidai.ec.service.pincode.PostalAddressElement;
import in.gov.uidai.ec.service.pincode.PostalAddressElementCsvReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

class StateDistrictRepository {
    private static final Map<String, List<PostalAddressElement>> cachedDistrictAddressByStateCode = new HashMap<String, List<PostalAddressElement>>();
    private static final Function<Map<String, Object>, PostalAddressElement> mapCsvToDistrict = districtEntry -> {
        PostalAddressElement district = new PostalAddressElement();
        district.setAddressValue(districtEntry.get("DISTRICT_NAME").toString());
        district.setAddressCode(districtEntry.get("DISTRICT_CODE").toString());
        return district;
    };
    private static final Function<Map<String, Object>, PostalAddressElement> mapCsvToState = districtEntry -> {
        PostalAddressElement state = new PostalAddressElement();
        state.setAddressValue(districtEntry.get("STATE_NAME").toString());
        state.setAddressCode(districtEntry.get("STATE_CODE").toString());
        return state;
    };
    private static final List<PostalAddressElement> stateList = new ArrayList<PostalAddressElement>();
    private static Map<String, String> mapNameToStateCode = new HashMap<String, String>();
    private final PostalAddressElementCsvReader CSVReader = new PostalAddressElementCsvReader();

    StateDistrictRepository() {
    }

    List<PostalAddressElement> getStateList() throws Exception {
        String[] csvPath = new String[]{"statesAndDistricts", "states.csv"};
        if (stateList.size() == 0) {
            stateList.addAll(this.CSVReader.readCsv(csvPath, mapCsvToState));
            mapNameToStateCode = this.CSVReader.readCsv(csvPath, mapCsvToState).stream().collect(Collectors.toMap(PostalAddressElement::getAddressValue, PostalAddressElement::getAddressCode));
        }
        return new ArrayList<PostalAddressElement>(stateList);
    }

    List<PostalAddressElement> getAllDistricts() throws Exception {
        List<PostalAddressElement> sl = this.getStateList();
        TreeSet districtSet = new TreeSet();
        sl.forEach(s -> {
            try {
                districtSet.addAll(this.getDistrictsForStateCode(s.getAddressCode()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return new ArrayList<PostalAddressElement>(districtSet);
    }

    String getStateCode(String stateName) {
        return mapNameToStateCode.get(stateName);
    }

    List<PostalAddressElement> getDistrictsForStateCode(String stateCode) throws Exception {
        String[] csvPath = new String[]{"statesAndDistricts", stateCode + ".csv"};
        List<String> matchedStateCodes = this.getKnownStateCodes(stateCode);
        if (matchedStateCodes.size() == 0) {
            List<PostalAddressElement> districtListByStateCode = this.CSVReader.readCsv(csvPath, mapCsvToDistrict);
            cachedDistrictAddressByStateCode.put(stateCode, districtListByStateCode);
        }
        return cachedDistrictAddressByStateCode.get(stateCode);
    }

    private List<String> getKnownStateCodes(String stateCode) {
        return cachedDistrictAddressByStateCode.keySet().stream().filter(s -> s.equals(stateCode)).collect(Collectors.toList());
    }
}

