/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.presync;

import in.gov.uidai.ec.ecmpapi.xml.operatorsync.OperatorCenterSynchTable;
import in.gov.uidai.ec.ecmpapi.xml.presync.OperatorSynchTable;
import in.gov.uidai.ec.escapi.OperatorInfo;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.service.session.OperatorDetails;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpSyncDetailsMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpSyncDetailsMapper.class);

    public OperatorCenterSynchTable convertToOpSyncTable(OperatorDetails operatorDetails, String opId) throws DatatypeConfigurationException {
        OperatorCenterSynchTable opTable = new OperatorCenterSynchTable();
        opTable.setRegistarId(operatorDetails.getRegistrarName());
        opTable.setEa(operatorDetails.getEnrolmentAgencyName());
        opTable.setStationId(operatorDetails.getStationId());
        opTable.setCenterType(operatorDetails.getCenterType());
        opTable.setCenterName(operatorDetails.getCenterName());
        opTable.setCenterAddress(operatorDetails.getCenterAddress());
        opTable.setCenterId(operatorDetails.getCenterId());
        opTable.setVtc(operatorDetails.getVtcDetails());
        opTable.setSubDistrict(operatorDetails.getSubDistrict());
        opTable.setDistrict(operatorDetails.getDistrict());
        opTable.setState(operatorDetails.getState());
        opTable.setPincode(operatorDetails.getPincode());
        opTable.setPostOffice(operatorDetails.getPostOffice());
        opTable.setOperatorName(operatorDetails.getOpName());
        opTable.setOperatorId(opId);
        opTable.setOperatorMobileNo(operatorDetails.getOpMobile());
        opTable.setLatitude(operatorDetails.getLatitude());
        opTable.setLongitude(operatorDetails.getLongitude());
        opTable.setAltitude(operatorDetails.getAltitude());
        opTable.setOperatorUID(operatorDetails.getOpUid());
        opTable.setWitelistingForBE(operatorDetails.getWhiteListedForBE().equalsIgnoreCase("true"));
        opTable.setClientVersion(ApplicationVersion.FULLDISPLAYVERSION);
        opTable.setCreatedBy("SYSTEM");
        opTable.setLastUpdatedBy("SYSTEM");
        opTable.setSyncInterval("interval");
        XMLGregorianCalendar xgcal = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        opTable.setLastUpdatedDate(xgcal);
        opTable.setCreationDate(xgcal);
        opTable.setClientType("ECA");
        opTable.setMachineCode(operatorDetails.getMachineCode());
        return opTable;
    }

    public byte[] convertToOperatorDetailsByteArray(OperatorSynchTable operatorSynchTable, String stationId) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                OperatorDetails operatorDetails = this.convertToOperatorDetails(operatorSynchTable, stationId);
                oos.writeObject(operatorDetails);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public OperatorDetails convertToOperatorDetails(OperatorSynchTable operatorSynchTable, String stationId) {
        OperatorDetails operatorDetails = new OperatorDetails();
        operatorDetails.setOpName(operatorSynchTable.getOperatorName());
        operatorDetails.setEnrolmentAgencyName(operatorSynchTable.getEa());
        operatorDetails.setAltitude(operatorSynchTable.getAltitude());
        operatorDetails.setCenterAddress(operatorSynchTable.getCenterAddress());
        operatorDetails.setCenterId(operatorSynchTable.getCenterId());
        operatorDetails.setCenterName(operatorSynchTable.getCenterName());
        operatorDetails.setCenterType(operatorSynchTable.getCenterType());
        operatorDetails.setDistrict(operatorSynchTable.getDistrict());
        operatorDetails.setEnrolmentAgencyName(operatorSynchTable.getEa());
        operatorDetails.setLastupdatedDate(operatorSynchTable.getLastUpdatedDate());
        operatorDetails.setLatitude(operatorSynchTable.getLatitude());
        operatorDetails.setLongitude(operatorSynchTable.getLongitude());
        operatorDetails.setOpMobile(operatorSynchTable.getOperatorMobileNo());
        operatorDetails.setOpName(operatorSynchTable.getOperatorName());
        operatorDetails.setOpUid(operatorSynchTable.getOperatorUID());
        operatorDetails.setPincode(operatorSynchTable.getPincode());
        operatorDetails.setPostOffice(operatorSynchTable.getPostOffice());
        operatorDetails.setRegistrarName(operatorSynchTable.getRegistarId());
        operatorDetails.setState(operatorSynchTable.getState());
        operatorDetails.setStationId(stationId);
        operatorDetails.setSubDistrict(operatorSynchTable.getSubDistrict());
        operatorDetails.setVtcDetails(operatorSynchTable.getVtc());
        boolean flag = operatorSynchTable.isWitelistingForBE();
        if (flag) {
            operatorDetails.setWhiteListedForBE("True");
        } else {
            operatorDetails.setWhiteListedForBE("False");
        }
        operatorDetails.setMachineCode(operatorSynchTable.getMachineCode());
        operatorDetails.setClientVersion(operatorSynchTable.getClientVersion());
        operatorDetails.setClientType(operatorSynchTable.getClientType());
        operatorDetails.setCreatedBy(operatorSynchTable.getCreatedBy());
        operatorDetails.setCreationDate(operatorSynchTable.getCreationDate());
        return operatorDetails;
    }

    public OperatorDetails convertToOperatorDetails(OperatorInfo opDetails) {
        OperatorDetails operatorDetails = new OperatorDetails();
        operatorDetails.setOpName(opDetails.getName());
        operatorDetails.setEnrolmentAgencyName(opDetails.getEnrolmentAgencyName());
        operatorDetails.setAltitude(opDetails.getLocation().getAltitude());
        operatorDetails.setCenterAddress(opDetails.getCenter().getAddress());
        operatorDetails.setCenterAddressOther(opDetails.getCenter().getAddressOther());
        operatorDetails.setCenterId(opDetails.getCenter().getId());
        operatorDetails.setCenterName(opDetails.getCenter().getName());
        operatorDetails.setCenterType(opDetails.getCenter().getType());
        operatorDetails.setDistrict(opDetails.getStation().getDistrict());
        operatorDetails.setCenterAddress(opDetails.getCenter().getAddress());
        XMLGregorianCalendar lastUpdatedDateXMLGregorianCalendar = null;
        try {
            if (!opDetails.getLastUpdatedDate().isEmpty()) {
                lastUpdatedDateXMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(opDetails.getLastUpdatedDate());
            }
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.error("unable to convert last updated date to xml gregorian calender", (Throwable)e);
        }
        operatorDetails.setLastupdatedDate(lastUpdatedDateXMLGregorianCalendar);
        XMLGregorianCalendar createdDateXMLGregorianCalendar = null;
        try {
            if (!opDetails.getCreatedDate().isEmpty()) {
                createdDateXMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(opDetails.getCreatedDate());
            }
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.error("unable to convert created date to xml gregorian calender", (Throwable)e);
        }
        operatorDetails.setCreationDate(createdDateXMLGregorianCalendar);
        operatorDetails.setLastUpdatedBy(opDetails.getLastUpdatedBy());
        operatorDetails.setCreatedBy(opDetails.getCreatedBy());
        operatorDetails.setLatitude(opDetails.getLocation().getLatitude());
        operatorDetails.setLongitude(opDetails.getLocation().getLongitude());
        operatorDetails.setOpMobile(opDetails.getMobile());
        operatorDetails.setOpName(opDetails.getName());
        operatorDetails.setOpUid(opDetails.getUid());
        operatorDetails.setPincode(opDetails.getStation().getPinCode());
        operatorDetails.setPostOffice(opDetails.getStation().getPostOffice());
        operatorDetails.setRegistrarName(opDetails.getRegistrarName());
        operatorDetails.setState(opDetails.getStation().getState());
        operatorDetails.setStationId(opDetails.getStation().getId());
        operatorDetails.setSubDistrict(opDetails.getStation().getSubDistrict());
        operatorDetails.setVtcDetails(opDetails.getStation().getVillageTownCity());
        boolean flag = opDetails.getWhiteListedForBE();
        if (flag) {
            operatorDetails.setWhiteListedForBE("True");
        } else {
            operatorDetails.setWhiteListedForBE("False");
        }
        operatorDetails.setMachineCode(opDetails.getMachineCode());
        operatorDetails.setClientVersion(opDetails.getClientVersion());
        operatorDetails.setClientType(opDetails.getClientType());
        return operatorDetails;
    }

    public Map<String, OperatorInfo> convertToOperatorInfoMap(Map<String, OperatorDetails> operatorDetails) {
        HashMap<String, OperatorInfo> idToDetailsMap = new HashMap<String, OperatorInfo>();
        operatorDetails.forEach((id, details) -> {
            OperatorInfo opDetails = this.constructOperatorInfo((OperatorDetails)details);
            idToDetailsMap.put((String)id, opDetails);
        });
        return idToDetailsMap;
    }

    private OperatorInfo constructOperatorInfo(OperatorDetails details) {
        String flag;
        OperatorInfo.Location location = new OperatorInfo.Location();
        location.setLatitude(details.getLatitude());
        location.setLongitude(details.getLongitude());
        location.setAltitude(details.getAltitude());
        OperatorInfo.Center center = new OperatorInfo.Center();
        center.setId(details.getCenterId());
        center.setName(details.getCenterName());
        center.setType(details.getCenterType());
        center.setAddress(details.getCenterAddress());
        center.setAddressOther(details.getCenterAddressOther());
        OperatorInfo.Station station = new OperatorInfo.Station();
        station.setId(details.getStationId());
        station.setDistrict(details.getDistrict());
        station.setPinCode(details.getPincode());
        station.setPostOffice(details.getPostOffice());
        station.setState(details.getState());
        station.setSubDistrict(details.getSubDistrict());
        station.setVillageTownCity(details.getVtcDetails());
        OperatorInfo opDetails = new OperatorInfo();
        opDetails.setCenter(center);
        opDetails.setClientType(details.getClientType());
        opDetails.setClientVersion(details.getClientVersion());
        opDetails.setEnrolmentAgencyName(details.getEnrolmentAgencyName());
        opDetails.setLocation(location);
        opDetails.setMachineCode(details.getMachineCode());
        opDetails.setMobile(details.getOpMobile());
        opDetails.setName(details.getOpName());
        opDetails.setRegistrarName(details.getRegistrarName());
        opDetails.setStation(station);
        opDetails.setUid(details.getOpUid());
        opDetails.setCreatedBy(details.getCreatedBy());
        opDetails.setLastUpdatedBy(details.getLastUpdatedBy());
        if (details.getCreationDate() != null) {
            opDetails.setCreatedDate(String.valueOf(details.getCreationDate()));
        }
        if (details.getLastupdatedDate() != null) {
            opDetails.setLastUpdatedDate(String.valueOf(details.getLastupdatedDate()));
        }
        if ((flag = details.getWhiteListedForBE()).equals("True")) {
            opDetails.setWhiteListedForBE(Boolean.valueOf(true));
        } else {
            opDetails.setWhiteListedForBE(Boolean.valueOf(false));
        }
        return opDetails;
    }

    public OperatorInfo convertToOperatorInfo(OperatorDetails operatorDetails) {
        return this.constructOperatorInfo(operatorDetails);
    }
}

