/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.presync;

import in.gov.uidai.ec.ecmpapi.CIDRStatus;
import in.gov.uidai.ec.ecmpapi.ITokenProvider;
import in.gov.uidai.ec.ecmpapi.xml.presync.ConfigParameters;
import in.gov.uidai.ec.ecmpapi.xml.presync.OnBoardedOperator;
import in.gov.uidai.ec.ecmpapi.xml.presync.OnBoardedOperatorList;
import in.gov.uidai.ec.ecmpapi.xml.presync.Parameters;
import in.gov.uidai.ec.ecmpapi.xml.presync.PreSyncErrorCode;
import in.gov.uidai.ec.ecmpapi.xml.presync.PreSyncRequest;
import in.gov.uidai.ec.ecmpapi.xml.presync.PreSyncRequestDetails;
import in.gov.uidai.ec.ecmpapi.xml.presync.PreSyncResponse;
import in.gov.uidai.ec.ecmpapi.xml.presync.Result;
import in.gov.uidai.ec.escapi.ChargesInfo;
import in.gov.uidai.ec.escapi.ChecksumInfo;
import in.gov.uidai.ec.escapi.EnrolServiceClientApiService;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.escapi.StationSettingsInfo;
import in.gov.uidai.ec.escapi.StoreOperatorDetailException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStoreAware;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.presync.IServerSyncDAO;
import in.gov.uidai.ec.service.presync.OpSyncDetailsMapper;
import in.gov.uidai.ec.service.presync.PreSyncParams;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.session.IOperatorSyncDAO;
import in.gov.uidai.ec.service.session.OperatorDetails;
import in.gov.uidai.ec.service.session.OperatorDetailsSer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PreSyncDelegate
implements IPreferenceStoreAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreSyncDelegate.class);
    private static final String TOKEN_API = "PACKET_STATUS_API";
    private static final String CLIENT_TYPE = "ECA";
    private ITokenProvider tokenManager;
    private IPreferenceStore prefStore;
    private IPreSyncPreference preSyncPref;
    private IRegistrationService registrationService;
    private IOperatorSyncDAO opSyncDao;
    private IServerSyncDAO serverSyncDao;
    private IOucDataStore oucDataStore;
    @Autowired
    private EnrolServiceClientApiService enrolServiceClientApiService;

    public void setOpSyncDao(IOperatorSyncDAO opSyncDao) {
        this.opSyncDao = opSyncDao;
    }

    public void setServSyncDAO(IServerSyncDAO servSyncDAO) {
        this.serverSyncDao = servSyncDAO;
    }

    public void setTokenManager(ITokenProvider tokenManager) {
        this.tokenManager = tokenManager;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setOucDataStore(IOucDataStore oucDataStore) {
        this.oucDataStore = oucDataStore;
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.prefStore = store;
    }

    public IPreSyncPreference getPreSyncPref() {
        return this.preSyncPref;
    }

    public void setPreSyncPref(IPreSyncPreference preSyncPref) {
        this.preSyncPref = preSyncPref;
    }

    public PreSyncRequest prepareServiceRequest(String operatorId, List<UserCredentials> userList, boolean onboardStatus) {
        PreSyncRequest request = new PreSyncRequest();
        PreSyncRequestDetails preSyncData = new PreSyncRequestDetails();
        preSyncData.setUsercode(operatorId);
        preSyncData.setEaCode(this.registrationService.getAgencyId());
        preSyncData.setMachineCode(this.registrationService.getRegisteredMachineCode());
        preSyncData.setRegistrarId(this.registrationService.getRegistrarId());
        preSyncData.setStationCode(this.registrationService.getStationId());
        preSyncData.setClientVersion(ApplicationVersion.VERSION);
        preSyncData.setToken(this.tokenManager.getToken(TOKEN_API));
        preSyncData.setClientType(CLIENT_TYPE);
        preSyncData.setOnboardStatus(onboardStatus);
        request.setPreSyncData(preSyncData);
        OnBoardedOperatorList operatorList = new OnBoardedOperatorList();
        if (userList != null && userList.size() > 0) {
            userList.forEach(user -> {
                OnBoardedOperator operator = new OnBoardedOperator();
                operator.setOperatorUID(user.getUid());
                operator.setUserCode(user.getOperatorId() + "");
                operator.setIsOnBoarded(user.isOnboard());
                operatorList.getOnBoardedOperator().add(operator);
            });
            preSyncData.setOnBoardedOperators(operatorList);
        }
        return request;
    }

    public CIDRStatus processServiceResponse(Object responseObj) throws StationInfoStoreException {
        try {
            PreSyncResponse response = (PreSyncResponse)responseObj;
            if (response == null) {
                return CIDRStatus.NETWORK_ERROR;
            }
            PreSyncErrorCode errorCode = response.getFailureReason();
            CIDRStatus cidrStatus = this.toCIDRStatus(errorCode);
            if (Result.SUCCESS.equals((Object)response.getResult())) {
                List inactiveOpList;
                StringBuilder operatorsStr;
                List suspended;
                StationSettingsInfo stationSettingsInfo = this.oucDataStore.getStationSettingsInfo();
                ChargesInfo chargesInfo = this.oucDataStore.getChargesInfo();
                ChecksumInfo checksumInfo = this.oucDataStore.getCheckSumInfo();
                this.preSyncPref.setClientForceShutdown("");
                Parameters params = response.getParameters();
                if (params != null) {
                    for (ConfigParameters param : params.getConfigParam()) {
                        PreSyncParams paramType;
                        String value = param.getValue();
                        try {
                            paramType = PreSyncParams.fromValue(param.getName());
                        }
                        catch (Exception e) {
                            LOGGER.debug("Param name mismatch:" + e.getMessage());
                            continue;
                        }
                        switch (paramType) {
                            case CLIENT_VERSION_DATE: {
                                this.preSyncPref.setClientVersionDate(value);
                                break;
                            }
                            case CLIENT_VERSION: {
                                this.preSyncPref.setClientVersion(value);
                                break;
                            }
                            case MAX_PACKETS_PER_DAY: {
                                stationSettingsInfo.setMaxPacketsPerDay(Integer.parseInt(value));
                                this.preSyncPref.setMaxPacketsPerDay(Integer.parseInt(value));
                                break;
                            }
                            case MAX_UNEXPORTED_PACKETS: {
                                this.preSyncPref.setMaxUnexportedPackets(Integer.parseInt(value));
                                break;
                            }
                            case CLIENT_MESSAGE: {
                                this.preSyncPref.setClientMessage(value);
                                break;
                            }
                            case CLIENT_FORCE_SHUTDOWN: {
                                this.preSyncPref.setClientForceShutdown(value);
                                break;
                            }
                            case GPS_UPDATE_VERIFY: {
                                stationSettingsInfo.setGpsUpdateVerify(value);
                                this.preSyncPref.setGPSUpdateVerifyRequired(value);
                                break;
                            }
                            case GPS_CAPTURE_INTERVAL_OFFLINE: {
                                stationSettingsInfo.setGpsCaptureIntervalOffline(value);
                                this.preSyncPref.setGpsCaptureIntervalOffline(value);
                                break;
                            }
                            case IS_RGI: {
                                this.preSyncPref.setRGIRegistrar(value);
                                break;
                            }
                            case SCAN_DOCS: {
                                this.preSyncPref.setScanDocuments(value);
                                break;
                            }
                            case AUTH_REQUEST_TYPE: {
                                this.preSyncPref.setAuthRequestType(value);
                                break;
                            }
                            case KEY_SIZE: {
                                this.preSyncPref.setKeySize(value);
                                break;
                            }
                            case MAX_UNUPLOADED_PACKETS: {
                                stationSettingsInfo.setMaxUnuploadedPackets(Integer.parseInt(value));
                                this.preSyncPref.setMaxUnuploadedPackets(Integer.parseInt(value));
                                break;
                            }
                            case MAX_UNUPLOADED_DATE_ALLOEWED: {
                                this.preSyncPref.setMaxUnuploadedDateAllowed(value);
                                break;
                            }
                            case PKTINTG_FAILED_DELETE: {
                                this.preSyncPref.setPktIntgFailedDelete(value);
                                break;
                            }
                            case ALLOW_FULL_BE: {
                                this.preSyncPref.setAllowFullBe(value != null && value.equalsIgnoreCase("Y"));
                                break;
                            }
                            case FINGER_IRIS_AUTH_TYPE: {
                                stationSettingsInfo.setFingerIrisAuthType(value);
                                this.preSyncPref.setFingerIrisAuthType(value);
                                break;
                            }
                            case FINGER_IRIS_AUTH_TYPE_OSI: {
                                stationSettingsInfo.setFingerIrisAuthTypeOsi(value);
                                this.preSyncPref.setFingerIrisAuthTypeOSI(value);
                                break;
                            }
                            case OPERATOR_SYNC_INTERVAL: {
                                this.preSyncPref.setOperatorSyncInterval(value);
                                break;
                            }
                            case CLIENT_CHECK_SUM_NEW_VERSION: {
                                checksumInfo.setSyncNewChecksum(value);
                                this.preSyncPref.setClientSyncNewCheckSum(value);
                                this.serverSyncDao.insertCheckSumDetails("CLIENT_CHECK_SUM_NEW_VERSION", value);
                                break;
                            }
                            case CLIENT_CHECK_SUM_OLD_VERSION: {
                                this.preSyncPref.setClientSyncOldCheckSum(value);
                                this.serverSyncDao.insertCheckSumDetails("CLIENT_CHECK_SUM_OLD_VERSION", value);
                                break;
                            }
                            case SECRET_KEY: {
                                this.preSyncPref.setSecretKey(value);
                                break;
                            }
                            case SHUTDOWN_GRACE_PERIOD: {
                                this.preSyncPref.setShutDownGracePeriod(value);
                                break;
                            }
                            case CLIENT_NEW_VERSION: {
                                this.preSyncPref.setNewClientVersion(value);
                                break;
                            }
                            case REGISTRAR_CONFIGURATION_FOR_PAYMENT_RECEIPT: {
                                chargesInfo.setRegistrarConfigurationsForPaymentReceipt(value.split(","));
                                this.preSyncPref.setRegistrarConfigurationForPaymentReceipt(value);
                                break;
                            }
                            case GST_APPLIED: {
                                chargesInfo.setGstApplied(Float.parseFloat(value));
                                this.preSyncPref.setGstApplied(Float.valueOf(Float.parseFloat(value)));
                                break;
                            }
                            case AMOUNT_CHAGERD_FOR_NEW_ENROLMENT: {
                                chargesInfo.setAmountChargedForNewEnrolment(Float.parseFloat(value));
                                this.preSyncPref.setAmountChargedForNewEnrolment(Float.valueOf(Float.parseFloat(value)));
                                break;
                            }
                            case AMOUNT_CHARGED_FOR_DEMO_UPDATE: {
                                chargesInfo.setAmountChargedForDemographicUpdate(Float.parseFloat(value));
                                this.preSyncPref.setAmountChargedForDemoUpdate(Float.valueOf(Float.parseFloat(value)));
                                break;
                            }
                            case AMOUNT_CHARGED_FOR_BIO_UPDATE: {
                                chargesInfo.setAmountChargedForBiometricUpdate(Float.parseFloat(value));
                                this.preSyncPref.setAmountChargedForBioUpdate(Float.valueOf(Float.parseFloat(value)));
                                break;
                            }
                            case AMOUNT_CHARGED_FOR_DOC_UPDATE: {
                                chargesInfo.setAmountChargedForDemographicUpdate(Float.parseFloat(value));
                                this.preSyncPref.setAmountChargedForDocUpdate(Float.valueOf(Float.parseFloat(value)));
                            }
                        }
                    }
                }
                stationSettingsInfo.setBlacklistedOperatorIds(new String[0]);
                this.preSyncPref.setSuspendedOperatorIDs("");
                if (response.getBlackListedOperatorList() != null && (suspended = response.getBlackListedOperatorList().getOperatorUID()) != null) {
                    operatorsStr = new StringBuilder();
                    int i = 1;
                    for (String operator : suspended) {
                        operatorsStr.append(operator);
                        if (i < suspended.size()) {
                            operatorsStr.append(",");
                        }
                        ++i;
                    }
                    stationSettingsInfo.setBlacklistedOperatorIds(operatorsStr.toString().split(","));
                    this.preSyncPref.setSuspendedOperatorIDs(operatorsStr.toString());
                }
                this.preSyncPref.setInactiveOperatorList("");
                if (response.getInactiveOperatorList() != null && (inactiveOpList = response.getInactiveOperatorList().getInActiveOperator()) != null) {
                    operatorsStr = new StringBuilder();
                    int i = 1;
                    for (String operator : inactiveOpList) {
                        operatorsStr.append(operator.getOperatorUID());
                        operatorsStr.append(";");
                        operatorsStr.append(operator.getUserCode());
                        if (i < inactiveOpList.size()) {
                            operatorsStr.append(",");
                        }
                        ++i;
                    }
                    this.preSyncPref.setInactiveOperatorList(operatorsStr.toString());
                }
                this.preSyncPref.setPresyncStatus(true);
                this.oucDataStore.setStationSettingsInfo(stationSettingsInfo);
                this.oucDataStore.setChargesInfo(chargesInfo);
                this.oucDataStore.setCheckSumInfo(checksumInfo);
            } else if (CIDRStatus.INVALID_TIMESTAMP == cidrStatus) {
                XMLGregorianCalendar serverTime = response.getTimestamp();
                long serverTimeInMillis = serverTime.toGregorianCalendar().getTimeInMillis();
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm aaa");
                String message = "Client time differs from the server time " + sdf.format(new Date(serverTimeInMillis)) + ".\nPlease reset system time and try again.";
                Object[] options = new Object[]{"Ok"};
                JOptionPane.showOptionDialog(null, message, "Aadhaar", -1, 0, null, options, options[0]);
            }
            return cidrStatus;
        }
        catch (IOException e) {
            throw new StationInfoStoreException("Unable to read/write data into ouc.", (Exception)e);
        }
    }

    private CIDRStatus toCIDRStatus(PreSyncErrorCode errCode) {
        if (errCode == null) {
            return CIDRStatus.SUCCESS;
        }
        switch (errCode) {
            case UNKNOWN_ERROR: {
                return CIDRStatus.UNKNOWN_ERROR;
            }
            case INVALID_TIMESTAMP: {
                return CIDRStatus.INVALID_TIMESTAMP;
            }
            case INVALID_TOKEN: {
                return CIDRStatus.INVALID_TOKEN;
            }
        }
        return CIDRStatus.SUCCESS;
    }

    public void storeOperatorDetails(PreSyncResponse response) {
        if (response.getResult().equals((Object)Result.SUCCESS)) {
            LOGGER.info("Pre sync after on boarding successfully.");
            try {
                if (response.getOperatorSynchTable() != null) {
                    OpSyncDetailsMapper mapper = new OpSyncDetailsMapper();
                    OperatorDetails operatorDetails = mapper.convertToOperatorDetails(response.getOperatorSynchTable(), this.registrationService.getStationId());
                    this.enrolServiceClientApiService.storeOperatorDetails(response.getOperatorSynchTable().getOperatorId(), mapper.convertToOperatorInfo(operatorDetails));
                    OperatorDetailsSer operatorDetailsSer = new OperatorDetailsSer();
                    operatorDetailsSer.setOpId(response.getOperatorSynchTable().getOperatorId());
                    operatorDetailsSer.setOtherDetails(new OpSyncDetailsMapper().convertToOperatorDetailsByteArray(response.getOperatorSynchTable(), this.registrationService.getStationId()));
                    this.opSyncDao.storeDetails(operatorDetailsSer);
                }
            }
            catch (IOException e) {
                throw new StoreOperatorDetailException("Unable to store operator details to ouc.", (Exception)e);
            }
        }
    }
}

