/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.presync;

import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.service.presync.CheckSumDetails;
import in.gov.uidai.ec.service.presync.IServerSyncDAO;
import in.gov.uidai.ec.service.presync.ServerSyncDetails;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSyncDAO
implements IServerSyncDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSyncDAO.class);
    private SqlSession session;

    public void setSqlSession(SqlSession session) {
        this.session = session;
        this.updateAppVersionInRuntimeDB();
    }

    private void updateAppVersionInRuntimeDB() {
        long dbVersion;
        long appVersion = Long.parseLong(ApplicationVersion.VERSION.replace(".", ""));
        if (appVersion != (dbVersion = this.getServerSyncDetails("APPLICATION_VERSION"))) {
            this.updateServerSyncDetails(appVersion, "APPLICATION_VERSION");
        }
    }

    public void updateServerSyncDetails(long lastActivityTime, String activityName) {
        LOGGER.debug("In update method of ServerSyncDao :ActivityName is " + activityName + "Last Activity time is " + lastActivityTime);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("activityTime", lastActivityTime);
        paramMap.put("activityName", activityName);
        try {
            this.session.update("updateServerSyncDetails", paramMap);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    public long getServerSyncDetails(String activityName) {
        LOGGER.debug("In get method of ServerSyncDao :ActivityName is " + activityName);
        try {
            List activityTimeList = this.session.selectList("getServerSyncDetails", (Object)activityName);
            if (activityTimeList.size() == 1) {
                return (Long)activityTimeList.get(0);
            }
            return 0L;
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:report", (Throwable)e);
        }
    }

    @Override
    public void insertServerSyncDetails(String activityName, long lastActivityTime) {
        LOGGER.debug("In insert method of ServerSyncDao :ActivityName is " + activityName + "Last Activity time is " + lastActivityTime);
        ServerSyncDetails syncDetails = new ServerSyncDetails();
        syncDetails.setActivityName(activityName);
        syncDetails.setActivityTime(lastActivityTime);
        try {
            this.session.insert("insertServerSyncDetails", (Object)syncDetails);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    @Override
    public void insertCheckSumDetails(String activityName, String checkSumValue) {
        LOGGER.debug("In insert method of ServerSyncDao :ActivityName is " + activityName + "Checksum value is " + checkSumValue);
        CheckSumDetails checkSumDetail = this.getCheckSum(activityName);
        if (checkSumDetail != null) {
            this.updateCheckSumDetails(activityName, checkSumValue);
        } else {
            CheckSumDetails checkSumDetails = new CheckSumDetails();
            checkSumDetails.setActivityName(activityName);
            checkSumDetails.setCheckSumValue(checkSumValue);
            try {
                this.session.insert("insertCheckSumDetails", (Object)checkSumDetails);
            }
            catch (Exception e) {
                throw new ClientException("domain-errors:internal", (Throwable)e);
            }
        }
    }

    @Override
    public CheckSumDetails getCheckSum(String activityName) {
        CheckSumDetails details = new CheckSumDetails();
        try {
            details = (CheckSumDetails)this.session.selectOne("getCheckSumDetails", (Object)activityName);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
        return details;
    }

    @Override
    public long getVersionValidity() {
        long lPktCount = 0L;
        try {
            lPktCount = (Long)this.session.selectOne("getVersionValidity");
        }
        catch (Exception e) {
            lPktCount = -1L;
        }
        return lPktCount;
    }

    @Override
    public void updateCheckSumDetails(String activityName, String checkSumValue) {
        LOGGER.debug("In update method of ServerSyncDao :ActivityName is " + activityName + "Checksum Value is " + checkSumValue);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("activityName", activityName);
        paramMap.put("checkSumValue", checkSumValue);
        try {
            this.session.update("updateCheckSumDetails", paramMap);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }

    @Override
    public void upsertLastSync(long lastActivityTime) {
        LOGGER.debug("In Upsert LastSync Details method of ServerSyncDao :ActivityName is LAST_SYNC Last Activity time is " + lastActivityTime);
        ServerSyncDetails syncDetails = new ServerSyncDetails();
        syncDetails.setActivityName("LAST_SYNC");
        syncDetails.setActivityTime(lastActivityTime);
        try {
            this.session.delete("deleteLastSync");
            this.session.insert("insertServerSyncDetails", (Object)syncDetails);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }
}

