/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.receipt;

import in.gov.uidai.ec.escapi.ChargesInfo;
import in.gov.uidai.ec.escapi.GpsInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.text.UidLocaleUtils;
import in.gov.uidai.ec.service.enrol.EID;
import in.gov.uidai.ec.service.enrol.GuardianIdType;
import in.gov.uidai.ec.service.enrollment.BiometricsCapture;
import in.gov.uidai.ec.service.enrollment.BiometricsCaptureTrail;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.AadhaarNo;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.ApplicantGender;
import in.gov.uidai.ec.service.enrollment.model.BiometricsExceptionDetail;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.Demographics;
import in.gov.uidai.ec.service.enrollment.model.Email;
import in.gov.uidai.ec.service.enrollment.model.Mobile;
import in.gov.uidai.ec.service.enrollment.model.Name;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.ReferenceDocument;
import in.gov.uidai.ec.service.enrollment.model.ReferenceIntroducer;
import in.gov.uidai.ec.service.enrollment.model.ReferenceRelative;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.service.packetgenerator.xml.GpsDataType;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.receipt.IPDF417Generator;
import in.gov.uidai.ec.service.receipt.IReceiptPrinter;
import in.gov.uidai.ec.service.receipt.PrintReceiptDocNameException;
import in.gov.uidai.ec.service.receipt.PrintRequest;
import in.gov.uidai.ec.service.receipt.ReceiptType;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.FingerSegment;
import in.gov.uidai.qssitv.model.FingerprintQSS;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiptService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceiptService.class);
    private static final String LABEL = "printreceipt-labels:";
    private static final String UidaiEmail = "help@uidai.gov.in";
    private static final String UidaiWebsite = "https://www.uidai.gov.in";
    private static final String UidaiHelplineNumber = "1947";
    private static final String UidaiGooglePlus = "+AadhaarUIDAI";
    private static final String UidaiFacebook = "Aadhaar";
    private static final String UidaiThreads = "aadhaar_official";
    private static final String UidaiInstagram = "aadhaar_official";
    private static final String UidaiYoutube = "Aadhaar UIDAI";
    private static final String Twitter = "@UIDAI";
    private static final String AadhaarAct = "<html><b>Disclosure under section 3(2) of THE AADHAAR (TARGETED DELIVERY OF FINANCIAL AND  OTHER SUBSIDIES&#44; BENEFITS AND  SERVICES) ACT&#44; 2016:</b></html>";
    private static final String UidaiPostalAddress = "P.O. Box #1947 &#44; Bangalore-560001";
    private static final String printTemplate = "single";
    private static final String transliterationLocale = "hi_in";
    private static final String FACE = "Face";
    private static final String IRIS = "Iris";
    private static final String FINGERS = "Fingers";
    private static final String receiptDateFormat = "dd/MM/yyyy HH:mm:ss";
    private static final String eidDateFormat = "yyyyMMddHHmmss";
    private IPreSyncPreference preSyncPref;
    private IRegistrationService registrationService;
    private IResourceBundleContext rbCtx;
    private IPDF417Generator barcodeGenerator;
    private IReceiptPrinter rcptPrinter;
    private EnrollmentService enrollmentService;
    private ISessionService sessionService;
    private IOucDataStore oucDataStore;
    private static final DecimalFormat GPS_FORMAT = new DecimalFormat("00000.00");

    public void setPreSyncPref(IPreSyncPreference preSyncPref) {
        this.preSyncPref = preSyncPref;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setRbCtx(IResourceBundleContext rbCtx) {
        this.rbCtx = rbCtx;
    }

    public void setBarcodeGenerator(IPDF417Generator barcodeGenerator) {
        this.barcodeGenerator = barcodeGenerator;
    }

    public void setRcptPrinter(IReceiptPrinter rcptPrinter) {
        this.rcptPrinter = rcptPrinter;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public void setSessionService(ISessionService iSessionService) {
        this.sessionService = iSessionService;
    }

    public void setOucDataStore(IOucDataStore oucDataStore) {
        this.oucDataStore = oucDataStore;
    }

    public byte[] getEnrolmentReceiptPreview() throws IOException, StationInfoStoreException, PrintReceiptDocNameException {
        PrintRequest printRequest = this.populateInformation(false);
        return this.getContentBytes(printRequest);
    }

    public boolean printEnrolmentReceipt(boolean localLang) throws IOException, StationInfoStoreException, PrintReceiptDocNameException {
        PrintRequest printRequest = this.populateInformation(localLang);
        return this.printReceipt(printRequest);
    }

    private boolean printReceipt(PrintRequest printRequest) {
        this.preparePrintJob(printRequest);
        return this.rcptPrinter.print(printRequest);
    }

    private PrintRequest populateInformation(boolean localLang) throws IOException, StationInfoStoreException, PrintReceiptDocNameException {
        PrintRequest printRequest = new PrintRequest();
        String locale = this.rbCtx.getLocale().toString();
        Map<String, Object> printInfoMap = printRequest.getVarMap();
        printRequest.setLocale(locale);
        this.populateReceiptInformation(printInfoMap, localLang, this.enrollmentService.isUpdateEnrollment(), this.enrollmentService.isDocumentUpdate(), this.enrollmentService.isOffLineDocumentUpdate());
        this.populateResidentDetails(printInfoMap, localLang);
        this.populateResidentAddress(printInfoMap);
        this.populateRelationDetails(printInfoMap);
        this.populateReferencesDetails(printInfoMap);
        this.populateGeneralInfo(printInfoMap);
        this.populateBiometricDetails(printInfoMap);
        this.populateCareOfDetails(printInfoMap, localLang);
        if (this.enrollmentService.isUpdateEnrollment() || this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOffLineDocumentUpdate()) {
            this.populateUpdatedData(printInfoMap);
        }
        return printRequest;
    }

    private void populateUpdatedData(Map<String, Object> dataMap) {
        References references;
        ReferenceIntroducer referenceIntroducer;
        Mobile mobile;
        Contact contact;
        Address address;
        AgeDob ageDob;
        Demographics demographics = this.enrollmentService.getDemographics();
        PersonalDetail personalDetail = demographics.getPersonalDetail();
        dataMap.put("uid", this.getMaskedNumber(demographics.getPersonalDetail().getAadhaarNumber()));
        Name name = personalDetail.getName();
        if (name.isMandatory()) {
            dataMap.put("nameUpdate", name.newEnglish());
            dataMap.put("lNameUpdate", name.newNameLocal());
            dataMap.put("originalName", name.english());
        } else {
            dataMap.put("noNameUpdate", name.english());
            dataMap.put("lNoNameUpdate", name.local());
        }
        ApplicantGender applicantGender = personalDetail.getApplicantGender();
        if (applicantGender.isUpdated()) {
            dataMap.put("gender", applicantGender.getGender().name());
            dataMap.put("lGender", this.getLocalMessage("printreceipt-labels:receipt." + applicantGender.getGender().name(), new Object[0]));
        }
        if ((ageDob = personalDetail.getAgeDob()).isUpdated()) {
            dataMap.put("dob", ageDob.getAgeDobFormatted() + "(" + (Object)((Object)ageDob.getStatus()) + ")");
        }
        if (StringUtils.isNotBlank((String)ageDob.getAgeDobLocal())) {
            dataMap.put("lDob", ageDob.getAgeDobLocal() + "(" + this.getLocalMessage("printreceipt-labels:receipt." + (Object)((Object)ageDob.getStatus()), new Object[0]) + ")");
        }
        if ((address = (contact = demographics.getContact()).getAddress()).isUpdated()) {
            if (StringUtils.isNotBlank((String)address.getCareOfName())) {
                dataMap.put("careOfLabel", address.getCareOf());
                dataMap.put("lCareOfLabel", address.getCareOfLocal());
                dataMap.put("careOfValue", address.getCareOfName());
                dataMap.put("lCareOfValue", address.getCareOfNameLocal());
            }
            dataMap.put("address", address.getFormattedAddress(false));
            dataMap.put("lAddress", address.getFormattedAddress(true));
        }
        if ((mobile = contact.getMobile()).isUpdated()) {
            dataMap.put("mobile", mobile.number());
            dataMap.put("isd", mobile.isdCode());
            dataMap.put("lMobile", mobile.number());
        } else {
            dataMap.remove("mobile");
            dataMap.remove("isd");
        }
        Email email = contact.getEmail();
        if (email.isUpdated()) {
            dataMap.put("email", email.email());
            dataMap.put("lEmail", email.email());
        } else {
            dataMap.remove("email");
        }
        if (!this.enrollmentService.isBiometricUpdate() && !this.enrollmentService.isChildEnrollment()) {
            dataMap.put("isFingerprintNotUpdated", "true");
        }
        String mandatoryBiometricsUpdate = this.enrollmentService.isMandatoryBiometricUpdate() ? this.getResourceMessage("printreceipt-labels:receipt.yes") : this.getResourceMessage("printreceipt-labels:receipt.no");
        dataMap.put("mandatoryBiometricUpdate", mandatoryBiometricsUpdate);
        dataMap.put("nonMandatoryBiometricsUpdateOrPhotoChanged", "No");
        dataMap.put("biometricsUpdate", this.getResourceMessage("printreceipt-labels:receipt.no"));
        if (this.enrollmentService.isBiometricUpdate()) {
            dataMap.put("biometricsUpdate", this.getResourceMessage("printreceipt-labels:receipt.yes"));
            if (!this.enrollmentService.isMandatoryBiometricUpdate()) {
                dataMap.put("nonMandatoryBiometricsUpdateOrPhotoChanged", "Yes");
            }
        }
        dataMap.put("demoUpdate", demographics.isUpdated() ? "Yes" : "No");
        dataMap.put("documentUpdate", this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOffLineDocumentUpdate() ? "Yes" : "No");
        if (this.enrollmentService.isBiometricUpdate()) {
            this.initializeBiometricExceptionMap(dataMap);
            ArrayList<BiometricPosition> goodQualityFingerSegmentList = this.getGoodQualityFingerCaptures();
            if (goodQualityFingerSegmentList.size() > 0) {
                this.setGoodQualityFingerKeys(goodQualityFingerSegmentList, dataMap);
            }
        }
        if ((referenceIntroducer = (references = this.enrollmentService.getReferences()).getReferenceIntroducer()).isMandatory()) {
            dataMap.put("introducerName", referenceIntroducer.getName());
            dataMap.put("tProofValue", referenceIntroducer.getNameLocal());
            dataMap.put("introducerAadhar", referenceIntroducer.getAadhaarNumber());
            dataMap.put("proofType", this.getResourceMessage("printreceipt-labels:receipt.introducer-name"));
            dataMap.put("tProofType", this.getLocalMessage("printreceipt-labels:receipt.introducer-name", new Object[0]));
        }
    }

    private void populateReceiptInformation(Map<String, Object> varMap, boolean localLang, boolean isUpdateEnrolment, boolean isDocumentUpdate, boolean isOffLineDocumentUpdate) throws StationInfoStoreException, IOException {
        String confirmationLabel;
        boolean isNRI;
        varMap.put("operatorName", this.sessionService.getOperatorCredentials().getFullName());
        varMap.put("registrar", this.registrationService.getRegistrarName());
        varMap.put("enrolmentAgency", this.registrationService.getAgencyName());
        varMap.put("uidaiEmailID", UidaiEmail);
        varMap.put("uidaiWebsite", UidaiWebsite);
        varMap.put("uidaiTelephone", UidaiHelplineNumber);
        varMap.put("uidaiPO", UidaiPostalAddress);
        varMap.put("aadhaarAct", AadhaarAct);
        GpsDataType gpsDataType = this.getGpsData();
        varMap.put("clientLocId", gpsDataType.getLatitude() + "," + gpsDataType.getLongitude());
        if (StringUtils.isBlank((String)((String)varMap.get("clientLocId")))) {
            varMap.put("clientLocId", this.getResourceMessage("printreceipt-labels:receipt.notgiven"));
        }
        if (isNRI = this.enrollmentService.isNRIEnrolment()) {
            confirmationLabel = isUpdateEnrolment ? "printreceipt-labels:receipt.update.nri.confirmationMessage" : "printreceipt-labels:receipt.nri.confirmationMessage";
        } else {
            String string = confirmationLabel = isUpdateEnrolment || isDocumentUpdate || isOffLineDocumentUpdate ? "printreceipt-labels:receipt.update.confirmationMessage" : "printreceipt-labels:receipt.confirmationMessage";
        }
        if (isUpdateEnrolment && isNRI) {
            varMap.put("demoUpdate", "Yes");
        } else if (isUpdateEnrolment) {
            varMap.put("demoUpdate", "No");
        }
        if (isDocumentUpdate || isOffLineDocumentUpdate) {
            varMap.put("documentUpdate", "yes");
        }
        if (localLang) {
            varMap.put("consent", "");
            varMap.put("consent_local", this.getResourceMessage("printreceipt-labels:receipt.consent ") + this.rbCtx.getLocaleMessage((Object)confirmationLabel, new Object[0]) + " ");
        } else {
            String sBuffer = this.rbCtx.getLocaleMessage((Object)confirmationLabel, new Object[0]) + " " + this.getResourceMessage("printreceipt-labels:receipt.noObjectionMessage") + " ";
            varMap.put("consent", this.getResourceMessage("printreceipt-labels:receipt.consent") + sBuffer);
            varMap.put("consent_local", "");
        }
        if (isUpdateEnrolment && localLang) {
            varMap.put("lIntroducerMessage", this.getLocalMessage("printreceipt-labels:receipt.introducerMessage", this.enrollmentService.getDemoPersonalDetails().getName().local()));
            varMap.put("introducerMessage", "");
        } else if (isUpdateEnrolment || isDocumentUpdate || isOffLineDocumentUpdate) {
            varMap.put("introducerMessage", this.rbCtx.getMessage((Object)"printreceipt-labels:receipt.introducerMessage", new Object[]{this.enrollmentService.getDemographics().getPersonalDetail().getName().english()}));
            varMap.put("lIntroducerMessage", "");
        }
        varMap.put("declarations", this.getResourceMessage(confirmationLabel));
        varMap.put("uidaiservices", this.getResourceMessage("printreceipt-labels:receipt.uidaiservices"));
        varMap.put("charges", this.getResourceMessage("printreceipt-labels:receipt.charges"));
        varMap.put("free", this.getResourceMessage("printreceipt-labels:receipt.free"));
        varMap.put("chargeone", this.getResourceMessage("printreceipt-labels:receipt.chargeone"));
        varMap.put("chargetwo", this.getResourceMessage("printreceipt-labels:receipt.chargetwo"));
        varMap.put("chargeBiometricUpdate", this.getResourceMessage("printreceipt-labels:receipt.chargeBiometricUpdate"));
        varMap.put("optionone", this.getResourceMessage("printreceipt-labels:receipt.optionone"));
        varMap.put("optiontwo", this.getResourceMessage("printreceipt-labels:receipt.optiontwo"));
        varMap.put("optionthree", this.getResourceMessage("printreceipt-labels:receipt.optionthree"));
        varMap.put("optionfive", this.getResourceMessage("printreceipt-labels:receipt.optionthree"));
        varMap.put("optionBiometricUpdate", this.getResourceMessage("printreceipt-labels:receipt.optionBiometricUpdate"));
        varMap.put("optionfour", this.getResourceMessage("printreceipt-labels:receipt.optionfour"));
        if (this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOffLineDocumentUpdate()) {
            varMap.put("bottomlinedoc", this.getResourceMessage("printreceipt-labels:receipt.bottomlinedoc"));
        } else {
            varMap.put("bottomline", this.getResourceMessage("printreceipt-labels:receipt.bottomline"));
        }
        varMap.put("receipt.cashreceipt", this.getResourceMessage("printreceipt-labels:receipt.cashreceipt"));
        varMap.put("receipt.resident.name", this.getResourceMessage("printreceipt-labels:receipt.resident.name"));
        varMap.put("receipt.gstin.registrar", this.getResourceMessage("printreceipt-labels:receipt.gstin.registrar"));
        varMap.put("receipt.dateofreceiptprinting", this.getResourceMessage("printreceipt-labels:receipt.dateofreceiptprinting"));
        varMap.put("receipt.number", this.getResourceMessage("printreceipt-labels:receipt.number"));
        varMap.put("receipt.registrar.name", this.getResourceMessage("printreceipt-labels:receipt.registrar.name"));
        varMap.put("receipt.enrolment.agency.details", this.getResourceMessage("printreceipt-labels:receipt.enrolment.agency.details"));
        varMap.put("receipt.service", this.getResourceMessage("printreceipt-labels:receipt.service"));
        varMap.put("receipt.amount.charged", this.getResourceMessage("printreceipt-labels:receipt.amount.charged"));
        varMap.put("receipt.gst", this.getResourceMessage("printreceipt-labels:receipt.gst"));
        varMap.put("receipt.total.amount.charged", this.getResourceMessage("printreceipt-labels:receipt.total.amount.charged"));
        varMap.put("receipt.new.enrolment", this.getResourceMessage("printreceipt-labels:receipt.new.enrolment"));
        varMap.put("receipt.biometric.update.mandatoryEnrollment", this.getResourceMessage("printreceipt-labels:receipt.biometric.update.mandatoryEnrollment"));
        varMap.put("receipt.update.enrolment", this.getResourceMessage("printreceipt-labels:receipt.update.enrolment"));
        varMap.put("receipt.demographic.update.enrolment", this.getResourceMessage("printreceipt-labels:receipt.demographic.update.enrolment"));
        varMap.put("receipt.biometric.update.enrolment", this.getResourceMessage("printreceipt-labels:receipt.biometric.update.enrolment"));
        varMap.put("receipt.doc.update.enrolment", this.getResourceMessage("printreceipt-labels:receipt.doc.update.enrolment"));
        varMap.put("cashreceipt", this.getResourceMessage("printreceipt-labels:receipt.cashreceipt"));
        varMap.put("cashReceiptresidentName", this.getResourceMessage("printreceipt-labels:receipt.resident.name"));
        varMap.put("cashReceiptdateofreceiptprinting", this.getResourceMessage("printreceipt-labels:receipt.dateofreceiptprinting"));
        varMap.put("cashReceiptnumber", this.getResourceMessage("printreceipt-labels:receipt.number"));
        varMap.put("cashReceiptRegistrarName", this.getResourceMessage("printreceipt-labels:receipt.registrar.name"));
        varMap.put("cashReceiptEnrolmentAgency", this.getResourceMessage("printreceipt-labels:receipt.enrolment.agency.details"));
        varMap.put("cashReceiptService", this.getResourceMessage("printreceipt-labels:receipt.service"));
        varMap.put("cashReceiptAmountCharged", this.getResourceMessage("printreceipt-labels:receipt.amount.charged"));
        varMap.put("cashReceiptGst", this.getResourceMessage("printreceipt-labels:receipt.gst"));
        varMap.put("cashReceiptTotaAmountCharged", this.getResourceMessage("printreceipt-labels:receipt.total.amount.charged"));
        varMap.put("cashReceiptNewEnrolment", this.getResourceMessage("printreceipt-labels:receipt.new.enrolment"));
        varMap.put("cashReceiptUpdateEnrolment", this.getResourceMessage("printreceipt-labels:receipt.update.enrolment"));
        varMap.put("cashReceiptDemographicUpdateEntrolment", this.getResourceMessage("printreceipt-labels:receipt.demographic.update.enrolment"));
        varMap.put("cashReceiptBiometricUpdateEnrolment", this.getResourceMessage("printreceipt-labels:receipt.biometric.update.enrolment"));
        varMap.put("cashReceiptMandatoryEnrollment", this.getResourceMessage("printreceipt-labels:receipt.biometric.update.mandatoryEnrollment"));
        varMap.put("cashReceiptDocumentUpdateEnrolment", this.getResourceMessage("printreceipt-labels:receipt.doc.update.enrolment"));
        boolean isIntroducer = this.enrollmentService.getReferences().getReferenceIntroducer().isMandatory();
        if (localLang) {
            varMap.put("labels_local", "Yes");
        } else {
            varMap.put("labels_english", "Yes");
        }
        if (localLang && isIntroducer) {
            varMap.put("introducer_local", "Yes");
        } else if (isIntroducer) {
            varMap.put("introducer_english", "Yes");
        }
    }

    private void populateResidentDetails(Map<String, Object> varMap, boolean localLang) {
        boolean updateEnrollment = this.enrollmentService.isUpdateEnrollment();
        PersonalDetail personalDetail = this.enrollmentService.getDemoPersonalDetails();
        Contact contact = this.enrollmentService.getDemoContactDetails();
        String nameGenderLabel = String.format("%s (%s)", personalDetail.getName().english(), this.getResourceMessage("printreceipt-labels:receipt." + personalDetail.getApplicantGender().getGender().name()));
        String nameGenderLabelLocal = String.format("%s (%s)", personalDetail.getName().local(), personalDetail.getApplicantGender().getGenderLocal());
        varMap.put("name", personalDetail.getName().isUpdated() ? personalDetail.getName().newEnglish() : personalDetail.getName().english());
        varMap.put("nameGender", nameGenderLabel);
        varMap.put("lNameGender", nameGenderLabelLocal);
        varMap.put("lName", updateEnrollment ? personalDetail.getName().newNameLocal() : personalDetail.getName().local());
        if (localLang) {
            varMap.put("introducerMessage_local", this.getLocalMessage("printreceipt-labels:receipt.introducerMessage", personalDetail.getName().local()));
            varMap.put("introducerMessage", "");
        } else {
            varMap.put("introducerMessage_local", "");
            varMap.put("introducerMessage", this.rbCtx.getMessage((Object)"printreceipt-labels:receipt.introducerMessage", new Object[]{personalDetail.getName().english()}));
        }
        AgeDob dob = personalDetail.getAgeDob();
        if (!dob.isDobSelected()) {
            varMap.put("ageOrDOBLabel", this.getResourceMessage("printreceipt-labels:receipt.age"));
            varMap.put("tageOrDOBLabel", this.getLocalMessage("printreceipt-labels:receipt.age", new Object[0]));
            String age = dob.getAge().toString();
            if (StringUtils.isNotBlank((String)age) && dob.isValid()) {
                varMap.put("age", age + " " + this.getResourceMessage("printreceipt-labels:receipt.ageYears"));
                varMap.put("ageYearsLocal", this.getLocalMessage("printreceipt-labels:receipt.ageYears", new Object[0]));
            }
        } else {
            varMap.put("ageOrDOBLabel", this.getResourceMessage("printreceipt-labels:receipt.dob"));
            varMap.put("tageOrDOBLabel", this.getLocalMessage("printreceipt-labels:receipt.dob", new Object[0]));
            varMap.put("ageDob", String.format("%s (%s)", new Object[]{dob.getAgeDobFormatted(), dob.getStatus()}));
        }
        varMap.put("isd", StringUtils.isBlank((String)contact.getMobile().number()) ? "" : contact.getMobile().isdCode());
        varMap.put("mobile", StringUtils.isBlank((String)contact.getMobile().number()) ? this.getResourceMessage("printreceipt-labels:receipt.notgiven") : contact.getMobile().number());
        varMap.put("email", StringUtils.isBlank((String)contact.getEmail().email()) ? this.getResourceMessage("printreceipt-labels:receipt.notgiven") : contact.getEmail().email());
        varMap.put("infoShareConsent", true);
        varMap.put("informationSharingConsent", this.getResourceMessage("printreceipt-labels:receipt.yes"));
        varMap.put("consentShare", this.getResourceMessage("printreceipt-labels:receipt.yes"));
        varMap.put("lConsentShare", this.getLocalMessage("printreceipt-labels:receipt.yes", new Object[0]));
        varMap.put("nameOfResident", personalDetail.getName().english());
        varMap.put("lnameOfResident", personalDetail.getName().local());
        if (!this.enrollmentService.getDemoPersonalDetails().getAgeDob().isChild()) {
            varMap.put("isNotMinor", "true");
            if (varMap.containsKey("getAgeDob")) {
                varMap.remove("getAgeDob");
                varMap.remove("displayQualityMsg");
            }
            this.initializeBiometricExceptionMap(varMap);
        } else {
            varMap.put("isMinor", "true");
            varMap.remove("isNotMinor");
        }
    }

    private void initializeBiometricExceptionMap(Map<String, Object> varMap) {
        if (this.enrollmentService.getDemoPersonalDetails().getAgeDob().isChild() || this.enrollmentService.isUpdateEnrollment() && !this.enrollmentService.isBiometricUpdate()) {
            return;
        }
        varMap.put("expLeftThumb", "true");
        varMap.put("expLeftPointerFinger", "true");
        varMap.put("expLeftMiddleFinger", "true");
        varMap.put("expLeftRingFinger", "true");
        varMap.put("expLeftLittleFinger", "true");
        varMap.put("expRightThumb", "true");
        varMap.put("expRightPointerFinger", "true");
        varMap.put("expRightMiddleFinger", "true");
        varMap.put("expRightRingFinger", "true");
        varMap.put("expRightLittleFinger", "true");
        varMap.put("displayQualityMsg", "true");
    }

    private void populateResidentAddress(Map<String, Object> varMap) {
        Contact contact = this.enrollmentService.getDemoContactDetails();
        Address address = contact.getAddress();
        boolean subDistVisible = StringUtils.isNotBlank((String)this.enrollmentService.getDemoContactDetails().getAddress().getSubDistrict());
        String careOf = address.getCareOf() + ": " + address.getCareOfName();
        varMap.put("careOf", careOf);
        varMap.put("building", this.getFormattedAddressValue(address.getBuilding()));
        varMap.put("street", this.getFormattedAddressValue(address.getStreet()));
        varMap.put("landmark", this.getFormattedAddressValue(address.getLandmark()));
        varMap.put("locality", this.getFormattedAddressValue(address.getLocality()));
        varMap.put("city", this.getFormattedAddressValue(address.getVTC()));
        varMap.put("district", this.getFormattedAddressValue(address.getDistrict()));
        varMap.put("state", this.getFormattedAddressValue(address.getState()));
        if (subDistVisible) {
            varMap.put("subDistrict", this.getFormattedAddressValue(address.getSubDistrict()));
        }
        varMap.put("postoffice", this.getFormattedAddressValue(address.getPoName()));
        varMap.put("pincode", this.getFormattedAddressValue(address.getPinCodeValue()));
        varMap.put("lPincode", this.getFormattedAddressValue(address.getPinCodeLocal()));
        String localizedCareOf = this.getFormattedCareOf(address.getCareOfLocal() + ": " + address.getCareOfNameLocal());
        varMap.put("lCareOf", this.getFormattedCareOf(localizedCareOf));
        varMap.put("lBuilding", this.getFormattedAddressValue(address.getBuildingLocal()));
        varMap.put("lStreet", this.getFormattedAddressValue(address.getStreetLocal()));
        varMap.put("lLandmark", this.getFormattedAddressValue(address.getLandmarkLocal()));
        varMap.put("lLocality", this.getFormattedAddressValue(address.getLocalityLocal()));
        varMap.put("lCity", this.getFormattedAddressValue(address.getVTCLocal()));
        if (subDistVisible) {
            varMap.put("lSubDistrict", this.getFormattedAddressValue(address.getSubDistrictLocal()));
        }
        varMap.put("lDistrict", this.getFormattedAddressValue(address.getDistrictLocal()));
        varMap.put("lPostOffice", this.getFormattedAddressValue(address.getPoNameLocal()));
        varMap.put("lState", this.getFormattedAddressValue(address.getStateLocal()));
    }

    private String getFormattedCareOf(String careOfValue) {
        String localeLang = this.rbCtx.getLocale().toString();
        Locale locale = UidLocaleUtils.parseLocaleStr((String)localeLang);
        ComponentOrientation compOrient = ComponentOrientation.getOrientation(locale);
        if (StringUtils.isNotBlank((String)careOfValue) && !compOrient.isLeftToRight()) {
            String[] careOfValues = careOfValue.split(":");
            careOfValue = "\uf000" + careOfValues[1] + " :" + careOfValues[0];
            return careOfValue;
        }
        return careOfValue;
    }

    private void populateRelationDetails(Map<String, Object> varMap) {
        ReferenceRelative relativeDetails = this.enrollmentService.getRelativeDetails();
        RelationshipType relationshipType = relativeDetails.getRelationshipType();
        if (!relativeDetails.isMandatory()) {
            return;
        }
        varMap.put("relationName", relativeDetails.getName());
        if (relationshipType != RelationshipType.NOT_GIVEN) {
            varMap.put("relationType", String.format("(%s)", this.getResourceMessage("printreceipt-labels:receipt." + (Object)((Object)relationshipType))));
            varMap.put("lRelationType", String.format("(%s)", this.getLocalMessage("printreceipt-labels:receipt." + (Object)((Object)relationshipType), new Object[0])));
        } else {
            varMap.put("guardian", "");
        }
        varMap.put("relation", this.getGuardianInfo());
        varMap.put("lRelationName", relativeDetails.getNameLocal());
        varMap.put("relationValue", this.getFormattedGuardianInfo(relativeDetails.getNameLocal()));
        ReferenceDocument hofDoc = this.enrollmentService.getReferences().getHofDoc();
        if (hofDoc.isMandatory()) {
            varMap.put("hofName", this.enrollmentService.getReferences().getReferenceRelative().getName());
        }
        if (relativeDetails.isEnrolmentIdMandatory()) {
            varMap.put("hofIDLabel", this.getResourceMessage("printreceipt-labels:receipt.enrolmentno"));
            varMap.put("lhofIDLabel", this.getLocalMessage("printreceipt-labels:receipt.enrolmentno", new Object[0]));
            varMap.put("hofID", relativeDetails.getEnrolmentId());
        } else if (relativeDetails.isAadhaarNumberMandatory()) {
            varMap.put("hofIDLabel", this.getResourceMessage("printreceipt-labels:receipt.aadhaarNo"));
            varMap.put("lhofIDLabel", this.getLocalMessage("printreceipt-labels:receipt.aadhaarNo", new Object[0]));
            varMap.put("hofID", this.getMaskedHofNumber(relativeDetails.getAadhaarNumber()));
        }
    }

    private String getGuardianInfo() {
        StringBuilder sBuffer = new StringBuilder();
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        if (referenceRelative.isMandatory()) {
            sBuffer.append(referenceRelative.getName());
            this.appendRelativeIdInformation(sBuffer, referenceRelative);
        }
        return sBuffer.toString();
    }

    private void appendRelativeIdInformation(StringBuilder sBuffer, ReferenceRelative referenceRelative) {
        sBuffer.append(" - ");
        sBuffer.append(referenceRelative.isAadhaarNumberMandatory() ? GuardianIdType.UID.toString() : GuardianIdType.EID.toString());
        sBuffer.append(":");
        String relativeId = referenceRelative.isAadhaarNumberMandatory() ? referenceRelative.getAadhaarNumber() : referenceRelative.getFormattedEID();
        sBuffer.append(relativeId);
    }

    private String getFormattedGuardianInfo(String locRelationName) {
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        if (!referenceRelative.isMandatory()) {
            return "";
        }
        StringBuilder sBuffer = new StringBuilder();
        sBuffer.append(referenceRelative.getName());
        if (!"en_in".equalsIgnoreCase(this.rbCtx.getLocale().toString())) {
            sBuffer.append("/");
            sBuffer.append(locRelationName);
        }
        this.appendRelativeIdInformation(sBuffer, referenceRelative);
        return sBuffer.toString();
    }

    private void populateReferencesDetails(Map<String, Object> varMap) throws PrintReceiptDocNameException {
        References references = this.enrollmentService.getReferences();
        ReferenceDocument pob = references.getPob();
        ReferenceDocument poi = references.getPoi();
        ReferenceDocument poa = references.getPoa();
        ReferenceDocument hofDoc = references.getHofDoc();
        ArrayList<String> documentList = new ArrayList<String>();
        if (poi.isMandatory()) {
            if (poi.getProof().getDocName() != null) {
                documentList.add(poi.getProof().getDocName());
            } else {
                throw new PrintReceiptDocNameException("POI document is missing, kindly do enrolment again");
            }
        }
        if (poa.isMandatory()) {
            if (poa.getProof().getDocName() != null) {
                documentList.add(poa.getProof().getDocName());
            } else {
                throw new PrintReceiptDocNameException("POA document is missing, kindly do enrolment again");
            }
        }
        if (hofDoc.isMandatory()) {
            if (hofDoc.getProof().getDocName() != null) {
                documentList.add(hofDoc.getProof().getDocName());
            } else {
                throw new PrintReceiptDocNameException("HOF document is missing, kindly do enrolment again");
            }
        }
        String documents = String.join((CharSequence)", ", documentList);
        ReferenceIntroducer introducer = references.getReferenceIntroducer();
        boolean isIntroducer = introducer.isMandatory();
        if (pob.isMandatory()) {
            if (pob.getProof().getDocName() != null) {
                varMap.put("pobDoc", pob.getProof().getDocName());
            } else {
                throw new PrintReceiptDocNameException("POB document is missing, kindly do enrolment again");
            }
        }
        if (isIntroducer) {
            varMap.put("proofType", this.getResourceMessage("printreceipt-labels:receipt.introducer-name"));
            varMap.put("proofValue", this.getFormattedIntroducerInfo(introducer));
            varMap.put("introName", introducer.getName());
            varMap.put("introducerPresent", true);
            varMap.put("introducerDetails", true);
            varMap.put("introducerAadhaarNo", introducer.getAadhaarNumber());
            varMap.put("tProofType", this.getLocalMessage("printreceipt-labels:receipt.introducer-name", new Object[0]));
            if (StringUtils.isBlank((String)introducer.getNameLocal())) {
                varMap.put("tProofValue", introducer.getName());
            } else {
                varMap.put("tProofValue", introducer.getNameLocal());
            }
        } else if (hofDoc.isMandatory()) {
            varMap.put("hofIntroducer", references.getReferenceRelative().getName());
            varMap.put("proofType", this.getResourceMessage("printreceipt-labels:receipt.hof"));
            varMap.put("proofValue", documents);
            varMap.put("introName", "-NA-");
            varMap.put("hofPresent", true);
            varMap.put("hofDetails", true);
        } else {
            varMap.put("proofType", this.getResourceMessage("printreceipt-labels:receipt.documents"));
            varMap.put("proofValue", documents);
            varMap.put("introName", "-NA-");
        }
        if (!isIntroducer) {
            varMap.put("tProofType", "");
            varMap.put("tProofValue", "");
            varMap.put("introducerAadhaarNo", "-NA-");
        }
        varMap.put("documents", documents);
    }

    private String getFormattedIntroducerInfo(ReferenceIntroducer introducer) {
        return introducer.getName() + "(" + introducer.getAadhaarNumber() + ")";
    }

    private void populateGeneralInfo(Map<String, Object> varMap) throws IOException, StationInfoStoreException {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        EID enrolID = this.enrollmentService.getEnrolId();
        if (enrolID != null) {
            String encodeData = this.populateBarcodeData();
            BufferedImage barcodeImage = this.barcodeGenerator.generatePDF417(encodeData);
            varMap.put("2dBarCode", barcodeImage);
        }
        varMap.put("scanPref", this.preSyncPref.getScanDocuments());
        varMap.put("Template", printTemplate);
        varMap.put("localLang", transliterationLocale);
        varMap.put("uidaiGooglePlus", UidaiGooglePlus);
        varMap.put("uidaiFacebook", UidaiFacebook);
        varMap.put("uidaiInstagram", "aadhaar_official");
        varMap.put("uidaiThreads", "aadhaar_official");
        varMap.put("uidaiYoutube", UidaiYoutube);
        varMap.put("uidaiTwitter", Twitter);
        ChargesInfo chargesInfo = this.oucDataStore.getChargesInfo();
        LOGGER.info("Charges from DB for new :- " + chargesInfo.getAmountChargedForNewEnrolment() + " ...For update :- " + chargesInfo.getAmountChargedForBiometricUpdate() + " ...for Demographic update :- " + chargesInfo.getAmountChargedForDemographicUpdate());
        if (this.isRegConfForPaymentReceipt(this.registrationService.getRegistrarId(), chargesInfo.getRegistrarConfigurationsForPaymentReceipt())) {
            float amountChargedForUpdateEnrolment;
            varMap.put("isRegConfForPaymentReceipt", true);
            varMap.put("regConfForPaymentReceipt", chargesInfo.getRegistrarConfigurationsForPaymentReceipt());
            varMap.put("gstApplied", Float.valueOf(chargesInfo.getGstApplied()));
            varMap.put("amountChargedForNewEnrolment", df.format(chargesInfo.getAmountChargedForNewEnrolment()));
            float gst = chargesInfo.getGstApplied();
            if (this.enrollmentService.isMandatoryBiometricUpdate() && this.enrollmentService.getMandatoryBiometricCheckResponse().getFreeUpdate().equalsIgnoreCase("No")) {
                amountChargedForUpdateEnrolment = chargesInfo.getAmountChargedForBiometricUpdate();
                LOGGER.info("Amount Charges for Mandatory Biometric if chargeable  :- " + amountChargedForUpdateEnrolment);
            } else if (this.enrollmentService.isMandatoryBiometricUpdate() && this.enrollmentService.getMandatoryBiometricCheckResponse().getFreeUpdate().equalsIgnoreCase("Yes") || !this.enrollmentService.isUpdateEnrollment()) {
                amountChargedForUpdateEnrolment = 0.0f;
                LOGGER.info("Amount Charges for Mandatory Biometric if Not chargeable  :- " + amountChargedForUpdateEnrolment);
            } else if (this.enrollmentService.isBiometricUpdate()) {
                amountChargedForUpdateEnrolment = chargesInfo.getAmountChargedForBiometricUpdate();
                LOGGER.info("Amount Charges for Biometric Update  :- " + amountChargedForUpdateEnrolment);
            } else {
                amountChargedForUpdateEnrolment = this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOffLineDocumentUpdate() ? chargesInfo.getAmountChargedForDemographicUpdate() : chargesInfo.getAmountChargedForDemographicUpdate();
            }
            LOGGER.info("IF demographic update/Bio Update ::: " + this.enrollmentService.isUpdateEnrollment() + " If Document only update ::: " + this.enrollmentService.isDocumentUpdate() + " If Mandatory Biometric Update ::: " + this.enrollmentService.isMandatoryBiometricUpdate() + " If OffLine Document Update ::: " + this.enrollmentService.isOffLineDocumentUpdate() + "If Bio update ::: " + this.enrollmentService.isBiometricUpdate());
            float totalAmountChargedForUpdateEnrolment = amountChargedForUpdateEnrolment + amountChargedForUpdateEnrolment * gst / 100.0f;
            varMap.put("amountChargedForUpdateEnrolment", df.format(amountChargedForUpdateEnrolment));
            float amountChargedForNewEnrolment = chargesInfo.getAmountChargedForNewEnrolment();
            float totalAmountChargedForNewEnrolment = amountChargedForNewEnrolment + amountChargedForNewEnrolment * gst / 100.0f;
            LOGGER.info("totalAmountChargedForUpdateEnrolment :- " + totalAmountChargedForUpdateEnrolment);
            LOGGER.info("totalAmountChargedForNewEnrolment :- " + totalAmountChargedForNewEnrolment);
            if (this.enrollmentService.isUpdateEnrollment() || this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isMandatoryBiometricUpdate() || this.enrollmentService.isOffLineDocumentUpdate() || this.enrollmentService.isBiometricUpdate()) {
                varMap.put("totalAmountChargedForUpdateEnrolment", df.format(totalAmountChargedForUpdateEnrolment));
                varMap.put("totalAmountChargedForNewEnrolment", df.format(0L));
            } else {
                varMap.put("totalAmountChargedForNewEnrolment", df.format(totalAmountChargedForNewEnrolment));
                varMap.put("totalAmountChargedForUpdateEnrolment", df.format(0L));
            }
        } else {
            varMap.put("isRegConfForPaymentReceipt", true);
            varMap.put("regConfForPaymentReceipt", true);
            varMap.put("gstApplied", Float.valueOf(chargesInfo.getGstApplied()));
            varMap.put("amountChargedForNewEnrolment", df.format(0L));
            varMap.put("totalAmountChargedForNewEnrolment", df.format(0L));
            varMap.put("totalAmountChargedForUpdateEnrolment", df.format(0L));
            varMap.put("amountChargedForUpdateEnrolment", df.format(0L));
        }
        if (enrolID != null) {
            String enrolDateTime;
            try {
                enrolDateTime = new SimpleDateFormat(receiptDateFormat).format(new SimpleDateFormat(eidDateFormat).parse(enrolID.getEnrolDate()));
            }
            catch (ParseException e) {
                enrolDateTime = "";
            }
            varMap.put("eidString", enrolID.toString());
            varMap.put("enrolId", enrolID.getEnrolNumDecorated());
            varMap.put("enrolIdBarCode", this.forBarcode(enrolID.getEnrolNum()));
            varMap.put("enrolIdTime", enrolID.toString());
            varMap.put("enrolDateTime", enrolDateTime);
        } else {
            varMap.put("enrolId", "-NA-");
            varMap.put("enrolIdBarCode", "-NA-");
            varMap.put("enrolIdTime", "-NA-");
            varMap.put("enrolDateTime", "-NA-");
        }
        String npr = this.enrollmentService.getDemoPersonalDetails().getNpr().getNprNumber();
        npr = StringUtils.isEmpty((String)npr) ? this.getResourceMessage("printreceipt-labels:receipt.notgiven") : npr;
        varMap.put("appointmentNumber", StringUtils.isBlank((String)this.enrollmentService.getAppointmentId()) ? "-NA-" : this.enrollmentService.getAppointmentId());
        varMap.put("nprReceiptNumber", npr);
        varMap.put("npr", npr);
    }

    private void populateCareOfDetails(Map<String, Object> varMap, boolean localLanguage) {
        References references = this.enrollmentService.getReferences();
        varMap.put("lIntroducerDetails", false);
        varMap.put("lHofDetails", false);
        if (references.getReferenceIntroducer().isMandatory()) {
            varMap.put("introducerDetails", true);
            varMap.put("lIntroducerDetails", true);
            varMap.remove("lHofDetails");
            varMap.remove("hofDetails");
            if (localLanguage) {
                varMap.remove("introducerDetails");
            } else {
                varMap.remove("lIntroducerDetails");
            }
        } else if (references.getHofDoc().isMandatory()) {
            varMap.put("lHofDetails", true);
            varMap.put("hofDetails", true);
            varMap.remove("introducerDetails");
            varMap.remove("lIntroducerDetails");
            if (localLanguage) {
                varMap.remove("hofDetails");
            } else {
                varMap.remove("lHofDetails");
            }
        } else {
            varMap.remove("hofDetails");
            varMap.remove("lHofDetails");
            varMap.remove("introducerDetails");
            varMap.remove("lIntroducerDetails");
        }
    }

    private void populateBiometricDetails(Map<String, Object> varMap) {
        BiometricsCapture bestCap;
        BiometricsCaptureTrail trail = this.enrollmentService.getBiometricsTrailMap().get((Object)CaptureModality.FACE);
        if (trail != null && (bestCap = trail.getBestCapture()) != null) {
            byte[] data = bestCap.getRenderData();
            try {
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(data));
                varMap.put("photo", this.convertToBufferedImage(image));
            }
            catch (Exception image) {
                // empty catch block
            }
        }
        Map<String, Integer> bodyPartCount = this.groupCapturedBiometrics();
        Iterator<String> bodyPartItr = bodyPartCount.keySet().iterator();
        StringBuilder sBuffer = new StringBuilder();
        while (bodyPartItr.hasNext()) {
            String bodyPart = bodyPartItr.next();
            int partCount = bodyPartCount.get(bodyPart);
            if (partCount <= 0) continue;
            sBuffer.append(bodyPart);
            if (partCount != 32) {
                sBuffer.append('(').append(partCount).append(')');
            }
            if (!bodyPartItr.hasNext()) continue;
            sBuffer.append(", ");
        }
        ArrayList<BiometricPosition> goodQualityFingerSegmentList = this.getGoodQualityFingerCaptures();
        if (goodQualityFingerSegmentList.size() > 0) {
            this.setGoodQualityFingerKeys(goodQualityFingerSegmentList, varMap);
        }
        if (!this.enrollmentService.isUpdateEnrollment()) {
            varMap.put("capturedBiometricsDetails", sBuffer.toString());
        } else if (this.enrollmentService.isBiometricUpdate()) {
            varMap.put("capturedUpdatedBiometricsDetails", sBuffer.toString());
        } else if (!this.enrollmentService.isBiometricUpdate() && !this.enrollmentService.isPhotographCaptureEnabled()) {
            varMap.put("capturedUpdatedBiometricsDetails", "NA");
        } else if (!this.enrollmentService.isBiometricUpdate()) {
            varMap.put("capturedUpdatedBiometricsDetails", FACE);
        }
    }

    private String populateBarcodeData() {
        StringBuilder sb = new StringBuilder();
        String delimiter = ":";
        String enrolID = this.enrollmentService.getEnrolId().toString();
        sb.append(delimiter);
        sb.append(enrolID);
        sb.append(delimiter);
        sb.append(this.extractReferenceDocInformation());
        sb.append(delimiter);
        sb.append("E");
        sb.append(delimiter);
        return sb.toString();
    }

    private String extractReferenceDocInformation() {
        String phofDocId;
        String pobDocId;
        String poaDocId;
        String poiDocId;
        References references = this.enrollmentService.getReferences();
        ReferenceDocument poi = references.getPoi();
        ReferenceDocument poa = references.getPoa();
        ReferenceDocument pob = references.getPob();
        ReferenceDocument hofDoc = references.getHofDoc();
        StringBuilder sb = new StringBuilder();
        String delimiter = ":";
        if (poi.isMandatory() && (poiDocId = poi.getProof().getDocId()) != null) {
            sb.append(poiDocId);
            sb.append(delimiter);
        }
        if (poa.isMandatory() && (poaDocId = poa.getProof().getDocId()) != null) {
            sb.append(poaDocId);
            sb.append(delimiter);
        }
        if (pob.isMandatory() && StringUtils.isNotBlank((String)pob.getProof().getDocName()) && !pob.getProof().getDocName().equals("Select") && (pobDocId = pob.getProof().getDocId()) != null) {
            sb.append(pobDocId);
            sb.append(delimiter);
        }
        if (hofDoc.isMandatory() && (phofDocId = hofDoc.getProof().getDocId()) != null) {
            sb.append(phofDocId);
            sb.append(delimiter);
        }
        return sb.toString();
    }

    private boolean isRegConfForPaymentReceipt(String registrarId, String[] registrarConfirmationForPaymentReceipt) {
        if (registrarConfirmationForPaymentReceipt != null) {
            List<String> list = Arrays.asList(registrarConfirmationForPaymentReceipt);
            return list.contains(registrarId);
        }
        return false;
    }

    private String forBarcode(String normalText) {
        return "*" + normalText + '*';
    }

    private BufferedImage convertToBufferedImage(Image img) {
        BufferedImage buffim = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        Graphics bimg = buffim.getGraphics();
        bimg.drawImage(img, 0, 0, null);
        bimg.dispose();
        return buffim;
    }

    private Map<String, Integer> groupCapturedBiometrics() {
        BiometricsExceptionDetail biometricsExceptionDetail = this.enrollmentService.getBiometricsException().getExceptionDetail();
        int fingerCount = 10;
        int irisCount = 2;
        irisCount -= biometricsExceptionDetail.getMissingEyes().size();
        fingerCount -= biometricsExceptionDetail.getMissingFingers().size();
        int age = this.enrollmentService.getDemoPersonalDetails().getAgeDob().getAge();
        HashMap<String, Integer> bodyPartCount = new HashMap<String, Integer>();
        if (this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob().isChild()) {
            bodyPartCount.put(FINGERS, 0);
            bodyPartCount.put(IRIS, 0);
        } else {
            bodyPartCount.put(FINGERS, fingerCount);
            bodyPartCount.put(IRIS, irisCount);
        }
        bodyPartCount.put(FACE, 32);
        return bodyPartCount;
    }

    private ArrayList<BiometricPosition> getGoodQualityFingerCaptures() {
        ArrayList<BiometricPosition> capturedBodyParts = new ArrayList<BiometricPosition>();
        Collection<BiometricsCaptureTrail> bioCaptures = this.enrollmentService.getBiometricsTrailMap().values();
        bioCaptures.stream().filter(bct -> Stream.of(CaptureModality.LEFT_SLAP, CaptureModality.RIGHT_SLAP, CaptureModality.THUMB_SLAP).anyMatch(captureModality -> bct.getModality() == captureModality)).forEach(bct -> capturedBodyParts.addAll(this.getSegmentedFingerPrintQualityScore(bct.getBestCapture())));
        return capturedBodyParts;
    }

    private List<BiometricPosition> getSegmentedFingerPrintQualityScore(BiometricsCapture bestCapture) {
        int NFIQ_THRESHOLD = 3;
        ArrayList<BiometricPosition> goodQualityFingerSegmentList = new ArrayList<BiometricPosition>();
        FingerprintQSS qss = (FingerprintQSS)bestCapture.getQss();
        if (qss != null) {
            List fingerSegments = qss.getFingerSegments();
            for (FingerSegment segment : fingerSegments) {
                BiometricPosition fingerPosition = segment.getFingerPosition();
                double individualFingerScore = segment.getQuality();
                if (!(individualFingerScore <= 3.0)) continue;
                goodQualityFingerSegmentList.add(fingerPosition);
            }
        }
        return goodQualityFingerSegmentList;
    }

    private void setGoodQualityFingerKeys(List<BiometricPosition> goodQualityFingersList, Map<String, Object> varMap) {
        if (this.enrollmentService.getDemoPersonalDetails().getAgeDob().isChild() || this.enrollmentService.isUpdateEnrollment() && !this.enrollmentService.isBiometricUpdate()) {
            return;
        }
        List<BiometricPosition> lstMissingFingers = this.enrollmentService.getBiometricsException().getExceptionDetail().getMissingFingers();
        boolean isRightThumbAvailable = false;
        if (lstMissingFingers.size() > 0) {
            List<BiometricPosition> lstAvailableFingers = this.enrollmentService.getBiometricsException().getExceptionDetail().getAvailableFingers();
            for (BiometricPosition biometricPosition : lstAvailableFingers) {
                if (!biometricPosition.name().equalsIgnoreCase("RIGHT_THUMB")) continue;
                isRightThumbAvailable = true;
                break;
            }
            for (BiometricPosition biometricPosition : lstMissingFingers) {
                if (!biometricPosition.name().equalsIgnoreCase("LEFT_THUMB") || !isRightThumbAvailable) continue;
                goodQualityFingersList.remove(BiometricPosition.LEFT_THUMB);
                goodQualityFingersList.add(BiometricPosition.RIGHT_THUMB);
                break;
            }
        }
        for (BiometricPosition goodQualityFinger : goodQualityFingersList) {
            switch (goodQualityFinger) {
                case LEFT_THUMB: {
                    varMap.put("leftThumb", "true");
                    varMap.remove("expLeftThumb");
                    break;
                }
                case LEFT_INDEX: {
                    varMap.put("leftPointerFinger", "true");
                    varMap.remove("expLeftPointerFinger");
                    break;
                }
                case LEFT_MIDDLE: {
                    varMap.put("leftMiddleFinger", "true");
                    varMap.remove("expLeftMiddleFinger");
                    break;
                }
                case LEFT_RING: {
                    varMap.put("leftRingFinger", "true");
                    varMap.remove("expLeftRingFinger");
                    break;
                }
                case LEFT_LITTLE: {
                    varMap.put("leftLittleFinger", "true");
                    varMap.remove("expLeftLittleFinger");
                    break;
                }
                case RIGHT_THUMB: {
                    varMap.put("rightThumb", "true");
                    varMap.remove("expRightThumb");
                    break;
                }
                case RIGHT_INDEX: {
                    varMap.put("rightPointerFinger", "true");
                    varMap.remove("expRightPointerFinger");
                    break;
                }
                case RIGHT_MIDDLE: {
                    varMap.put("rightMiddleFinger", "true");
                    varMap.remove("expRightMiddleFinger");
                    break;
                }
                case RIGHT_RING: {
                    varMap.put("rightRingFinger", "true");
                    varMap.remove("expRightRingFinger");
                    break;
                }
                case RIGHT_LITTLE: {
                    varMap.put("rightLittleFinger", "true");
                    varMap.remove("expRightLittleFinger");
                }
            }
        }
    }

    private byte[] getContentBytes(PrintRequest prnReq) {
        this.preparePrintJob(prnReq);
        return this.rcptPrinter.printToFile(prnReq);
    }

    private void preparePrintJob(PrintRequest prnReq) {
        prnReq.setReceiptType(this.enrollmentService.isUpdateEnrollment() && this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOffLineDocumentUpdate() ? ReceiptType.ENROL_DOC_UPDATE : (this.enrollmentService.isUpdateEnrollment() ? ReceiptType.ENROL_UPDATE : ReceiptType.ENROL));
        StringBuilder jobName = new StringBuilder("Aadhaar Receipt - ");
        EID eid = this.enrollmentService.getEnrolId();
        if (eid != null) {
            jobName.append(eid.getEnrolNum()).append('-').append(eid.getEnrolDate());
        } else {
            jobName.append(Long.toString(System.currentTimeMillis(), 36).toLowerCase());
        }
        prnReq.setJobName(jobName.toString());
    }

    private String getResourceMessage(String key) {
        return this.rbCtx.getMessage((Object)key, new Object[0]);
    }

    private String getLocalMessage(Object key, Object ... args) {
        return this.rbCtx.getLocaleMessage(key, args);
    }

    private String getFormattedAddressValue(String value) {
        return StringUtils.isBlank((String)value) ? "" : value + ",";
    }

    private String getMaskedNumber(AadhaarNo aadhaarNo) {
        String uid = aadhaarNo.getAadhaarNumber();
        if (StringUtils.isNotBlank((String)uid)) {
            String maskedNumber;
            if (StringUtils.length((String)uid) == 12) {
                maskedNumber = uid.substring(8, 12);
                maskedNumber = "XXXX-XXXX-" + maskedNumber;
            } else {
                maskedNumber = uid;
            }
            return maskedNumber;
        }
        return "INVALID DATA";
    }

    private GpsDataType getGpsData() throws IOException, StationInfoStoreException {
        GpsDataType gpsDataType = new GpsDataType();
        GpsInfo gpsInfo = this.oucDataStore.getGpsInfo();
        float latitude = gpsInfo.getLatitude().floatValue();
        float longitude = gpsInfo.getLongitude().floatValue();
        float altitude = gpsInfo.getAltitude().floatValue();
        if (latitude == -1.0f && longitude == -1.0f && altitude == -1.0f) {
            return null;
        }
        if (latitude >= 0.0f) {
            gpsDataType.setLatitude(GPS_FORMAT.format(latitude));
        }
        if (longitude >= 0.0f) {
            gpsDataType.setLongitude(GPS_FORMAT.format(longitude));
        }
        if (altitude >= 0.0f) {
            gpsDataType.setAltitude(GPS_FORMAT.format(altitude));
        }
        return gpsDataType;
    }

    private String getMaskedHofNumber(String aadhaarNo) {
        String uid = aadhaarNo;
        if (StringUtils.isNotBlank((String)uid)) {
            String maskedNumber;
            if (StringUtils.length((String)uid) == 12) {
                maskedNumber = uid.substring(8, 12);
                maskedNumber = "XXXX-XXXX-" + maskedNumber;
            } else {
                maskedNumber = uid;
            }
            return maskedNumber;
        }
        return "INVALID DATA";
    }
}

