/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.registration;

import in.gov.uidai.ec.ecmpapi.CIDRStatus;
import in.gov.uidai.ec.ecmpapi.xml.stationderegister.DeRegisterStationResponse;
import in.gov.uidai.ec.ecmpapi.xml.stationderegister.Result;
import in.gov.uidai.ec.ecmpapi.xml.stationderegister.StationDeRegistrationData;
import in.gov.uidai.ec.ecmpapi.xml.stationderegister.StationDeRegistrationErrorCode;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeRegisterStationDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeRegisterStationDelegate.class);

    public StationDeRegistrationData prepareServiceRequest(String operatorId, IRegistrationService registrationService) throws Exception {
        StationDeRegistrationData deregistrationData = new StationDeRegistrationData();
        deregistrationData.setUserName("ECMP - " + operatorId);
        deregistrationData.setEnrolmentAgencyCode(registrationService.getAgencyId());
        deregistrationData.setMachineCode(registrationService.getRegisteredMachineCode());
        deregistrationData.setRegistrarId(registrationService.getRegistrarId());
        deregistrationData.setStationNumber(registrationService.getStationId());
        deregistrationData.setClientVersion(ApplicationVersion.VERSION);
        deregistrationData.setClientType("ECA");
        deregistrationData.setDeRegistrationTime(DateUtils.getXMLTimeStamp(System.currentTimeMillis()));
        return deregistrationData;
    }

    public CIDRStatus processServiceResponse(DeRegisterStationResponse response) {
        if (response == null) {
            LOGGER.error("No CIDR Response to process.");
            return CIDRStatus.NETWORK_ERROR;
        }
        LOGGER.info("----------Client Deregistration Details---------");
        LOGGER.info(DateUtils.toString(response.getAgencyDetails()));
        LOGGER.info(DateUtils.toString(response.getRegistarDetails()));
        LOGGER.info(DateUtils.toString(response.getTimestamp()));
        LOGGER.info(DateUtils.toString(response.getResult()));
        LOGGER.info("----------Client Deregistration Details---------");
        CIDRStatus cidrStatus = this.toCIDRStatus(response);
        LOGGER.info("Deregistration of Client returned with:" + cidrStatus.getDescription());
        return Result.SUCCESS.equals((Object)response.getResult()) ? CIDRStatus.SUCCESS : cidrStatus;
    }

    private CIDRStatus toCIDRStatus(DeRegisterStationResponse response) {
        StationDeRegistrationErrorCode errCode = response.getErrorCode();
        Result result = response.getResult();
        if (errCode == null) {
            return result == Result.SUCCESS ? CIDRStatus.SUCCESS : CIDRStatus.NO_ERROR_DESCRIPTION_FROM_SERVER;
        }
        LOGGER.info("Deregistration error Code from server:" + errCode.value());
        if (errCode == StationDeRegistrationErrorCode.UNKNOWN_ERROR) {
            return CIDRStatus.UNKNOWN_ERROR;
        }
        return CIDRStatus.SUCCESS;
    }
}

