/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.registration;

import in.gov.uidai.ec.ecmpapi.CIDRStatus;
import in.gov.uidai.ec.ecmpapi.ClientInformation;
import in.gov.uidai.ec.ecmpapi.xml.stationregister.RegisterStationRequest;
import in.gov.uidai.ec.ecmpapi.xml.stationregister.RegisterStationResponse;
import in.gov.uidai.ec.ecmpapi.xml.stationregister.Result;
import in.gov.uidai.ec.ecmpapi.xml.stationregister.StationRegistrationData;
import in.gov.uidai.ec.ecmpapi.xml.stationregister.StationRegistrationErrorCode;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class RegisterStationDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisterStationDelegate.class);
    private static final DecimalFormat AGENCY_FORMAT = new DecimalFormat("0000");
    private static final DecimalFormat STATION_FORMAT = new DecimalFormat("00000");
    private static final DecimalFormat REGISTRAR_FORMAT = new DecimalFormat("000");
    private final IRegistrationService registrationService;

    public RegisterStationDelegate(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public StationRegistrationData prepareRegistrationDataForRegister(ClientInformation ci, boolean isStep1) {
        StationRegistrationData registrationData = new StationRegistrationData();
        registrationData.setMachineCode(ci.getMachineCode());
        registrationData.setRegistrarId(REGISTRAR_FORMAT.format(Integer.parseInt(ci.getRegistrarId())));
        registrationData.setEnrolmentAgencyCode(AGENCY_FORMAT.format(Integer.parseInt(ci.getAgencyId())));
        registrationData.setStationNumber(STATION_FORMAT.format(Integer.parseInt(ci.getStationId())));
        String clientVersion = ApplicationVersion.VERSION;
        if (isStep1) {
            clientVersion = clientVersion + ".N";
        }
        registrationData.setClientVersion(clientVersion);
        registrationData.setClientType("ECA");
        return registrationData;
    }

    @Transactional
    public CIDRStatus processServiceResponse(RegisterStationRequest request, RegisterStationResponse response, boolean isStep1) {
        if (response == null) {
            LOGGER.error("No CIDR Response to process.");
            return CIDRStatus.NETWORK_ERROR;
        }
        CIDRStatus cidrStatus = this.toCIDRStatus(response);
        if (Result.SUCCESS.equals((Object)response.getResult())) {
            try {
                this.registrationService.doRegistrationRequested(request.getRegistrationData().getRegistrarId(), response.getRegistarDetails().getName(), request.getRegistrationData().getEnrolmentAgencyCode(), response.getAgencyDetails().getName(), request.getRegistrationData().getStationNumber(), response.getEnrolmentSequenceNumber().longValue(), response.getTokenMap(), String.valueOf(response.getTimestamp()), isStep1);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                return cidrStatus;
            }
        }
        LOGGER.error("Registration of Client returned with:" + cidrStatus.getDescription());
        return cidrStatus;
    }

    private CIDRStatus toCIDRStatus(RegisterStationResponse response) {
        StationRegistrationErrorCode errCode = response.getErrorCode();
        Result result = response.getResult();
        if (errCode == null) {
            return result == Result.SUCCESS ? CIDRStatus.SUCCESS : CIDRStatus.NO_ERROR_DESCRIPTION_FROM_SERVER;
        }
        switch (errCode) {
            case STATION_IN_USE: {
                return CIDRStatus.STATION_IN_USE;
            }
            case EA_NOT_LINKED_TO_REGISTRAR: {
                return CIDRStatus.EA_NOT_LINKED_TO_REGISTRAR;
            }
            case INVALID_ENROLMENT_AGENCY: {
                return CIDRStatus.INVALID_ENROLMENT_AGENCY;
            }
            case INVALID_REGISTRAR: {
                return CIDRStatus.INVALID_REGISTRAR;
            }
            case INVALID_XML: {
                return CIDRStatus.LOCAL_DATA_ERROR;
            }
            case LOGIN_FAILED: {
                return CIDRStatus.LOGIN_FAILURE;
            }
            case UNKNOWN_ERROR: {
                return CIDRStatus.UNKNOWN_ERROR;
            }
        }
        return CIDRStatus.SUCCESS;
    }
}

