/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.registration;

import in.gov.uidai.ec.ecmpapi.ITokenProvider;
import in.gov.uidai.ec.ecmpapi.xml.tokendist.TokenEntities;
import in.gov.uidai.ec.ecmpapi.xml.tokendist.TokenEntity;
import in.gov.uidai.ec.escapi.CompleteDeRegistrationException;
import in.gov.uidai.ec.escapi.EnrolServiceClientApiService;
import in.gov.uidai.ec.escapi.EnrolmentInfo;
import in.gov.uidai.ec.escapi.RegistrationInfo;
import in.gov.uidai.ec.escapi.StartDeRegistrationException;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStoreAware;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.security.sapi.IMachineIdentity;
import in.gov.uidai.ec.service.machineidentity.MachineIdentityFactory;
import in.gov.uidai.ec.service.onboarding.IOnboardingService;
import in.gov.uidai.ec.service.packet.IPacketService;
import in.gov.uidai.ec.service.presync.IServerSyncDAO;
import in.gov.uidai.ec.service.registration.DeregInProgressStatus;
import in.gov.uidai.ec.service.registration.IRegistrationProperties;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.registration.ISequenceMasterDAO;
import in.gov.uidai.ec.service.registration.MachineCodeCheckException;
import in.gov.uidai.ec.service.registration.RegistrationException;
import in.gov.uidai.ec.service.registration.SequenceStoreException;
import in.gov.uidai.ec.service.registration.TokenAPIStoreException;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RegistrationService
implements IRegistrationService,
IPreferenceStoreAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistrationService.class);
    private static final String ENROL_ID_GEN = "SEQ_ENROL_ID_GEN";
    private static final String ENROL_ID_SEQUENCE_NAME = "SEQ_ENROL_ID_GEN";
    private static final String MACHINE_ID_TYPE_PRIMARY = "primary";
    private static final String MACHINE_ID_TYPE_SECONDARY = "secondary";
    private IRegistrationProperties registrationProperties;
    private ISequenceMasterDAO seqMaster;
    private IPreferenceStore preferenceStore;
    private ITokenProvider tokenManager;
    private IServerSyncDAO servSyncDAO;
    private IOnboardingService onboardingService;
    private IPacketService packetService;
    private IOucDataStore oucDataStore;
    private boolean anyOperatorOnboardedStatusNeedsRefresh = true;
    private boolean anyOperatorOnboarded;
    private String oemName;
    @Autowired
    private EnrolServiceClientApiService enrolServiceClientApiService;

    public void setPacketService(IPacketService packetService) {
        this.packetService = packetService;
    }

    public void setRegistrationProperties(IRegistrationProperties registrationProperties) {
        this.registrationProperties = registrationProperties;
    }

    public void setOucDataStore(IOucDataStore oucDataStore) {
        this.oucDataStore = oucDataStore;
    }

    public void setTokenManagerDAO(ITokenProvider tokenManager) {
        this.tokenManager = tokenManager;
    }

    public void setServSyncDAO(IServerSyncDAO servSyncDAO) {
        this.servSyncDAO = servSyncDAO;
    }

    public void setOnboardingService(IOnboardingService onboardingService) {
        this.onboardingService = onboardingService;
    }

    public void setSequenceMaster(ISequenceMasterDAO seqMaster) {
        this.seqMaster = seqMaster;
    }

    public void setPreferenceStore(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
    }

    @Override
    public String getSystemMachineCode() {
        try {
            String machineCode;
            IMachineIdentity machineId = MachineIdentityFactory.getIdentity();
            this.oemName = machineId.getOEMName();
            switch (StringUtils.trimToEmpty((String)this.registrationProperties.getRegisteredMachineIdMode())) {
                case "primary": {
                    machineCode = this.oemName + machineId.getPrimaryMachineHash();
                    break;
                }
                case "secondary": {
                    machineCode = this.oemName + machineId.getSecondaryMachineHash();
                    break;
                }
                default: {
                    machineCode = machineId.getUniqueMachineId();
                }
            }
            return machineCode.length() > 100 ? machineCode.substring(0, 100) : machineCode;
        }
        catch (Exception e) {
            LOGGER.error("Error while generating machine code", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getRegisteredMachineCode() {
        return this.registrationProperties.getClientMachineCode();
    }

    @Override
    public String getAgencyId() {
        return this.registrationProperties.getAgencyId("0");
    }

    @Override
    public String getAgencyName() {
        return this.registrationProperties.getAgencyName();
    }

    @Override
    public String getRegistrarId() {
        return this.registrationProperties.getRegistrarId("0");
    }

    @Override
    public String getRegistrarName() {
        return this.registrationProperties.getRegistrarName();
    }

    @Override
    public String getStationId() {
        return this.registrationProperties.getStationId("0");
    }

    @Override
    public String getClientLocation() {
        return this.registrationProperties.getClientLocation("0");
    }

    @Override
    public String getRegistrationTime() {
        return this.registrationProperties.getRegTime();
    }

    @Override
    public void notifyOperatorOnboarded() {
        this.anyOperatorOnboardedStatusNeedsRefresh = true;
    }

    @Override
    public void notifyOperatorUnboarded() {
        this.anyOperatorOnboardedStatusNeedsRefresh = true;
    }

    @Override
    public boolean canDoRegistration() {
        return !this.isRegistered() && !this.isRegistrationRequested() && !this.isDeregistrationPrerequisitesInProgress();
    }

    @Override
    public boolean hasMachineCodeChanged() throws Exception {
        String registeredMachineCode = this.getRegisteredMachineCode();
        if (registeredMachineCode == null) {
            return false;
        }
        String systemMachineCode = this.getSystemMachineCode();
        if (systemMachineCode == null) {
            throw new MachineCodeCheckException("error computing system machine code");
        }
        String registeredOemName = this.registrationProperties.getMachineOem();
        if (StringUtils.isNotBlank((String)registeredOemName) && StringUtils.isNotBlank((String)this.oemName) && !this.oemName.equals(registeredOemName)) {
            LOGGER.warn("Machine code check : OEM name mismatch. Current OEM name : " + this.oemName);
            this.diagnoseChangeInMachineDetails();
            return true;
        }
        String registeredPrimaryMachineHash = this.registrationProperties.getPrimaryMachineHash();
        String registeredSecondaryMachineHash = this.registrationProperties.getSecondaryMachineHash();
        if (registeredPrimaryMachineHash != null && registeredSecondaryMachineHash != null) {
            switch (StringUtils.trimToEmpty((String)this.registrationProperties.getRegisteredMachineIdMode())) {
                case "primary": {
                    LOGGER.debug("Machine code check: Checking Primary machine hash");
                    if (registeredPrimaryMachineHash.equals(MachineIdentityFactory.getIdentity().getPrimaryMachineHash())) {
                        return false;
                    }
                    this.diagnoseChangeInMachineDetails();
                    LOGGER.warn("Machine code check : Primary hash mismatch");
                    return true;
                }
                case "secondary": {
                    LOGGER.debug("Machine code check: Checking secondary machine hash");
                    if (registeredSecondaryMachineHash.equals(MachineIdentityFactory.getIdentity().getSecondaryMachineHash())) {
                        return false;
                    }
                    this.diagnoseChangeInMachineDetails();
                    LOGGER.warn("Machine code check : Secondary hash mismatch");
                    return true;
                }
            }
        }
        LOGGER.debug("Machine Check: Checking legacy values");
        return !systemMachineCode.contains(registeredMachineCode) && !registeredMachineCode.contains(systemMachineCode);
    }

    @Override
    public void diagnoseChangeInMachineDetails() {
        LOGGER.debug("This machine was registered with it's " + this.registrationProperties.getRegisteredMachineIdMode() + " machine code");
        MachineIdentityFactory.getIdentity().diagnoseChangeInMachineIdentity(this.registrationProperties.getMachineDetails());
    }

    private void setMachineCodeDetails(String oemName, String primaryMachineHash, String secondaryMachineHash, String machineDetails, String registeredMachineIdMode) {
        LOGGER.info("setting oem, primary and secondary hash:" + oemName + "|" + primaryMachineHash + "|" + secondaryMachineHash + "|" + registeredMachineIdMode);
        this.registrationProperties.setMachineOem(oemName);
        this.registrationProperties.setPrimaryMachineHash(primaryMachineHash);
        this.registrationProperties.setSecondaryMachineHash(secondaryMachineHash);
        this.registrationProperties.setMachineDetails(machineDetails);
        this.registrationProperties.setRegisteredMachineIdMode(registeredMachineIdMode);
    }

    @Override
    public boolean isRegistrationRequested() {
        return this.registrationProperties.getClientRegistered() && !this.isAnyOperatorOnboarded();
    }

    @Override
    public boolean isRegistered() {
        return this.registrationProperties.getClientRegistered();
    }

    @Override
    public boolean isDeregistrationInProgress() {
        return this.isDeregistrationPrerequisitesInProgress() || this.isDeregistrationPrerequisitesCompleted() && !this.isDeregistered();
    }

    @Override
    public boolean isDeregistered() {
        return !this.registrationProperties.getClientRegistered();
    }

    @Override
    public boolean isDeregistrationPrerequisitesInProgress() {
        String clientDereginprogress = this.registrationProperties.getClientDereginprogress();
        return StringUtils.equalsIgnoreCase((String)clientDereginprogress, (String)DeregInProgressStatus.IN_PROGRESS.toString());
    }

    @Override
    public boolean isDeregistrationPrerequisitesNotStarted() {
        String clientDereginprogress = this.registrationProperties.getClientDereginprogress();
        return StringUtils.isBlank((String)clientDereginprogress) || StringUtils.equalsIgnoreCase((String)clientDereginprogress, (String)DeregInProgressStatus.NOT_STARTED.toString());
    }

    @Override
    public boolean isDeregistrationPrerequisitesCompleted() {
        return this.isDeregistrationPrerequisitesInProgress() && this.packetService.getCountOfUnUploadedAndResendPackets() == 0;
    }

    @Override
    public void makeSeqNumberConsistentInDBAndSavedDat() throws IOException, StationInfoStoreException {
        String seqNumberInDB = Long.toString(this.getCurrentEnrolIDSequence());
        EnrolmentInfo enrolmentInfo = this.oucDataStore.getEnrolmentInfo();
        if (!StringUtils.equalsIgnoreCase((String)enrolmentInfo.getSequenceNumber(), (String)seqNumberInDB)) {
            this.registrationProperties.setSequenceNumber(seqNumberInDB);
            EnrolmentInfo newEnrolmentInfo = new EnrolmentInfo();
            newEnrolmentInfo.setSequenceNumber(seqNumberInDB);
            try {
                this.oucDataStore.setEnrolmentInfo(newEnrolmentInfo);
            }
            catch (IOException e) {
                LOGGER.info("Failed to connect to Enrol Service Client. Enrolment sequence number was not stored/updated in Enrol Service Client.");
            }
            catch (StationInfoStoreException e) {
                LOGGER.info("Error storing/updating enrolment sequence number in Enrol Service Client", (Object[])e.getStackTrace());
            }
        }
    }

    @Override
    public synchronized long getNextEnrolIDSequence() {
        long currentSeq = this.seqMaster.getNextValue("SEQ_ENROL_ID_GEN");
        EnrolmentInfo enrolmentInfo = new EnrolmentInfo();
        enrolmentInfo.setSequenceNumber(Long.toString(currentSeq));
        try {
            this.oucDataStore.setEnrolmentInfo(enrolmentInfo);
        }
        catch (IOException e) {
            LOGGER.info("Failed to connect to Enrol Service Client. Enrolment sequence number was not stored/updated in Enrol Service Client.");
        }
        catch (StationInfoStoreException e) {
            LOGGER.info("Error storing/updating enrolment sequence number in Enrol Service Client", (Object[])e.getStackTrace());
        }
        this.registrationProperties.setSequenceNumber(Long.toString(currentSeq));
        LOGGER.info("Generated new sequence number: " + currentSeq);
        this.preferenceStore.save();
        return currentSeq;
    }

    @Override
    public String getApplicationFullVersion() {
        return String.join((CharSequence)"-", ApplicationVersion.INTERNALVERSION, ApplicationVersion.DISTRIBUTION, ApplicationVersion.OS, ApplicationVersion.ARCH);
    }

    @Override
    public long getCurrentEnrolIDSequence() {
        return this.seqMaster.getSequence("SEQ_ENROL_ID_GEN");
    }

    @Override
    public void setEaadhaarSequenceNumber(String sequenceNumber) {
        this.registrationProperties.setEaadhaarSequenceNumber(sequenceNumber);
    }

    @Override
    public void doStartDeregistrationPrerequisites() {
        this.registrationProperties.setClientDereginprogress(DeregInProgressStatus.IN_PROGRESS.toString());
        this.preferenceStore.save();
    }

    @Override
    public void doDeregistration() {
        this.registrationProperties.setClientRegistered(false);
        this.registrationProperties.setClientDeregistered(true);
        this.registrationProperties.setClientDereginprogress(DeregInProgressStatus.NOT_STARTED.toString());
        this.preferenceStore.save();
    }

    @Override
    public void doRegistrationRequested(String regId, String regName, String agencyId, String agencyName, String stationId, long enrolIDSeqNo, TokenEntities tokens, String timestamp, boolean isStep1) throws RegistrationException {
        this.storeEnrolIdSequence(enrolIDSeqNo);
        this.storeTokens(tokens);
        if (this.servSyncDAO.getServerSyncDetails("LAST_REGISTERED") == 0L) {
            this.servSyncDAO.insertServerSyncDetails("LAST_REGISTERED", System.currentTimeMillis());
        } else {
            this.servSyncDAO.updateServerSyncDetails(System.currentTimeMillis(), "LAST_REGISTERED");
        }
        if (this.servSyncDAO.getServerSyncDetails("APPLICATION_VERSION") == 0L && this.servSyncDAO.getVersionValidity() >= 0L) {
            this.servSyncDAO.insertServerSyncDetails("APPLICATION_VERSION", Long.parseLong(ApplicationVersion.VERSION.replace(".", "")));
        }
        if (!isStep1) {
            String secondaryMachineHash;
            this.registrationProperties.setClientRegistered(true);
            this.registrationProperties.setClientDeregistered(false);
            this.registrationProperties.setClientDereginprogress(DeregInProgressStatus.NOT_STARTED.toString());
            this.registrationProperties.setRegistrarId(regId);
            this.registrationProperties.setRegistrarName(regName);
            this.registrationProperties.setAgencyId(agencyId);
            this.registrationProperties.setAgencyName(agencyName);
            this.registrationProperties.setStationId(stationId);
            this.registrationProperties.setSequenceNumber(Long.toString(enrolIDSeqNo));
            EnrolmentInfo enrolmentInfo = new EnrolmentInfo();
            enrolmentInfo.setSequenceNumber(Long.toString(enrolIDSeqNo));
            try {
                this.oucDataStore.setEnrolmentInfo(enrolmentInfo);
            }
            catch (IOException e) {
                LOGGER.info("Failed to connect to Enrol Service Client. Enrolment sequence number was not stored/updated in Enrol Service Client.");
            }
            catch (StationInfoStoreException e) {
                LOGGER.info("Error storing/updating enrolment sequence number in Enrol Service Client", (Object[])e.getStackTrace());
            }
            this.registrationProperties.setClientMachineCode(this.getSystemMachineCode());
            this.registrationProperties.setClientRegTime(timestamp);
            IMachineIdentity machineId = MachineIdentityFactory.getIdentity();
            try {
                secondaryMachineHash = machineId.getSecondaryMachineHash();
            }
            catch (Exception e) {
                LOGGER.error("error getting secondary machine hash", (Throwable)e);
                throw new RegistrationException("Secondary machine hash could not be calculated");
            }
            this.setMachineCodeDetails(machineId.getOEMName(), machineId.getPrimaryMachineHash(), secondaryMachineHash, machineId.getMachineDetails(), machineId.getMachineIdMode());
            this.storeRegistrationInfo(regId, regName, agencyId, agencyName, stationId, this.getSystemMachineCode(), timestamp, machineId.getOEMName(), machineId.getPrimaryMachineHash(), secondaryMachineHash, machineId.getMachineDetails(), machineId.getMachineIdMode());
        }
    }

    private void storeRegistrationInfo(String regId, String regName, String agencyId, String agencyName, String stId, String mcCode, String timestamp, String mcOemName, String mcPrimaryHash, String mcSecondaryHash, String mcDetails, String mcIdMode) throws RegistrationException {
        RegistrationInfo.Id id = new RegistrationInfo.Id();
        id.setRegistrarId(regId);
        id.setAgencyId(agencyId);
        id.setStationId(stId);
        RegistrationInfo.MachineCodeDetails machineCodeDetails = new RegistrationInfo.MachineCodeDetails();
        machineCodeDetails.setRegisteredValue(mcCode);
        machineCodeDetails.setOem(mcOemName);
        machineCodeDetails.setPrimaryMachineHash(mcPrimaryHash);
        machineCodeDetails.setSecondaryMachineHash(mcSecondaryHash);
        machineCodeDetails.setMachineDetails(mcDetails);
        machineCodeDetails.setRegisteredMode(mcIdMode);
        RegistrationInfo.RegistrationDetails regDetails = new RegistrationInfo.RegistrationDetails();
        regDetails.setId(id);
        regDetails.setRegistrarName(regName);
        regDetails.setAgencyName(agencyName);
        regDetails.setTimeStamp(timestamp);
        regDetails.setMachineCodeDetails(machineCodeDetails);
        RegistrationInfo registrationInfo = new RegistrationInfo();
        registrationInfo.setRegistrationDetails(regDetails);
        try {
            this.enrolServiceClientApiService.storeRegistration(registrationInfo);
        }
        catch (IOException e) {
            throw new RegistrationException("Unable store registration info with Aadhaar Enrol Service Client");
        }
        this.preferenceStore.save();
    }

    @Override
    public boolean isAnyOperatorOnboarded() {
        if (this.anyOperatorOnboardedStatusNeedsRefresh) {
            this.anyOperatorOnboarded = this.onboardingService.isAnyOperatorOnboarded();
            this.anyOperatorOnboardedStatusNeedsRefresh = false;
        }
        return this.anyOperatorOnboarded;
    }

    private void storeEnrolIdSequence(long enrolIDSeqNo) throws RegistrationException {
        try {
            this.seqMaster.setSequence("SEQ_ENROL_ID_GEN", enrolIDSeqNo);
        }
        catch (Exception e) {
            LOGGER.error("unable to save sequence", (Throwable)e);
            throw new SequenceStoreException("Could not store Enrol ID Sequence Number " + e.getMessage());
        }
    }

    private void storeTokens(TokenEntities tokens) throws RegistrationException {
        if (tokens == null) {
            LOGGER.info("No Tokens from the server as part of client-station registration.");
            return;
        }
        for (TokenEntity tokenEntity : tokens.getTokenEntity()) {
            in.gov.uidai.ec.ecmpapi.TokenEntity domainTokenEntity = new in.gov.uidai.ec.ecmpapi.TokenEntity();
            domainTokenEntity.setToken(tokenEntity.getToken());
            domainTokenEntity.setTokenAPI(tokenEntity.getTokenAPI());
            try {
                this.tokenManager.store(domainTokenEntity);
            }
            catch (Exception e) {
                LOGGER.error("Error while storing tokens.", (Throwable)e);
                throw new TokenAPIStoreException("Error while storing tokens. " + e.getMessage());
            }
        }
    }

    @Override
    public void startDeRegistration() throws StartDeRegistrationException, IOException {
        this.enrolServiceClientApiService.startDeRegistration();
    }

    @Override
    public void completeDeRegistration() throws CompleteDeRegistrationException, IOException {
        this.enrolServiceClientApiService.completeDeRegistration();
    }
}

