/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.registration;

import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.service.registration.ISequenceMasterDAO;
import java.util.HashMap;
import java.util.Properties;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SequenceMasterDAO
implements ISequenceMasterDAO,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SequenceMasterDAO.class);
    private Properties seqRollover;
    private String location;
    private SqlSession session;

    public void setSqlSession(SqlSession session) {
        this.session = session;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public Long getNextValue(String seqName) {
        LOGGER.debug("get next value from seq: " + seqName);
        Long value = this.getSequence(seqName);
        if (value == null) {
            this.createSequence(seqName);
            value = 0L;
        }
        value = value + 1L;
        if (this.seqRollover.containsKey(seqName)) {
            long maxValue = Long.parseLong(this.seqRollover.getProperty(seqName));
            if (value > maxValue) {
                value = 1L;
            }
        }
        this.updateSequence(seqName, value);
        LOGGER.debug("value got from seq: " + value);
        return value;
    }

    @Override
    public void setSequence(String seqName, long value) {
        this.updateSequence(seqName, value);
    }

    public void afterPropertiesSet() throws Exception {
        this.seqRollover = new Properties();
        this.seqRollover.load(this.getClass().getClassLoader().getResourceAsStream(this.location));
    }

    @Override
    public Long getSequence(String seqName) {
        Long value = null;
        try {
            value = (Long)this.session.selectOne("getSeqValue", (Object)seqName);
        }
        catch (Exception e) {
            LOGGER.error("Error in getSequence", (Throwable)e);
        }
        return value;
    }

    private void createSequence(String seqName) {
        HashMap<String, Object> sequence = new HashMap<String, Object>();
        try {
            sequence.put("seqId", seqName);
            sequence.put("seqValue", 0L);
            this.session.update("createSequence", sequence);
        }
        catch (Exception e) {
            LOGGER.error("Error in createSequence", (Throwable)e);
        }
    }

    private void updateSequence(String seqName, long value) {
        HashMap<String, Object> sequence = new HashMap<String, Object>();
        try {
            Long initialValue = this.getSequence(seqName);
            if (initialValue == null) {
                this.createSequence(seqName);
            }
            sequence.put("seqId", seqName);
            sequence.put("seqValue", value);
            this.session.update("setSeqValue", sequence);
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:internal", (Throwable)e);
        }
    }
}

