/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.report;

import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.icas.text.CSVWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvReportWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvReportWriter.class);
    private final CSVWriter writer = new CSVWriter();

    public CsvReportWriter(String fileName, String fieldNamePropertyFile) {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("conf/csvheader/" + fieldNamePropertyFile);
            List fieldColumn = IOUtils.readLines((InputStream)Objects.requireNonNull(is));
            this.writer.init((OutputStream)new FileOutputStream(fileName), fieldColumn);
        }
        catch (IOException e) {
            throw new ClientException("domain.internal", (Throwable)e);
        }
    }

    public <T> void storeData(List<T> detailsList) {
        try {
            this.writer.writeHeader();
            this.generateContents(detailsList);
            this.writer.close();
        }
        catch (Exception e) {
            throw new ClientException("domain.internal", (Throwable)e);
        }
    }

    private <T> void generateContents(List<T> detailsList) {
        if (detailsList.isEmpty()) {
            return;
        }
        detailsList.stream().filter(Objects::nonNull).forEach(detailsRecord -> {
            try {
                this.writer.writeNext(detailsRecord);
            }
            catch (Exception e) {
                LOGGER.error("Error generating contents", (Throwable)e);
            }
        });
    }
}

