/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.report;

import in.gov.uidai.ec.escapi.EnrolServiceClientApiService;
import in.gov.uidai.ec.escapi.enrollmentdetails.EnrollmentDetailsResponse;
import in.gov.uidai.ec.escapi.packet.metadata.MetaDataDateFormats;
import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.service.packet.EidSearchType;
import in.gov.uidai.ec.service.packet.EnrolSummary;
import in.gov.uidai.ec.service.packet.IPacketService;
import in.gov.uidai.ec.service.packet.PacketCombinedSummary;
import in.gov.uidai.ec.service.packet.PacketStatus;
import in.gov.uidai.ec.service.packet.PacketStatusType;
import in.gov.uidai.ec.service.packet.PacketSummary;
import in.gov.uidai.ec.service.packet.PacketType;
import in.gov.uidai.ec.service.packet.PacketVerifyType;
import in.gov.uidai.ec.service.packet.UenrolSummary;
import in.gov.uidai.ec.service.report.IEodReportSearch;
import in.gov.uidai.ec.service.report.ReportSummary;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EodReportSearch
implements IEodReportSearch {
    @Autowired
    private EnrolServiceClientApiService enrolServiceClientApiService;
    private static final Logger LOGGER = LoggerFactory.getLogger(EodReportSearch.class);
    private IPacketService packetService;

    public void setPacketService(IPacketService packetService) {
        this.packetService = packetService;
    }

    @Override
    public List<ReportSummary> getEnrolSummaryBtw(Date fromDate, Date toDate) {
        List<Object> enrollmentDetails = new ArrayList<EnrollmentDetailsResponse>();
        try {
            LOGGER.debug("In get method of EodReportSearch :From Date is " + fromDate + " and To Date is " + toDate);
            SimpleDateFormat sdf = new SimpleDateFormat(MetaDataDateFormats.RFC_3339_DATE_FORMAT.getFormat());
            String searchKey = "CreationDate";
            ArrayList<String> searchValues = new ArrayList<String>(Collections.EMPTY_LIST);
            searchValues.add(sdf.format(fromDate));
            searchValues.add(sdf.format(toDate));
            enrollmentDetails = this.enrolServiceClientApiService.fetchEnrollmentDetails(searchKey, searchValues);
        }
        catch (IOException e) {
            LOGGER.error("Failed to fetch enrollment details", (Throwable)e);
        }
        return this.getReportSummaryFromPacket(enrollmentDetails);
    }

    @Override
    public List<ReportSummary> getEnrolBESummaryBtw(Date fromDate, Date toDate) {
        List<Object> enrollmentDetails = new ArrayList();
        try {
            LOGGER.debug("In get method of EodReportSearch :From Date is " + fromDate + " and To Date is " + toDate);
            SimpleDateFormat sdf = new SimpleDateFormat(MetaDataDateFormats.RFC_3339_DATE_FORMAT.getFormat());
            String searchKey = "CreationDate";
            ArrayList<String> searchValues = new ArrayList<String>(Collections.EMPTY_LIST);
            searchValues.add(sdf.format(fromDate));
            searchValues.add(sdf.format(toDate));
            enrollmentDetails = this.enrolServiceClientApiService.fetchEnrollmentDetails(searchKey, searchValues);
        }
        catch (IOException e2) {
            LOGGER.error("Failed to fetch enrollment details", (Throwable)e2);
        }
        enrollmentDetails = enrollmentDetails.stream().filter(e -> e.getBiometricException().matches("(.)*0(.)*")).collect(Collectors.toList());
        return this.getReportSummaryFromPacket(enrollmentDetails);
    }

    @Override
    public List<ReportSummary> getIntegrityFailedSummary(long fromDate, long toDate, boolean reEnroledStatus) {
        LOGGER.debug("In get method of EodReportSearch for today");
        EidSearchType eidSearchType = reEnroledStatus ? EidSearchType.INTEGRITY_FAILED_IDREENROLED_FOR_PERIOD : EidSearchType.INTEGRITY_FAILED_FOR_PERIOD;
        List<String> enrolIdList = this.packetService.getEidListByPeriod(eidSearchType, fromDate, toDate);
        ArrayList<ReportSummary> reportSummaryData = new ArrayList<ReportSummary>();
        try {
            for (String enrolId : enrolIdList) {
                ReportSummary summary = new ReportSummary();
                PacketSummary packetSummary = this.packetService.getPacketSummary(enrolId);
                summary.setEnrolId(enrolId);
                if (PacketStatusType.PKTINTG_FAILED.toIntValue() == packetSummary.getStatus()) {
                    summary.setStatus(this.packetService.getPacketIntegrityFailedStatusType(enrolId));
                } else {
                    summary.setStatus(summary.getStatus());
                }
                summary.setType(PacketType.fromIntValue(packetSummary.getPktType()));
                summary.setResidentName(packetSummary.getResidentName());
                summary.setMobile(packetSummary.getMobile());
                String address = this.residentAddress(packetSummary);
                summary.setAddress(address);
                summary.setIntroducerStatus(PacketStatusType.fromIntValue(packetSummary.getIntroStatus()));
                summary.setReviewerStatus(PacketStatusType.fromIntValue(packetSummary.getReviewerStatus()));
                reportSummaryData.add(summary);
            }
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:report", (Throwable)e);
        }
        return reportSummaryData;
    }

    @Override
    public void updateReEnrolledStatusPktStatus(String enrolId) {
        this.packetService.updateReEnrolledStatusPktStatus(enrolId);
    }

    @Override
    public EnrolSummary getBioException(String enrolId) {
        return this.packetService.getNewEnrolSummary(enrolId);
    }

    @Override
    public UenrolSummary getBioExceptionForEnrolment(String enrolId) {
        return this.packetService.getUpdateEnrolSummary(enrolId);
    }

    @Override
    public int getCountOfEnrolmentsAsOn(String date) {
        return this.packetService.getCountOfEnrolmentsAsOn(date);
    }

    @Override
    public int getUnUploadedPacketsCount() {
        return this.packetService.getUnUploadedPacketCount();
    }

    @Override
    public long getDaysOfOldestUnUploadedPacket() {
        long currentTime;
        List<String> unUploadPacket = this.packetService.getUnUploadedPackets();
        long oldestPacketDate = currentTime = System.currentTimeMillis();
        long days = 0L;
        if (unUploadPacket != null && unUploadPacket.size() > 0) {
            for (String eid : unUploadPacket) {
                String timeInPacket = eid.substring(14);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
                try {
                    long timeFromPacket = sdf.parse(timeInPacket).getTime();
                    if (timeFromPacket >= oldestPacketDate) continue;
                    oldestPacketDate = timeFromPacket;
                    days = TimeUnit.MILLISECONDS.toDays(currentTime - timeFromPacket);
                }
                catch (Exception e) {
                    LOGGER.debug("Exception while parsing " + e);
                }
            }
        }
        return days;
    }

    private List<ReportSummary> getEnrolReportSummary(List<String> enrolIdList) {
        ArrayList<ReportSummary> reportSummaryData = new ArrayList<ReportSummary>();
        try {
            for (String enrolId : enrolIdList) {
                PacketCombinedSummary pcs = this.packetService.getCombinedSummary(enrolId);
                ReportSummary summary = this.getReportSummaryFromPacket(pcs);
                reportSummaryData.add(summary);
            }
        }
        catch (Exception e) {
            throw new ClientException("domain-errors:report", (Throwable)e);
        }
        return reportSummaryData;
    }

    private List<ReportSummary> getReportSummaryFromPacket(List<EnrollmentDetailsResponse> enrollDetails) {
        ArrayList<ReportSummary> reportSummaryData = new ArrayList<ReportSummary>();
        for (EnrollmentDetailsResponse enrolDetail : enrollDetails) {
            ReportSummary summary = new ReportSummary();
            summary.setEnrolId(enrolDetail.getEid());
            summary.setStatus(PacketStatusType.forValue(enrolDetail.getStatus()));
            summary.setVerifierName(enrolDetail.getIntroducerName());
            summary.setVerifierId(enrolDetail.getIntroducerId());
            summary.setType(PacketType.fromEnrolFlagValue(enrolDetail.getPacketType()));
            summary.setOperatorId(enrolDetail.getOperatorId());
            summary.setOperatorName(enrolDetail.getOperatorName());
            summary.setVerifyType(PacketVerifyType.valueOf((String)enrolDetail.getPacketVerifyType()));
            if (summary.getType().equals((Object)PacketType.NEW)) {
                summary.setAmountChargedForNewEnrolment(Float.parseFloat(enrolDetail.getAmount()));
            } else if (summary.getType().equals((Object)PacketType.UPDATE)) {
                summary.setAmountChargedForUpdateEnrolment(Float.parseFloat(enrolDetail.getAmount()));
            } else if (summary.getType().equals((Object)PacketType.DOCUPDATE)) {
                summary.setAmountChargedForUpdateEnrolment(Float.parseFloat(enrolDetail.getAmount()));
            }
            summary.setCreationDate(enrolDetail.getCreationDate().getTime());
            summary.setResidentName(enrolDetail.getResidentName());
            summary.setGstApplied(Float.parseFloat(enrolDetail.getGSTCharged()));
            summary.setTotalAmountCharged(Float.parseFloat(enrolDetail.getTotalAmountCharged()));
            summary.setOnlyMandatoryBiometricUpdate(enrolDetail.getIsBiometricsMandatory() != false ? "Yes" : "No");
            summary.setAppointmentId(enrolDetail.getAppointmentId());
            summary.setIsPacketSkipped(String.valueOf(enrolDetail.getIsPacketSkipped()));
            summary.setProcessingStateDesc(enrolDetail.getProcessingStateDesc());
            summary.setRejectReasonDesc(enrolDetail.getRejectReasonDesc());
            summary.setIsNRI(String.valueOf(enrolDetail.getIsNRI()));
            String bioexception = enrolDetail.getBiometricException();
            if (bioexception != null) {
                summary.setMissingIrisCount(this.getMissingIrisCount(bioexception));
                summary.setMissingFingerCount(this.getMissingFingerCount(bioexception));
                summary.setSupervisorId(enrolDetail.getSupervisorId());
            }
            reportSummaryData.add(summary);
        }
        return reportSummaryData;
    }

    private ReportSummary getReportSummaryFromPacket(PacketCombinedSummary pcs) {
        ReportSummary summary = new ReportSummary();
        summary.setCreationDate(pcs.getCreationDate());
        summary.setEnrolId(pcs.getEnrolId());
        summary.setStatus(pcs.getPacketStatusType());
        PacketStatus packetStatus = pcs.getLatestPacketStatus();
        if (packetStatus != null) {
            summary.setModerator(packetStatus.getActorName());
        }
        summary.setType(pcs.getPacketType());
        summary.setTinNo(pcs.getTinNum());
        summary.setOperatorId(pcs.getOpId());
        summary.setReviewerId(pcs.getReviewerId());
        if (summary.getType().equals((Object)PacketType.NEW)) {
            summary.setAmountChargedForNewEnrolment(pcs.getAmountCharged());
        } else if (summary.getType().equals((Object)PacketType.UPDATE)) {
            summary.setAmountChargedForUpdateEnrolment(pcs.getAmountCharged());
            summary.setuId(pcs.getPreviousUid());
        } else if (summary.getType().equals((Object)PacketType.DOCUPDATE)) {
            summary.setAmountChargedForUpdateEnrolment(pcs.getAmountCharged());
            summary.setuId(pcs.getPreviousUid());
        }
        summary.setVerifyType(pcs.getVerifyType());
        summary.setVerifierName(pcs.getVerifierName());
        summary.setVerifierId(pcs.getVerifierId());
        summary.setResidentName(pcs.getResidentName());
        summary.setMobile(pcs.getMobile());
        summary.setAddress(this.prepareResidentAddress(pcs.getPacketSummary()));
        summary.setIntroducerStatus(pcs.getIntroStatus());
        summary.setReviewerStatus(pcs.getReviewerStatus());
        summary.setGstApplied(pcs.getGstApplied());
        summary.setTotalAmountCharged(pcs.getTotalAmountCharged());
        summary.setOnlyMandatoryBiometricUpdate(pcs.getOnlyMandatoryBiometricUpdate());
        summary.setAppointmentId(pcs.getAppointmentId());
        summary.setIsPacketSkipped(pcs.isPacketSkipped());
        summary.setProcessingStateDesc(pcs.getProcessingStateDesc());
        summary.setRejectReasonDesc(pcs.getRejectReasonDesc());
        summary.setIsNRI(pcs.getIsNRI());
        String bioexception = pcs.getBioException();
        if (bioexception != null) {
            summary.setMissingIrisCount(pcs.getMissingIrisCount());
            summary.setMissingFingerCount(pcs.getMissingFingerCount());
            summary.setSupervisorId(pcs.getSupervisorId());
        }
        return summary;
    }

    public int getMissingIrisCount(String bioexception) {
        int missingIrisCount = 0;
        if (bioexception != null && bioexception.length() >= 2) {
            char needle = '0';
            for (int i = 0; i <= 1; ++i) {
                if (bioexception.charAt(i) != needle) continue;
                ++missingIrisCount;
            }
        }
        return missingIrisCount;
    }

    public int getMissingFingerCount(String bioexception) {
        int missingFingerCount = 0;
        if (bioexception != null) {
            for (int i = 2; i < bioexception.length(); ++i) {
                char needle = '0';
                if (bioexception.charAt(i) != needle) continue;
                ++missingFingerCount;
            }
        }
        return missingFingerCount;
    }

    private String prepareResidentAddress(PacketSummary packetSummary) {
        StringBuilder addressBuilder = new StringBuilder();
        if (packetSummary.getAddrPincode() != null) {
            addressBuilder.append(packetSummary.getAddrPincode());
            addressBuilder.append(", ");
        }
        if (packetSummary.getAddrCountry() != null) {
            addressBuilder.append(packetSummary.getAddrCountry());
            addressBuilder.append(", ");
        }
        if (packetSummary.getAddrState() != null) {
            addressBuilder.append(packetSummary.getAddrState());
            addressBuilder.append(", ");
        }
        if (packetSummary.getAddrDistrict() != null) {
            addressBuilder.append(packetSummary.getAddrDistrict());
            addressBuilder.append(", ");
        }
        if (packetSummary.getAddrSubdistrict() != null) {
            addressBuilder.append(packetSummary.getAddrSubdistrict());
            addressBuilder.append(", ");
        }
        if (packetSummary.getAddrVtc() != null) {
            addressBuilder.append(packetSummary.getAddrVtc());
            addressBuilder.append(", ");
        }
        if (packetSummary.getAddrLocality() != null) {
            addressBuilder.append(packetSummary.getAddrLocality());
            addressBuilder.append(", ");
        }
        if (packetSummary.getAddrLandmark() != null) {
            addressBuilder.append(packetSummary.getAddrLandmark());
            addressBuilder.append(", ");
        }
        if (packetSummary.getAddrBuilding() != null) {
            addressBuilder.append(packetSummary.getAddrBuilding());
        }
        return addressBuilder.toString();
    }

    private String residentAddress(PacketSummary packetSummary) {
        String address;
        StringBuilder addressBuilder = new StringBuilder();
        if (packetSummary.getAddrBuilding() != null) {
            addressBuilder.append(packetSummary.getAddrBuilding());
            addressBuilder.append(", ");
        }
        if (packetSummary.getAddrLandmark() != null) {
            addressBuilder.append(packetSummary.getAddrLandmark());
            addressBuilder.append(", ");
        }
        if (packetSummary.getAddrLocality() != null) {
            addressBuilder.append(packetSummary.getAddrLocality());
            addressBuilder.append(", ");
        }
        if (packetSummary.getAddrVtc() != null) {
            addressBuilder.append(packetSummary.getAddrVtc());
            addressBuilder.append(", ");
        }
        if (packetSummary.getAddrSubdistrict() != null) {
            addressBuilder.append(packetSummary.getAddrSubdistrict());
            addressBuilder.append(", ");
        }
        if (packetSummary.getAddrDistrict() != null) {
            addressBuilder.append(packetSummary.getAddrDistrict());
            addressBuilder.append(", ");
        }
        if (packetSummary.getAddrState() != null) {
            addressBuilder.append(packetSummary.getAddrState());
            addressBuilder.append(", ");
        }
        if (packetSummary.getAddrPincode() != null) {
            addressBuilder.append(packetSummary.getAddrPincode());
        }
        if (!StringUtils.isBlank((String)(address = addressBuilder.toString()))) {
            return address;
        }
        return "Not Available";
    }
}

