/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.report;

import in.gov.uidai.ec.service.enrol.ECMPDateFormatHelper;
import in.gov.uidai.ec.service.enrol.ECMPDateFormats;
import in.gov.uidai.ec.service.findaadhaar.FindAadhaarAttempt;
import in.gov.uidai.ec.service.findaadhaar.IFindAadhaarDao;
import in.gov.uidai.ec.service.packet.EnrolSummary;
import in.gov.uidai.ec.service.packet.PacketType;
import in.gov.uidai.ec.service.packet.PacketVerifyType;
import in.gov.uidai.ec.service.packet.UenrolSummary;
import in.gov.uidai.ec.service.presync.IServerSyncDAO;
import in.gov.uidai.ec.service.report.DatewiseSummary;
import in.gov.uidai.ec.service.report.EODDetailsSummary;
import in.gov.uidai.ec.service.report.EODReportData;
import in.gov.uidai.ec.service.report.HoldRejectDetailsSummary;
import in.gov.uidai.ec.service.report.HoldRejectReportData;
import in.gov.uidai.ec.service.report.IEodReportSearch;
import in.gov.uidai.ec.service.report.IReportDAO;
import in.gov.uidai.ec.service.report.OperatorBeSummaryReport;
import in.gov.uidai.ec.service.report.PrintAadhaarDateWiseSummary;
import in.gov.uidai.ec.service.report.ReportSummary;
import in.gov.uidai.ec.service.report.SupervisorBeSummaryReport;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportDAO
implements IReportDAO {
    private final long reportDate;
    private final EODReportData eodReport = new EODReportData();
    private final HoldRejectReportData holdRejectReport = new HoldRejectReportData();
    private IEodReportSearch eodReportSearch;
    private IServerSyncDAO servSyncDAO;
    private IFindAadhaarDao findAadhaarDao;

    public ReportDAO() {
        this.reportDate = System.currentTimeMillis();
    }

    public void setEodReportSearch(IEodReportSearch eodReportSearch) {
        this.eodReportSearch = eodReportSearch;
    }

    public final void setServSyncDAO(IServerSyncDAO servSyncDAO) {
        this.servSyncDAO = servSyncDAO;
    }

    public final void setFindAadhaarAttemptsDao(IFindAadhaarDao dao) {
        this.findAadhaarDao = dao;
    }

    @Override
    public EODReportData loadEODReport(java.util.Date fromDate, java.util.Date toDate) {
        this.eodReport.setReportDate(this.reportDate);
        long lastRegisteredDate = this.servSyncDAO.getServerSyncDetails("LAST_REGISTERED");
        long lastSyncDate = this.servSyncDAO.getServerSyncDetails("LAST_SYNC");
        this.eodReport.setLastRegisteredDate(lastRegisteredDate);
        this.eodReport.setLastSyncDate(lastSyncDate);
        List<ReportSummary> detailsSummaryList = this.eodReportSearch.getEnrolSummaryBtw(fromDate, toDate);
        if (detailsSummaryList != null) {
            this.populateDatewiseSummary(this.eodReport, detailsSummaryList);
            this.populateDetailsSummary(this.eodReport, detailsSummaryList);
        }
        return this.eodReport;
    }

    @Override
    public EnrolSummary getBioException(String enrolId) {
        return this.eodReportSearch.getBioException(enrolId);
    }

    @Override
    public UenrolSummary getBioExceptionForEnrolment(String enrolId) {
        return this.eodReportSearch.getBioExceptionForEnrolment(enrolId);
    }

    @Override
    public List<FindAadhaarAttempt> getPrintAadhaarReportData(long fromTime, long toTime) {
        return this.findAadhaarDao.getAttempts(fromTime, toTime);
    }

    @Override
    public List<PrintAadhaarDateWiseSummary> getPrintAadhaarDateWiseSummary() {
        Map<Date, HashMap<String, Object>> dateWiseAttemptSummary = this.findAadhaarDao.getDateWiseAttemptSummary();
        ArrayList<PrintAadhaarDateWiseSummary> printAadhaarDateWiseSummaries = new ArrayList<PrintAadhaarDateWiseSummary>();
        if (dateWiseAttemptSummary != null) {
            int i = 1;
            for (Map.Entry<Date, HashMap<String, Object>> entry : dateWiseAttemptSummary.entrySet()) {
                Date d = entry.getKey();
                HashMap<String, Object> c = entry.getValue();
                printAadhaarDateWiseSummaries.add(new PrintAadhaarDateWiseSummary(i++, d, (Integer)c.get("count")));
            }
            return printAadhaarDateWiseSummaries;
        }
        return printAadhaarDateWiseSummaries;
    }

    @Override
    public EODReportData loadBEEODReport(java.util.Date fromDate, java.util.Date toDate, String userId) {
        this.eodReport.setReportDate(this.reportDate);
        long lastRegisteredDate = this.servSyncDAO.getServerSyncDetails("LAST_REGISTERED");
        long lastSyncDate = this.servSyncDAO.getServerSyncDetails("LAST_SYNC");
        this.eodReport.setLastRegisteredDate(lastRegisteredDate);
        this.eodReport.setLastSyncDate(lastSyncDate);
        List<ReportSummary> detailsSummaryList = this.eodReportSearch.getEnrolBESummaryBtw(fromDate, toDate);
        if (detailsSummaryList != null) {
            this.populateDatewiseBESummary(this.eodReport, detailsSummaryList);
            this.populateDetailsBESummary(this.eodReport, detailsSummaryList);
        }
        return this.eodReport;
    }

    @Override
    public EODReportData loadBEEODReportSummary(java.util.Date fromDate, java.util.Date toDate, List<SupervisorBeSummaryReport> userIdList) {
        this.eodReport.setReportDate(this.reportDate);
        long lastRegisteredDate = this.servSyncDAO.getServerSyncDetails("LAST_REGISTERED");
        long lastSyncDate = this.servSyncDAO.getServerSyncDetails("LAST_SYNC");
        this.eodReport.setLastRegisteredDate(lastRegisteredDate);
        this.eodReport.setLastSyncDate(lastSyncDate);
        List<ReportSummary> detailsSummaryList = this.eodReportSearch.getEnrolBESummaryBtw(fromDate, toDate);
        List<ReportSummary> detailsTotSummaryList = this.eodReportSearch.getEnrolSummaryBtw(fromDate, toDate);
        if (detailsSummaryList != null) {
            this.populateDatewiseBESummary(this.eodReport, detailsSummaryList);
            this.populateDetailsBESummary(this.eodReport, detailsSummaryList);
            this.populateBESummaryForOperator(this.eodReport, detailsSummaryList, detailsTotSummaryList);
            this.populateBESummaryForSupervisor(this.eodReport, detailsSummaryList, userIdList);
        }
        return this.eodReport;
    }

    @Override
    public HoldRejectReportData loadIntegrityFailedReport(long fromDate, long toDate, boolean reEnrolledStatus) {
        List<ReportSummary> packetSummaryForToday = this.eodReportSearch.getIntegrityFailedSummary(fromDate, toDate, reEnrolledStatus);
        if (packetSummaryForToday != null) {
            this.populateIntegrityFailedSummary(this.holdRejectReport, packetSummaryForToday);
        }
        return this.holdRejectReport;
    }

    @Override
    public void updateReEnrolledStatusPktStatus(String enrolId) {
        this.eodReportSearch.updateReEnrolledStatusPktStatus(enrolId);
    }

    private void populateDetailsSummary(EODReportData report, List<ReportSummary> detailsSummaryList) {
        ArrayList<EODDetailsSummary> detailsList = new ArrayList<EODDetailsSummary>();
        int serialNum = 1;
        for (ReportSummary summary : detailsSummaryList) {
            EODDetailsSummary detailsSummary = new EODDetailsSummary();
            detailsSummary.setSerialNum(serialNum);
            detailsSummary.setEnrolIdDate(summary.getEnrolId());
            if (summary.getType().equals((Object)PacketType.NEW)) {
                detailsSummary.setType("E");
                detailsSummary.setAmountChargedForNewEnrolment(summary.getAmountChargedForNewEnrolment());
            } else if (summary.getType().equals((Object)PacketType.UPDATE)) {
                detailsSummary.setType("U");
                detailsSummary.setPreUId(summary.getuId());
                detailsSummary.setAmountChargedForUpdateEnrolment(summary.getAmountChargedForUpdateEnrolment());
            } else if (summary.getType().equals((Object)PacketType.DOCUPDATE)) {
                detailsSummary.setType("DU");
                detailsSummary.setPreUId(summary.getuId());
                detailsSummary.setAmountChargedForUpdateEnrolment(summary.getAmountChargedForUpdateEnrolment());
            }
            detailsSummary.setNprNum(summary.getTinNo());
            detailsSummary.setOpId(summary.getOperatorId());
            detailsSummary.setReviewerId(summary.getReviewerId());
            this.updateReviewerDetails(summary, detailsSummary);
            detailsSummary.setGstApplied(summary.getGstApplied());
            detailsSummary.setTotalAmountCharged(summary.getTotalAmountCharged());
            detailsSummary.setOnlyMandatoryBiometricUpdate(summary.getOnlyMandatoryBiometricUpdate());
            detailsSummary.setAppointmentId(summary.getAppointmentId());
            detailsSummary.setIsNRI(summary.getIsNRI());
            detailsSummary.setIsPacketSkipped(summary.getIsPacketSkipped());
            String processingStateDesc = summary.getProcessingStateDesc();
            detailsSummary.setProcessingStateDesc(processingStateDesc);
            detailsSummary.setRejectReasonDesc(summary.getRejectReasonDesc());
            ++serialNum;
            detailsList.add(detailsSummary);
        }
        report.setDetailsSummary(detailsList);
    }

    private void populateDatewiseSummary(EODReportData report, List<ReportSummary> detailsSummaryList) {
        ArrayList<DatewiseSummary> datewiseList = new ArrayList<DatewiseSummary>();
        ArrayList<String> creationDates = new ArrayList<String>();
        int serialNum = 1;
        for (ReportSummary packet : detailsSummaryList) {
            int enrolCount = 0;
            int updateCount = 0;
            Date creationDate = new Date(packet.getCreationDate());
            String creationDateStr = ECMPDateFormatHelper.getDateStr(creationDate, ECMPDateFormats.STANDARD_DATE_FORMAT);
            if (creationDates.contains(creationDateStr)) continue;
            creationDates.add(creationDateStr);
            for (ReportSummary summary : detailsSummaryList) {
                Date createDate = new Date(summary.getCreationDate());
                String createDateStr = ECMPDateFormatHelper.getDateStr(createDate, ECMPDateFormats.STANDARD_DATE_FORMAT);
                if (!createDateStr.equals(creationDateStr)) continue;
                if (summary.getType().equals((Object)PacketType.NEW)) {
                    ++enrolCount;
                    continue;
                }
                if (!summary.getType().equals((Object)PacketType.UPDATE) && !summary.getType().equals((Object)PacketType.DOCUPDATE)) continue;
                ++updateCount;
            }
            int totalCount = enrolCount + updateCount;
            DatewiseSummary datewiseSummary = new DatewiseSummary();
            datewiseSummary.setSerialNum(serialNum);
            datewiseSummary.setEnrolmentDate(creationDateStr);
            datewiseSummary.setEnrolCount(enrolCount);
            datewiseSummary.setUpdateCount(updateCount);
            datewiseSummary.setTotalCount(totalCount);
            datewiseList.add(datewiseSummary);
            ++serialNum;
        }
        report.setDatewiseSummary(datewiseList);
    }

    private void populateDetailsBESummary(EODReportData report, List<ReportSummary> detailsSummaryList) {
        ArrayList<EODDetailsSummary> detailsList = new ArrayList<EODDetailsSummary>();
        int serialNum = 1;
        for (ReportSummary summary : detailsSummaryList) {
            EODDetailsSummary detailsSummary = new EODDetailsSummary();
            detailsSummary.setSerialNum(serialNum);
            detailsSummary.setEnrolIdDate(summary.getEnrolId());
            detailsSummary.setMissingIrisCount(summary.getMissingIrisCount());
            detailsSummary.setMissingFingerCount(summary.getMissingFingerCount());
            if (summary.getType().equals((Object)PacketType.NEW)) {
                detailsSummary.setType("E");
            } else if (summary.getType().equals((Object)PacketType.UPDATE)) {
                detailsSummary.setType("U");
                detailsSummary.setPreUId(summary.getuId());
            } else if (summary.getType().equals((Object)PacketType.DOCUPDATE)) {
                detailsSummary.setType("DU");
                detailsSummary.setPreUId(summary.getuId());
            }
            detailsSummary.setNprNum(summary.getTinNo());
            detailsSummary.setOpId(summary.getOperatorId());
            detailsSummary.setReviewerId(summary.getReviewerId());
            detailsSummary.setSupervisorId(summary.getSupervisorId());
            this.updateReviewerDetails(summary, detailsSummary);
            detailsList.add(detailsSummary);
            ++serialNum;
        }
        report.setDetailsSummary(detailsList);
    }

    private void updateReviewerDetails(ReportSummary summary, EODDetailsSummary detailsSummary) {
        if (summary.getVerifyType().equals((Object)PacketVerifyType.INTRODUCER)) {
            detailsSummary.setIntroducer(summary.getVerifierId() + "\n(" + summary.getVerifierName() + ")");
            detailsSummary.setProof("I");
            detailsSummary.setIntroRevStat(summary.getIntroducerStatus());
        } else if (summary.getVerifyType().equals((Object)PacketVerifyType.HOF)) {
            detailsSummary.setProof("HF");
            detailsSummary.setIntroRevStat(null);
        } else {
            detailsSummary.setProof("D");
            detailsSummary.setIntroRevStat(null);
        }
        detailsSummary.setResidentName(summary.getResidentName());
        detailsSummary.setStatus(summary.getStatus());
        detailsSummary.setUserRevStat(summary.getReviewerStatus());
    }

    private void populateDatewiseBESummary(EODReportData report, List<ReportSummary> detailsSummryList) {
        ArrayList<DatewiseSummary> datewiseList = new ArrayList<DatewiseSummary>();
        ArrayList<String> creationDates = new ArrayList<String>();
        int serialNum = 1;
        for (ReportSummary packet : detailsSummryList) {
            int enrolCount = 0;
            int updateCount = 0;
            int missingFingers = 0;
            int missingIris = 0;
            Date creationDate = new Date(packet.getCreationDate());
            String creationDateStr = ECMPDateFormatHelper.getDateStr(creationDate, ECMPDateFormats.STANDARD_DATE_FORMAT);
            if (creationDates.contains(creationDateStr)) continue;
            creationDates.add(creationDateStr);
            for (ReportSummary summary : detailsSummryList) {
                Date createDate = new Date(summary.getCreationDate());
                String createDateStr = ECMPDateFormatHelper.getDateStr(createDate, ECMPDateFormats.STANDARD_DATE_FORMAT);
                if (!createDateStr.equals(creationDateStr)) continue;
                if (summary.getMissingFingerCount() != 0) {
                    ++missingFingers;
                }
                if (summary.getMissingIrisCount() != 0) {
                    ++missingIris;
                }
                if (summary.getType().equals((Object)PacketType.NEW)) {
                    ++enrolCount;
                    continue;
                }
                if (!summary.getType().equals((Object)PacketType.UPDATE) && !summary.getType().equals((Object)PacketType.DOCUPDATE)) continue;
                ++updateCount;
            }
            int totalCount = enrolCount + updateCount;
            DatewiseSummary datewiseSummary = new DatewiseSummary();
            datewiseSummary.setMissingFingerCount(missingFingers);
            datewiseSummary.setMissingIrisCount(missingIris);
            datewiseSummary.setSerialNum(serialNum);
            datewiseSummary.setEnrolmentDate(creationDateStr);
            datewiseSummary.setEnrolCount(enrolCount);
            datewiseSummary.setUpdateCount(updateCount);
            datewiseSummary.setTotalCount(totalCount);
            datewiseList.add(datewiseSummary);
            ++serialNum;
        }
        report.setDatewiseSummary(datewiseList);
    }

    private void populateBESummaryForOperator(EODReportData report, List<ReportSummary> detailsSummaryList, List<ReportSummary> detailsTotSummaryList) {
        ArrayList<OperatorBeSummaryReport> operatorBeSummaryReport = new ArrayList<OperatorBeSummaryReport>();
        for (ReportSummary eachPacket : detailsSummaryList) {
            String operatorId = eachPacket.getOperatorId();
            if (operatorId.isEmpty()) continue;
            boolean operatorFound = false;
            for (OperatorBeSummaryReport item : operatorBeSummaryReport) {
                if (!operatorId.equalsIgnoreCase(item.getOperatorId())) continue;
                item.setBeCount(item.getBeCount() + 1);
                operatorFound = true;
            }
            if (operatorFound) continue;
            OperatorBeSummaryReport newReportItem = new OperatorBeSummaryReport();
            newReportItem.setOperatorId(operatorId);
            newReportItem.setBeCount(1);
            newReportItem.setOperatorName(eachPacket.getOperatorName());
            newReportItem.setToatlCount(0);
            for (ReportSummary eachPacketTot : detailsTotSummaryList) {
                if (!operatorId.equalsIgnoreCase(eachPacketTot.getOperatorId())) continue;
                newReportItem.setToatlCount(newReportItem.getToatlCount() + 1);
            }
            operatorBeSummaryReport.add(newReportItem);
        }
        report.setOperatorBeSummaryReport(operatorBeSummaryReport);
    }

    private void populateBESummaryForSupervisor(EODReportData report, List<ReportSummary> detailsSummaryList, List<SupervisorBeSummaryReport> userIdList) {
        ArrayList<SupervisorBeSummaryReport> supervisorBeSummaryReport = new ArrayList<SupervisorBeSummaryReport>();
        for (ReportSummary eachPacket : detailsSummaryList) {
            String supervisorId = eachPacket.getReviewerId();
            String status = eachPacket.getStatus().toString();
            boolean supervisorFound = false;
            if (supervisorId == null) continue;
            for (SupervisorBeSummaryReport item : supervisorBeSummaryReport) {
                if (!supervisorId.equalsIgnoreCase(item.getSupervisorId())) continue;
                if (status.equalsIgnoreCase("APPROVED")) {
                    item.setApprovedCount(item.getApprovedCount() + 1);
                }
                if (status.equalsIgnoreCase("REJECTED") || status.equalsIgnoreCase("AUTO_REJECTED")) {
                    item.setRejectCount(item.getRejectCount() + 1);
                }
                supervisorFound = true;
            }
            if (supervisorFound) continue;
            SupervisorBeSummaryReport newReportItem = new SupervisorBeSummaryReport();
            newReportItem.setSupervisorId(supervisorId);
            if (status.equalsIgnoreCase("APPROVED")) {
                newReportItem.setApprovedCount(1);
            }
            if (status.equalsIgnoreCase("REJECTED") || status.equalsIgnoreCase("AUTO_REJECTED")) {
                newReportItem.setRejectCount(1);
            }
            for (SupervisorBeSummaryReport opName : userIdList) {
                if (!supervisorId.equalsIgnoreCase(opName.getSupervisorId())) continue;
                newReportItem.setSupervisorName(opName.getSupervisorName());
            }
            supervisorBeSummaryReport.add(newReportItem);
        }
        report.setSupervisorBeSummaryReport(supervisorBeSummaryReport);
    }

    private void populateIntegrityFailedSummary(HoldRejectReportData report, List<ReportSummary> holdRejectSummaryForToday) {
        ArrayList<HoldRejectDetailsSummary> detailsList = new ArrayList<HoldRejectDetailsSummary>();
        int serialNum = 1;
        for (ReportSummary summary : holdRejectSummaryForToday) {
            HoldRejectDetailsSummary detailsSummary = new HoldRejectDetailsSummary();
            detailsSummary.setSerialNum(serialNum++);
            detailsSummary.setEnrolIdDate(summary.getEnrolId());
            detailsSummary.setName(summary.getResidentName());
            detailsSummary.setStatus(summary.getStatus());
            detailsSummary.setAddress(summary.getAddress());
            detailsSummary.setMobile(summary.getMobile());
            detailsSummary.setModerator(summary.getModerator());
            detailsSummary.setReason(summary.getReason());
            detailsList.add(detailsSummary);
        }
        report.setDetailsSummary(detailsList);
    }
}

