/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.report;

import in.gov.uidai.ec.service.enrol.ECMPDateFormatHelper;
import in.gov.uidai.ec.service.enrol.ECMPDateFormats;
import in.gov.uidai.ec.service.findaadhaar.FindAadhaarAttempt;
import in.gov.uidai.ec.service.report.EODReportData;
import in.gov.uidai.ec.service.report.HoldRejectReportData;
import in.gov.uidai.ec.service.report.PrintAadhaarDateWiseSummary;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Date;
import java.util.List;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityHelper {
    public void generateEODReportFile(EODReportData rptData, String fromDateStr, String toDateStr, String fileName, String templatePath) throws Exception {
        Properties vprops;
        String lastSyncDateStr;
        String lastRegisteredDateStr;
        Date reportDate = new Date(rptData.getReportDate());
        String reportDateStr = ECMPDateFormatHelper.getDateStr(reportDate, ECMPDateFormats.FULL_DELIM_DATE_FORMAT);
        if (rptData.getLastRegisteredDate() != 0L) {
            Date lastRegisteredDate = new Date(rptData.getLastRegisteredDate());
            lastRegisteredDateStr = ECMPDateFormatHelper.getDateStr(lastRegisteredDate, ECMPDateFormats.FULL_DELIM_DATE_FORMAT);
        } else {
            lastRegisteredDateStr = "- - -";
        }
        if (rptData.getLastSyncDate() != 0L) {
            Date lastSyncDate = new Date(rptData.getLastSyncDate());
            lastSyncDateStr = ECMPDateFormatHelper.getDateStr(lastSyncDate, ECMPDateFormats.FULL_DELIM_DATE_FORMAT);
        } else {
            lastSyncDateStr = "- - -";
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        VelocityEngine ve = new VelocityEngine();
        try (InputStream propin = cl.getResourceAsStream("res/bundles/velocity.properties");){
            vprops = new Properties();
            vprops.load(propin);
            if (propin != null) {
                propin.close();
            }
        }
        ve.init(vprops);
        VelocityContext context = new VelocityContext();
        context.put("reportDate", (Object)reportDateStr);
        context.put("registrar", (Object)rptData.getRegistrarId());
        context.put("enrolmentAgency", (Object)rptData.getEnrolmentAgencyId());
        context.put("operatorId", (Object)rptData.getOperatorId());
        context.put("stationId", (Object)rptData.getStationId());
        context.put("lastRegistered", (Object)lastRegisteredDateStr);
        context.put("lastSync", (Object)lastSyncDateStr);
        context.put("clientVersion", (Object)rptData.getClientVersion());
        context.put("fromDate", (Object)fromDateStr);
        context.put("toDate", (Object)toDateStr);
        context.put("datewiseList", rptData.getDatewiseSummary());
        context.put("detailsList", rptData.getDetailsSummary());
        this.saveToFile(fileName, ve, context, templatePath);
    }

    public void generatePrintAadhaarReportFile(List<FindAadhaarAttempt> attemptList, List<PrintAadhaarDateWiseSummary> dateWiseSummaries, String fromDateStr, String toDateStr, String fileName) throws Exception {
        Date reportDate = new Date(System.currentTimeMillis());
        String reportDateStr = ECMPDateFormatHelper.getDateStr(reportDate, ECMPDateFormats.FULL_DELIM_DATE_FORMAT);
        VelocityContext context = new VelocityContext();
        context.put("reportDate", (Object)reportDateStr);
        context.put("fromDate", (Object)fromDateStr);
        context.put("toDate", (Object)toDateStr);
        context.put("datewiseList", dateWiseSummaries);
        context.put("detailsList", attemptList);
        this.saveToFile(fileName, this.getVelocityEngine(), context, "conf/pareport.vm");
    }

    public void generateIntegrityFailedReportFile(HoldRejectReportData rptData, String fileName) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("detailsList", rptData.getDetailsSummary());
        this.saveToFile(fileName, this.getVelocityEngine(), context, "conf/integrityfailedreport.vm");
    }

    private VelocityEngine getVelocityEngine() throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        VelocityEngine ve = new VelocityEngine();
        InputStream propin = cl.getResourceAsStream("res/bundles/velocity.properties");
        Properties vprops = new Properties();
        vprops.load(propin);
        if (propin != null) {
            propin.close();
        }
        ve.init(vprops);
        return ve;
    }

    private void saveToFile(String fileName, VelocityEngine ve, VelocityContext context, String templatePath) throws IOException {
        Template template = ve.getTemplate(templatePath);
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        try (FileOutputStream out = new FileOutputStream(fileName);
             PrintStream p = new PrintStream(out);){
            p.print(writer.toString());
        }
    }
}

