/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.session;

import in.gov.uidai.ec.ecmpapi.xml.api.ApiSessionData;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.session.SessionDataParseException;
import in.gov.uidai.ec.service.session.SessionFileIOException;
import in.gov.uidai.ec.service.session.model.OperatorLoginDetails;
import java.util.function.Consumer;

public interface ISessionService {
    public OperatorLoginDetails getOperatorLoginDetails();

    public UserCredentials getOperatorCredentials();

    public String getUserSessionId();

    public String getOpSyncInterval();

    public int getSessionRemainingValidityInDays();

    public String getRegistrationSequenceNumber();

    public String getStartTime();

    public boolean isOperatorOnboarded();

    public boolean isSessionValid();

    public byte[] getSessionKey();

    public boolean isFindAadhaarEnabled();

    public boolean isAgeValidationEnabled();

    public boolean isBiometricUpdateDisabledForStation();

    public boolean isNewEnrollmentDisabled();

    public String getPacApiKey();

    public String getConnectTypeKey();

    public String getPacApiUrl();

    public String getPacApiKeyVersion();

    public boolean isPacValidationSettingEnabled();

    public boolean isNrcMandatory();

    public void addSessionDataChangeListener(Consumer<Object> var1);

    public void deleteSessionFiles();

    public void clearCurrentSession();

    public void createNonPersistentSession(ApiSessionData var1) throws SessionDataParseException;

    public void createPersistentSession(ApiSessionData var1) throws SessionDataParseException, SessionFileIOException;

    public String sign(byte[] var1, String var2) throws Exception;

    public String encrypt(byte[] var1, String var2) throws Exception;

    public void resetOperatorLoginDetails();

    public String getMaxUnUploadedPacketCount();

    public String getMaxUnUploadedDaysAllowedWhenStationOnline();

    public String getMaxEnrollmentPacketsPerDay();

    public String getMaxUnUploadedDaysAllowedWhenStationOffline();

    public String getDisclosureTimeout();

    public boolean isDobValidationEnabled();

    public boolean isNameValidationEnabled();

    public boolean isGenderValidationEnabled();
}

