/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.session;

import in.gov.uidai.ec.security.impl.AesEncryptionUtil;
import in.gov.uidai.ec.security.impl.EncryptionException;
import in.gov.uidai.ec.security.impl.SecureFile;
import in.gov.uidai.ec.security.impl.SecureFileException;

public class SessionFile
extends SecureFile {
    private byte[] key;
    private String associatedData;

    SessionFile(String path, byte[] key, String associatedData) {
        super(path);
        this.key = key;
        this.associatedData = associatedData;
    }

    protected byte[] encrypt(byte[] data) throws SecureFileException {
        try {
            return AesEncryptionUtil.encrypt((byte[])data, (byte[])this.key, (String)this.associatedData);
        }
        catch (EncryptionException e) {
            throw new SecureFileException("error encrypting data", (Exception)((Object)e));
        }
    }

    protected byte[] decrypt(byte[] cipherMessage) throws SecureFileException {
        try {
            return AesEncryptionUtil.decrypt((byte[])cipherMessage, (byte[])this.key, (String)this.associatedData);
        }
        catch (EncryptionException e) {
            throw new SecureFileException("error decrypting data", (Exception)((Object)e));
        }
    }
}

