/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.session;

import in.gov.uidai.ec.ecmpapi.xml.api.ApiSessionData;
import in.gov.uidai.ec.escapi.EnrolServiceClientApiService;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.security.sapi.IHashGenerator;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.onboarding.IOnboardingService;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.session.IOperatorSyncDAO;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.service.session.SessionDataParseException;
import in.gov.uidai.ec.service.session.SessionFileIOException;
import in.gov.uidai.ec.service.session.UserSession;
import in.gov.uidai.ec.service.session.model.OperatorLoginDetails;
import java.util.Base64;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionService
implements ISessionService,
InitializingBean {
    private UserSession userSession;
    private IPreSyncPreference preSyncPref;
    private IHashGenerator hashGenerator;
    private IOperatorSyncDAO operatorSyncDao;
    private OperatorLoginDetails operatorLoginDetails;
    private IResourceBundleContext ctxt;
    private IRegistrationService registrationService;
    private BiometricsAuthService biometricsAuthService;
    private IOnboardingService onboardingService;
    @Autowired
    private EnrolServiceClientApiService enrolServiceClientApiService;

    public void setOnboardingService(IOnboardingService onboardingService) {
        this.onboardingService = onboardingService;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.ctxt = ctxt;
    }

    public void setHashGenerator(IHashGenerator hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    public void setPreSyncPreference(IPreSyncPreference pref) {
        this.preSyncPref = pref;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setOperatorSyncDao(IOperatorSyncDAO operatorSyncDao) {
        this.operatorSyncDao = operatorSyncDao;
    }

    public void setBiometricsAuthService(BiometricsAuthService biometricsAuthService) {
        this.biometricsAuthService = biometricsAuthService;
    }

    public void afterPropertiesSet() throws Exception {
        this.userSession = new UserSession();
        this.operatorLoginDetails = new OperatorLoginDetails(this.ctxt, this.preSyncPref, this.biometricsAuthService);
        this.operatorLoginDetails.getLoginValidator().setUserSession(this.userSession);
        this.userSession.setOperatorLoginDetails(this.operatorLoginDetails);
        this.userSession.setRegistrationService(this.registrationService);
    }

    @Override
    public OperatorLoginDetails getOperatorLoginDetails() {
        return this.operatorLoginDetails;
    }

    @Override
    public UserCredentials getOperatorCredentials() {
        return this.operatorLoginDetails.getCredentials();
    }

    @Override
    public String getUserSessionId() {
        return this.userSession.getId();
    }

    @Override
    public String getOpSyncInterval() {
        return this.userSession.getOpSyncInterval();
    }

    @Override
    public int getSessionRemainingValidityInDays() {
        return this.userSession.getSessionRemainingValidityInDays();
    }

    @Override
    public String getRegistrationSequenceNumber() {
        return this.userSession.getRegistrationSequenceNumber();
    }

    @Override
    public String getStartTime() {
        return this.userSession.getStartTime();
    }

    @Override
    public boolean isOperatorOnboarded() {
        return this.onboardingService.isUserOnBoarded(this.getOperatorCredentials().getUid());
    }

    @Override
    public boolean isSessionValid() {
        return this.userSession.isSessionValid();
    }

    @Override
    public byte[] getSessionKey() {
        return this.userSession.getSessionKey();
    }

    @Override
    public boolean isFindAadhaarEnabled() {
        String findAadhaarSetting = this.userSession.getUserPermissions().get("find_aadhaar");
        return StringUtils.isNotBlank((String)findAadhaarSetting) && StringUtils.equalsIgnoreCase((String)findAadhaarSetting, (String)"Y");
    }

    @Override
    public boolean isBiometricUpdateDisabledForStation() {
        String bioUpdateSetting = this.userSession.getUserPermissions().get("bio_update");
        return StringUtils.isNotBlank((String)bioUpdateSetting) && StringUtils.equalsIgnoreCase((String)bioUpdateSetting, (String)"N");
    }

    @Override
    public boolean isNewEnrollmentDisabled() {
        String newEnrolmentSetting = this.userSession.getUserPermissions().get("new_enrolment");
        return StringUtils.isNotBlank((String)newEnrolmentSetting) && StringUtils.equalsIgnoreCase((String)newEnrolmentSetting, (String)"N");
    }

    @Override
    public String getPacApiKey() {
        return this.userSession.getSettings().get("pac_api_key");
    }

    @Override
    public String getConnectTypeKey() {
        return this.userSession.getSettings().get("connect_type");
    }

    @Override
    public String getPacApiUrl() {
        return this.userSession.getSettings().get("pac_api_url");
    }

    @Override
    public String getPacApiKeyVersion() {
        return this.userSession.getSettings().get("pac_api_key_version");
    }

    @Override
    public boolean isPacValidationSettingEnabled() {
        String validatePac = this.userSession.getSettings().get("validate_pac");
        return StringUtils.isNotBlank((String)validatePac) && StringUtils.equalsIgnoreCase((String)validatePac, (String)"Y");
    }

    @Override
    public boolean isNrcMandatory() {
        String nrcSetting = this.userSession.getSettings().get("NRC_mandatory");
        return StringUtils.isNotBlank((String)nrcSetting) && StringUtils.equalsIgnoreCase((String)nrcSetting, (String)"Y");
    }

    @Override
    public void addSessionDataChangeListener(Consumer<Object> delegate) {
        this.userSession.addSessionDataChangeListener(delegate);
    }

    @Override
    public void deleteSessionFiles() {
        this.userSession.deleteSessionFiles();
    }

    @Override
    public void clearCurrentSession() {
        this.userSession.deleteCurrentSession();
        this.userSession.resetSession();
    }

    @Override
    public void createNonPersistentSession(ApiSessionData apiSessionData) throws SessionDataParseException {
        this.userSession.createNonPersistentSession(apiSessionData);
    }

    @Override
    public void createPersistentSession(ApiSessionData apiSessionData) throws SessionDataParseException, SessionFileIOException {
        this.userSession.createPersistentSession(apiSessionData);
    }

    @Override
    public String sign(byte[] bytes, String associatedData) throws Exception {
        return Base64.getEncoder().encodeToString(this.userSession.encrypt(this.hashGenerator.generateHash(bytes), associatedData));
    }

    @Override
    public String encrypt(byte[] bytes, String associatedData) throws Exception {
        return Base64.getEncoder().encodeToString(this.userSession.encrypt(bytes, associatedData));
    }

    @Override
    public void resetOperatorLoginDetails() {
        this.operatorLoginDetails.reset();
    }

    @Override
    public String getMaxUnUploadedPacketCount() {
        return this.userSession.getSettings().get("max_unuploaded_count");
    }

    @Override
    public String getMaxUnUploadedDaysAllowedWhenStationOnline() {
        return this.userSession.getSettings().get("max_unuploaded_days_allowed_when_station_online");
    }

    @Override
    public String getMaxEnrollmentPacketsPerDay() {
        return this.userSession.getSettings().get("max_enrollments_allowed_per_day");
    }

    @Override
    public String getMaxUnUploadedDaysAllowedWhenStationOffline() {
        return this.userSession.getSettings().get("max_unuploaded_days_allowed_when_station_offline");
    }

    @Override
    public String getDisclosureTimeout() {
        return this.userSession.getSettings().get("operator_disclosure_timeout");
    }

    @Override
    public boolean isNameValidationEnabled() {
        String update_name = this.userSession.getUserPermissions().get("update_name");
        return StringUtils.isBlank((String)update_name) || StringUtils.isNotBlank((String)update_name) && StringUtils.equalsIgnoreCase((String)update_name, (String)"Y");
    }

    @Override
    public boolean isGenderValidationEnabled() {
        String update_gender = this.userSession.getUserPermissions().get("update_gender");
        return StringUtils.isBlank((String)update_gender) || StringUtils.isNotBlank((String)update_gender) && StringUtils.equalsIgnoreCase((String)update_gender, (String)"Y");
    }

    @Override
    public boolean isDobValidationEnabled() {
        String update_dob = this.userSession.getUserPermissions().get("update_dob");
        return StringUtils.isBlank((String)update_dob) || StringUtils.isNotBlank((String)update_dob) && StringUtils.equalsIgnoreCase((String)update_dob, (String)"Y");
    }

    @Override
    public boolean isAgeValidationEnabled() {
        String eighteenPlusAadhaarSetting = this.userSession.getUserPermissions().get("above_18_enrollment");
        return StringUtils.isBlank((String)eighteenPlusAadhaarSetting) || StringUtils.isNotBlank((String)eighteenPlusAadhaarSetting) && StringUtils.equalsIgnoreCase((String)eighteenPlusAadhaarSetting, (String)"Y");
    }
}

