/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.session;

import com.fasterxml.jackson.databind.ObjectMapper;
import in.gov.uidai.ec.ecmpapi.xml.api.ApiSessionData;
import in.gov.uidai.ec.security.impl.AesEncryptionUtil;
import in.gov.uidai.ec.security.impl.RecoverableFileException;
import in.gov.uidai.ec.service.enrol.ECMPDateFormats;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.session.SessionData;
import in.gov.uidai.ec.service.session.SessionDataParseException;
import in.gov.uidai.ec.service.session.SessionFile;
import in.gov.uidai.ec.service.session.SessionFileIOException;
import in.gov.uidai.ec.service.session.model.OperatorLoginDetails;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserSession.class);
    private static final String SESSION_DETAILS_DIR = "./data/session/";
    private static final String associatedData = "Session-Data";
    private final List<Consumer<Object>> changeSessionDataListeners = new ArrayList<Consumer<Object>>();
    private OperatorLoginDetails operatorLoginDetails;
    private int invalidResumePasswordAttempts = 0;
    private SessionData sessionData = new SessionData();
    private IRegistrationService registrationService;

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void addSessionDataChangeListener(Consumer<Object> delegate) {
        if (delegate == null) {
            return;
        }
        this.changeSessionDataListeners.add(delegate);
    }

    protected void fireSessionDataChangedEvent() {
        this.changeSessionDataListeners.forEach(listener -> listener.accept(true));
    }

    public void setOperatorLoginDetails(OperatorLoginDetails operatorLoginDetails) {
        this.operatorLoginDetails = operatorLoginDetails;
    }

    public Map<String, String> getUserPermissions() {
        return this.sessionData.getPermissions();
    }

    public Map<String, String> getSettings() {
        return this.sessionData.getSettings();
    }

    byte[] getSessionKey() {
        return this.sessionData.getKey();
    }

    String getId() {
        return this.sessionData.getId();
    }

    String getOpSyncInterval() {
        int differenceInDays = (int)((this.sessionData.getExpiryTime().getTime() - this.sessionData.getStartTime().getTime()) / 86400000L);
        return Integer.toString(differenceInDays);
    }

    int getSessionRemainingValidityInDays() {
        return (int)((this.sessionData.getExpiryTime().getTime() - new Date(System.currentTimeMillis()).getTime()) / 86400000L);
    }

    String getStartTime() {
        return this.sessionData.getStartTime().toString();
    }

    String getRegistrationSequenceNumber() {
        return this.sessionData.getRegistrationSequenceNumber();
    }

    private boolean isSessionExpired() {
        try {
            int addMinuteTime = 30;
            Date targetTime = new Date();
            targetTime = DateUtils.addMinutes((Date)targetTime, (int)addMinuteTime);
            return this.sessionData.getExpiryTime().before(new Timestamp(targetTime.getTime()));
        }
        catch (Exception e) {
            LOGGER.error("Failed to check session expiry time.", (Throwable)e);
            return true;
        }
    }

    public boolean isValidResumePassword() {
        boolean isSessionLoaded;
        this.sessionData = new SessionData();
        this.loadSession();
        boolean bl = isSessionLoaded = this.sessionData.getKey() != null;
        if (!isSessionLoaded) {
            ++this.invalidResumePasswordAttempts;
        }
        return isSessionLoaded;
    }

    public boolean isSessionValid() {
        boolean isSessionValid = this.sessionData != null && this.sessionData.getKey() != null;
        return isSessionValid && !this.isSessionExpired();
    }

    public boolean isExceededInvalidAttempts() {
        if (this.invalidResumePasswordAttempts >= 3) {
            try {
                Files.deleteIfExists(Paths.get(this.getSessionFilePath(), new String[0]));
            }
            catch (IOException e) {
                LOGGER.error("Error while deleting session file during max invalid resume key attempts", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    void resetSession() {
        this.sessionData = new SessionData();
        this.fireSessionDataChangedEvent();
    }

    public boolean doesSessionFileExists() {
        return new File(this.getSessionFilePath()).exists();
    }

    void deleteSessionFiles() {
        File sessionDataDir = new File(SESSION_DETAILS_DIR);
        File[] files = sessionDataDir.listFiles();
        if (files != null) {
            Arrays.stream(files).forEach(file -> {
                boolean isDeleted = file.delete();
                if (!isDeleted) {
                    LOGGER.info("Failed to delete file: {}");
                }
            });
        }
        if (sessionDataDir.delete()) {
            LOGGER.info("Successfully deleted all session data files");
        }
    }

    void deleteCurrentSession() {
        File sessionFile = new File(this.getSessionFilePath());
        if (sessionFile.exists() && sessionFile.delete()) {
            LOGGER.info("Successfully deleted current session data file");
        }
    }

    byte[] encrypt(byte[] data, String associatedData) throws Exception {
        if (!this.isSessionValid()) {
            throw new Exception("user session is either expired, invalid or unavailable");
        }
        return AesEncryptionUtil.encrypt((byte[])data, (byte[])this.sessionData.getKey(), (String)associatedData);
    }

    void createNonPersistentSession(ApiSessionData apiSessionData) throws SessionDataParseException {
        this.setSessionData(apiSessionData);
        this.fireSessionDataChangedEvent();
    }

    void createPersistentSession(ApiSessionData apiSessionData) throws SessionDataParseException, SessionFileIOException {
        this.setSessionData(apiSessionData);
        try {
            File f = new File(this.getSessionFilePath()).getParentFile();
            if (f.mkdirs()) {
                LOGGER.info("Directory created");
            } else {
                LOGGER.info("Directory not created");
            }
            String sessionDataJSON = new ObjectMapper().writer().withDefaultPrettyPrinter().writeValueAsString((Object)this.sessionData);
            SessionFile secureFile = new SessionFile(this.getSessionFilePath(), this.getEncryptedResumePassword(), associatedData);
            secureFile.write(sessionDataJSON.getBytes());
            LOGGER.info("Session is successfully created");
            this.fireSessionDataChangedEvent();
        }
        catch (RecoverableFileException | IOException e) {
            throw new SessionFileIOException("Error while creating session file: " + e);
        }
    }

    private void setSessionData(ApiSessionData apiSessionData) throws SessionDataParseException {
        this.sessionData = new SessionData();
        try {
            this.sessionData.setId(apiSessionData.getId().toString());
            this.sessionData.setStationType(apiSessionData.getStationType().toString());
            this.sessionData.setKey(Base64.decodeBase64((String)apiSessionData.getKey()));
            this.sessionData.setStartTime(new Timestamp(new SimpleDateFormat(ECMPDateFormats.RFC_3339_DATE_FORMAT.getFormat()).parse(apiSessionData.getStartTime()).getTime()));
            this.sessionData.setExpiryTime(new Timestamp(new SimpleDateFormat(ECMPDateFormats.RFC_3339_DATE_FORMAT.getFormat()).parse(apiSessionData.getExpiryTime()).getTime()));
            this.sessionData.setRegistrationSequenceNumber(apiSessionData.getRegistrationSequenceNumber());
            this.sessionData.setPermissions(apiSessionData.getPermissions());
            this.sessionData.setSettings(apiSessionData.getSettings());
            LOGGER.info("User permissions:" + this.sessionData.getPermissions());
            LOGGER.info("User settings:" + this.sessionData.getSettings());
        }
        catch (Exception e) {
            throw new SessionDataParseException("Error while parsing session data:  " + e);
        }
    }

    private void loadSession() {
        try {
            SessionFile secureFile = new SessionFile(this.getSessionFilePath(), this.getEncryptedResumePassword(), associatedData);
            byte[] decryptedData = secureFile.readWithRecover();
            if (decryptedData == null) {
                LOGGER.error("Session Details file is empty");
                return;
            }
            this.sessionData = (SessionData)new ObjectMapper().readValue(decryptedData, SessionData.class);
        }
        catch (RecoverableFileException | IOException e) {
            LOGGER.error("Wrong resume password. Failed to load session details. " + e.getMessage());
            LOGGER.debug("", e);
        }
    }

    private String getSessionFilePath() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] fileNameHash = Base64.encodeBase64((byte[])md.digest((this.operatorLoginDetails.getCredentials().getUid() + this.registrationService.getRegisteredMachineCode()).getBytes()));
            String fileName = new String(fileNameHash, StandardCharsets.UTF_8).replaceAll("/", "_") + ".dat";
            return SESSION_DETAILS_DIR + fileName;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Unable to get session file name, Error: ", (Throwable)e);
            return "";
        }
    }

    private byte[] getEncryptedResumePassword() {
        try {
            return MessageDigest.getInstance("SHA-256").digest(this.operatorLoginDetails.getResumePassword().getPassword().getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Unable to get encryption key of session file, Error: " + e.getMessage());
            return null;
        }
    }
}

