/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.session.model;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.ModelBase;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.session.UserSession;
import in.gov.uidai.ec.service.session.model.MsgKeysLogin;
import in.gov.uidai.ec.service.session.model.OperatorDetails;
import in.gov.uidai.ec.service.session.model.ResumePassword;
import org.apache.commons.lang.StringUtils;

public class LoginValidator
extends ModelBase<LoginValidator> {
    private final OperatorDetails operatorDetails;
    private final ResumePassword resumePassword;
    private final BiometricsAuthService biometricsAuthService;
    private String loginError;
    private UserSession userSession;
    private boolean isOnlineLogin;
    private boolean isStep2LoginStarted;
    private boolean isStep2LoginCompleted;

    public LoginValidator(IResourceBundleContext rbCtx, OperatorDetails operatorDetails, ResumePassword resumePassword, BiometricsAuthService biometricsAuthService) {
        super(rbCtx);
        this.operatorDetails = operatorDetails;
        this.resumePassword = resumePassword;
        this.biometricsAuthService = biometricsAuthService;
    }

    public void setUserSession(UserSession userSession) {
        this.userSession = userSession;
    }

    public void reset() {
        this.isStep2LoginStarted = false;
        this.isStep2LoginCompleted = false;
        this.isOnlineLogin = false;
        this.loginError = null;
    }

    public String getLoginError() {
        return this.loginError;
    }

    public boolean isStep2LoginStarted() {
        return this.isStep2LoginStarted;
    }

    public boolean isOnlineLogin() {
        return this.isOnlineLogin;
    }

    public boolean isStep2LoginCompleted() {
        return this.isStep2LoginCompleted;
    }

    public void validate(boolean doOpSync) {
        MsgKeysLogin loginErrorMsgKey = null;
        this.loginError = null;
        if (!this.operatorDetails.isValid()) {
            this.operatorDetails.validate();
            this.loginError = this.operatorDetails.getIdError();
            this.setValid(false);
            return;
        }
        if (!this.isStep2LoginStarted) {
            this.isOnlineLogin = !this.biometricsAuthService.isOperatorOnboarded() || !this.userSession.doesSessionFileExists();
            this.isStep2LoginStarted = true;
            this.setValid(true);
            return;
        }
        if (!this.biometricsAuthService.isOperatorOnboarded()) {
            loginErrorMsgKey = MsgKeysLogin.USER_NOT_BOARDED;
        } else if (StringUtils.isBlank((String)this.operatorDetails.getLoginUid())) {
            loginErrorMsgKey = MsgKeysLogin.NOUID;
        } else if (StringUtils.isNotBlank((String)this.operatorDetails.getUidError())) {
            this.loginError = this.operatorDetails.getUidError();
        } else if (!this.biometricsAuthService.doesBiometricsMatchesWithLVSData()) {
            loginErrorMsgKey = MsgKeysLogin.BIO_NOT_PROVIDED;
        } else if (!doOpSync && !this.resumePassword.isValid()) {
            this.loginError = this.resumePassword.getError();
        } else if (!doOpSync && !this.userSession.doesSessionFileExists()) {
            loginErrorMsgKey = MsgKeysLogin.NO_SESSION;
        } else if (!doOpSync && !this.userSession.isValidResumePassword()) {
            loginErrorMsgKey = this.userSession.isExceededInvalidAttempts() ? MsgKeysLogin.MAX_INVALID_RESUME_KEY_ATTEMPTS : MsgKeysLogin.FAILED_AUTH_RESUME;
        }
        this.loginError = StringUtils.isBlank((String)this.loginError) ? this.getMessage((Object)loginErrorMsgKey, new Object[0]) : this.loginError;
        this.setValid(this.loginError == null);
        this.isStep2LoginCompleted = true;
    }
}

