/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.session.model;

import in.gov.uidai.ec.ecmpapi.xml.presync.InActiveOperator;
import in.gov.uidai.ec.ecmpapi.xml.presync.InActiveOperators;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.util.Verhoeff;
import in.gov.uidai.ec.service.ModelBase;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.session.model.MsgKeysLogin;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class OperatorDetails
extends ModelBase<OperatorDetails> {
    private final IPreSyncPreference preSyncPref;
    private UserCredentials credentials;
    private String idError;
    private String uidError;
    private String loginUid;

    public OperatorDetails(IResourceBundleContext rbCtx, IPreSyncPreference preSyncPref) {
        super(rbCtx);
        this.preSyncPref = preSyncPref;
    }

    public UserCredentials getOperatorDetails() {
        return this.credentials;
    }

    public void setOperatorDetails(UserCredentials credentials) {
        this.credentials = credentials;
        this.validate();
        this.fireChangeEvent(this);
    }

    public String getIdError() {
        return this.idError;
    }

    public String getUidError() {
        return this.uidError;
    }

    public void reset() {
        this.credentials = null;
        this.idError = null;
        this.uidError = null;
        this.loginUid = null;
    }

    public void validate() {
        MsgKeysLogin operatorIdErrorKey = null;
        if (this.credentials == null || this.credentials.toString().equalsIgnoreCase("Select")) {
            operatorIdErrorKey = MsgKeysLogin.NO_ID_SELECTED;
        } else if (StringUtils.isBlank((String)this.credentials.getAuthId())) {
            operatorIdErrorKey = MsgKeysLogin.USER_NOT_FOUND;
        } else if (this.isSuspendedOperator()) {
            operatorIdErrorKey = MsgKeysLogin.SUSPENDED_OPERATOR;
        } else if (this.isInactiveOperator()) {
            operatorIdErrorKey = MsgKeysLogin.INACTIVE_OPERATOR;
        }
        this.idError = this.getMessage((Object)operatorIdErrorKey, new Object[0]);
        this.setValid(this.idError == null);
    }

    private boolean isSuspendedOperator() {
        String[] suspendedOperators = this.preSyncPref.getSuspendedOperatorIDs();
        return suspendedOperators != null && Arrays.asList(suspendedOperators).contains(this.credentials.getUid());
    }

    private boolean isInactiveOperator() {
        List inactiveOpList = InActiveOperators.getInActiveOperatorList((String[])this.preSyncPref.getInactiveOperatorList(), (String)";");
        InActiveOperator op = new InActiveOperator();
        op.setUserCode(this.credentials.getOperatorId());
        return inactiveOpList.contains(op);
    }

    public void validateUid(String uid) {
        this.loginUid = uid;
        MsgKeysLogin uidErrorMsgKey = null;
        if (StringUtils.isBlank((String)uid)) {
            uidErrorMsgKey = MsgKeysLogin.NOUID;
        } else if (uid.startsWith("0") || uid.startsWith("1")) {
            uidErrorMsgKey = MsgKeysLogin.ZERO;
        } else if (!Verhoeff.validate((String)uid)) {
            uidErrorMsgKey = MsgKeysLogin.UID;
        } else if (!uid.equals(this.credentials.getUid())) {
            uidErrorMsgKey = MsgKeysLogin.INVALID_UID;
        }
        this.uidError = this.getMessage((Object)uidErrorMsgKey, new Object[0]);
        this.setValid(this.uidError == null);
    }

    public String getLoginUid() {
        return this.loginUid;
    }
}

