/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.session.model;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.ModelBase;
import in.gov.uidai.ec.service.session.model.MsgKeysLogin;
import org.apache.commons.lang.StringUtils;

public class ResumePassword
extends ModelBase<ResumePassword> {
    private String pword;
    private String opSyncOtp;
    private String passwordError;

    public ResumePassword(IResourceBundleContext rbCtx) {
        super(rbCtx);
    }

    public String getOpSyncOtp() {
        return this.opSyncOtp;
    }

    public void setOpSyncOtp(String otp) {
        this.opSyncOtp = otp;
        this.validate(otp, true);
        this.fireChangeEvent(this);
    }

    public String getPassword() {
        return this.pword;
    }

    public void setPassword(String password) {
        this.pword = password;
        this.validate(password, false);
        this.fireChangeEvent(this);
    }

    public String getError() {
        return this.passwordError;
    }

    public void updateResumePasswordToOtp() {
        this.pword = this.opSyncOtp;
    }

    public void reset() {
        this.pword = null;
        this.opSyncOtp = null;
        this.passwordError = null;
    }

    private void validate(String data, boolean isOpSyncOtp) {
        MsgKeysLogin passwordErrorMsgKey = null;
        if (StringUtils.isBlank((String)data)) {
            passwordErrorMsgKey = isOpSyncOtp ? MsgKeysLogin.NO_OTP : MsgKeysLogin.NO_RESUME_PASSWORD;
        } else if (data.length() < 6) {
            passwordErrorMsgKey = isOpSyncOtp ? MsgKeysLogin.OTP_MIN_LENGTH : MsgKeysLogin.RESUME_MIN_LENGTH;
        } else if (data.length() > 12) {
            passwordErrorMsgKey = isOpSyncOtp ? MsgKeysLogin.OTP_MAX_LENGTH : MsgKeysLogin.RESUME_MAX_LENGTH;
        }
        this.passwordError = this.getMessage((Object)passwordErrorMsgKey, new Object[0]);
        this.setValid(this.passwordError == null);
    }
}

