/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.universalClient.uiHandler;

import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInformation;
import java.util.EnumSet;
import java.util.Set;

public class FieldInfoUtils {
    private static boolean isEnrollment;
    private static boolean isHofEnrollment;
    private static Set<FieldInformation> enabledTabs;

    public static Set<FieldInformation> getEnabledTabs(String bitmap) {
        enabledTabs = EnumSet.noneOf(FieldInformation.class);
        int bitmask = Integer.parseInt(bitmap, 2);
        for (FieldInformation tab : FieldInformation.values()) {
            if ((bitmask & 1 << tab.getBitLocation()) == 0) continue;
            enabledTabs.add(tab);
        }
        return enabledTabs;
    }

    public static Set<FieldInformation> getEnabledTabs() {
        return enabledTabs;
    }

    public static void setIsEnrollment(boolean enrollment) {
        isEnrollment = enrollment;
    }

    public static void setIsHofEnrollment(boolean hofEnrollment) {
        isHofEnrollment = hofEnrollment;
    }

    public static boolean isDemographicTabRequired() {
        if (isEnrollment) {
            return true;
        }
        return enabledTabs.stream().anyMatch(field -> field.equals((Object)FieldInformation.NAME) || field.equals((Object)FieldInformation.DOB) || field.equals((Object)FieldInformation.GENDER) || field.equals((Object)FieldInformation.ADDRESS) || field.equals((Object)FieldInformation.MOBILE) || field.equals((Object)FieldInformation.EMAIL));
    }

    public static boolean isPOFRequired() {
        return enabledTabs.stream().anyMatch(field -> field.equals((Object)FieldInformation.POF));
    }

    public static boolean isReferenceTabRequired() {
        if (isEnrollment) {
            return true;
        }
        return enabledTabs.stream().anyMatch(field -> field.equals((Object)FieldInformation.POB) || field.equals((Object)FieldInformation.POI) || field.equals((Object)FieldInformation.POA) || field.equals((Object)FieldInformation.POR) || field.equals((Object)FieldInformation.POF));
    }

    public static boolean isPhotoTabRequired() {
        if (isEnrollment) {
            return true;
        }
        return enabledTabs.contains((Object)FieldInformation.PHOTO);
    }

    public static boolean isFingerTabRequired() {
        if (isEnrollment) {
            return true;
        }
        return enabledTabs.contains((Object)FieldInformation.FINGER);
    }

    public static boolean isIrisTabRequired() {
        if (isEnrollment) {
            return true;
        }
        return enabledTabs.contains((Object)FieldInformation.IRIS);
    }

    public static boolean isConsentRequired() {
        if (isEnrollment) {
            return false;
        }
        return enabledTabs.contains((Object)FieldInformation.CONSENT);
    }

    public static boolean isHofConsentRequired() {
        if (isEnrollment && isHofEnrollment) {
            return true;
        }
        return enabledTabs.contains((Object)FieldInformation.HOF);
    }

    public static boolean isFieldEnabled(FieldInformation field) {
        return enabledTabs.contains((Object)field);
    }
}

