/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.verification;

import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.ec.security.impl.HashGeneratorImpl;
import in.gov.uidai.ec.service.presync.CheckSumDetails;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.presync.IServerSyncDAO;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.lvs.spi.ILocalVerificationService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientLvsChecksum {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientLvsChecksum.class);
    private static final String MSG_DIGEST_ALGORITHM = "MD5";

    ClientLvsChecksum() {
    }

    public boolean verifyClientChecksum(IRegistrationService registrationService, IPreSyncPreference syncPreference, IServerSyncDAO servSyncDAO) {
        LOGGER.debug("Entered verifyClientChecksum");
        String preSyncNewCeckSum = this.createNewClientChecksum(registrationService, syncPreference);
        String checkSum = syncPreference.getClientSyncNewCheckSum();
        CheckSumDetails details = servSyncDAO.getCheckSum("CLIENT_CHECK_SUM_NEW_VERSION");
        if ((checkSum == null || preSyncNewCeckSum.equals(checkSum)) && (details == null || details.getCheckSumValue().equals(checkSum))) {
            LOGGER.debug("Checksum for client matches successfully.");
            return true;
        }
        LOGGER.debug("Checksum for client does not matches successfully.");
        return false;
    }

    private String createNewClientChecksum(IRegistrationService registrationService, IPreSyncPreference syncPreference) {
        String key = registrationService.getAgencyId() + registrationService.getRegisteredMachineCode() + registrationService.getStationId() + registrationService.getRegistrarId() + syncPreference.getNewClientVersion() + syncPreference.getMaxPacketsPerDay() + syncPreference.getMaxUnexportedPackets() + syncPreference.getMaxUnuploadedPackets() + syncPreference.getClientForceShutdown() + syncPreference.getGPSUpdateVerifyRequired() + syncPreference.getRGIRegistrar() + syncPreference.getScanDocuments() + syncPreference.getKeySize() + syncPreference.getAuthRequestType() + syncPreference.getSecretKey();
        return this.getCheckSumValue(key.getBytes());
    }

    private String getCheckSumValue(byte[] decryptedPaketData) {
        String checkSum = null;
        try {
            checkSum = this.getChecksum(decryptedPaketData);
        }
        catch (Exception e) {
            LOGGER.error("Hashig Exception while getting checksum from decryptedPaketData " + e);
        }
        return checkSum;
    }

    private String getChecksum(byte[] decryptedPaketData) {
        HashGeneratorImpl generatorImpl = new HashGeneratorImpl();
        generatorImpl.setAlgorithm(MSG_DIGEST_ALGORITHM);
        return decryptedPaketData != null && decryptedPaketData.length > 0 ? generatorImpl.generateHashHexString(decryptedPaketData) : null;
    }

    public boolean verifyLvsChecksum(IRegistrationService registrationService, IPreSyncPreference syncPreference, IServerSyncDAO servSyncDAO, ArrayList<String> userIdList) {
        String lvsChecksum = this.calculateLVSChecksum(registrationService, syncPreference, userIdList);
        CheckSumDetails details = servSyncDAO.getCheckSum("LVS_CHECKSUM");
        String preSyncCheckSum = syncPreference.getLvsCheckSum();
        LOGGER.debug("lvsChecksum preSyncCheckSum::" + preSyncCheckSum);
        LOGGER.debug("lvsChecksum preSyncCheckSum details::" + details.getCheckSumValue());
        if (lvsChecksum != null && lvsChecksum.equals(preSyncCheckSum) && lvsChecksum.equals(details.getCheckSumValue())) {
            LOGGER.debug("Checksum for LVS properties matches successfully.");
            return true;
        }
        LOGGER.info("Checksum does not matches for LVS properties.");
        return false;
    }

    String calculateLVSChecksum(IRegistrationService registrationService, IPreSyncPreference syncPreference, ArrayList<String> userIdList) {
        ILocalVerificationService lvs = null;
        String time = registrationService.getRegistrationTime();
        try {
            lvs = LVSLocator.instance();
        }
        catch (Exception exep) {
            LOGGER.error("unable to connect with lvs", (Throwable)exep);
        }
        StringBuilder appendingValues = new StringBuilder();
        if (userIdList != null && lvs != null) {
            for (String opeUid : userIdList) {
                List bioTemplates = lvs.getBioTemplatesForLoggedinUser(opeUid);
                appendingValues.append(bioTemplates);
            }
        } else {
            LOGGER.error("userIdList empty::");
        }
        appendingValues.append(registrationService.getRegisteredMachineCode());
        appendingValues.append(syncPreference.getClientVersion());
        appendingValues.append(time);
        String key = appendingValues.toString();
        String lvsChecksum = this.getCheckSumValue(key.getBytes());
        LOGGER.debug("lvsChecksum::" + lvsChecksum);
        return lvsChecksum;
    }
}

