/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.service.verification;

import in.gov.uidai.ec.biometrics.lvs.LVSException;
import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.ec.ecmpapi.xml.presync.InActiveOperator;
import in.gov.uidai.ec.ecmpapi.xml.presync.InActiveOperators;
import in.gov.uidai.ec.escapi.ChecksumInfo;
import in.gov.uidai.ec.escapi.EnrolServiceClientApiException;
import in.gov.uidai.ec.escapi.EnrolServiceClientApiService;
import in.gov.uidai.ec.escapi.GpsInfo;
import in.gov.uidai.ec.escapi.PingResponse;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.escapi.UploadActivityResponse;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStoreAware;
import in.gov.uidai.ec.icas.preference.TimeInterval;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import in.gov.uidai.ec.security.impl.JarIntegrityCheck;
import in.gov.uidai.ec.service.enrol.ECMPDateFormatHelper;
import in.gov.uidai.ec.service.enrol.ECMPDateFormats;
import in.gov.uidai.ec.service.gps.IGpsPreference;
import in.gov.uidai.ec.service.onboarding.IOnboardingService;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.presync.IServerSyncDAO;
import in.gov.uidai.ec.service.registration.IRegistrationService;
import in.gov.uidai.ec.service.report.IEodReportSearch;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.service.verification.ClientChecksumVerificationFailedException;
import in.gov.uidai.ec.service.verification.ClientLvsChecksum;
import in.gov.uidai.ec.service.verification.ClientNotRegisteredException;
import in.gov.uidai.ec.service.verification.ClientVersionMismatchException;
import in.gov.uidai.ec.service.verification.DayLimitReachedException;
import in.gov.uidai.ec.service.verification.DeRegisteredException;
import in.gov.uidai.ec.service.verification.DeRegistrationInProgressException;
import in.gov.uidai.ec.service.verification.EnrolServiceClientInvalidPingResponseException;
import in.gov.uidai.ec.service.verification.EnrolServiceClientStatusVerificationException;
import in.gov.uidai.ec.service.verification.ForceShutDownException;
import in.gov.uidai.ec.service.verification.GpsUpdateRequiredException;
import in.gov.uidai.ec.service.verification.IntegrityVerificationException;
import in.gov.uidai.ec.service.verification.JarIntegrityCalculationException;
import in.gov.uidai.ec.service.verification.JarIntegrityCheckFailedException;
import in.gov.uidai.ec.service.verification.LVSChecksumVerificationFailedException;
import in.gov.uidai.ec.service.verification.MachineCodeCalculationException;
import in.gov.uidai.ec.service.verification.MachineCodeChangedException;
import in.gov.uidai.ec.service.verification.MaxUnUploadedCountReachedException;
import in.gov.uidai.ec.service.verification.OTAUpdateAvailableException;
import in.gov.uidai.ec.service.verification.OperatorInactiveException;
import in.gov.uidai.ec.service.verification.OperatorSuspendedException;
import in.gov.uidai.ec.service.verification.PendingUploadsException;
import in.gov.uidai.ec.service.verification.PendingUploadsForTodayException;
import in.gov.uidai.ec.service.verification.SessionExpiredException;
import in.gov.uidai.ec.service.verification.SessionNotFoundException;
import in.gov.uidai.ec.service.verification.SystemBackDatedException;
import in.gov.uidai.ec.service.verification.UnUploadedMaxAllowedDaysReachedException;
import in.gov.uidai.ec.service.verification.VerificationException;
import in.gov.uidai.lvs.model.OnBoardingStatus;
import in.gov.uidai.lvs.spi.ILocalVerificationService;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerificationService
implements IPreferenceStoreAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerificationService.class);
    private final ClientLvsChecksum checkSum = new ClientLvsChecksum();
    private IPreferenceStore preferenceStore;
    private IRegistrationService registrationService;
    private IServerSyncDAO servSyncDAO;
    private ISessionService sessionService;
    private IEodReportSearch eodReportSearch;
    private IGpsPreference gpsPref;
    private EnrolServiceClientApiService enrolServiceClientApiService;
    private IPreSyncPreference preSyncPref;
    private IServerSyncDAO serverSyncDAO;
    private IOnboardingService onboardingService;
    private IOucDataStore oucDataStore;

    public void setPreSyncPreference(IPreSyncPreference preSyncPref) {
        this.preSyncPref = preSyncPref;
    }

    public void setServerSyncDAO(IServerSyncDAO serverSyncDAO) {
        this.serverSyncDAO = serverSyncDAO;
    }

    public void setOnboardingService(IOnboardingService onboardingService) {
        this.onboardingService = onboardingService;
    }

    public void setOucDataStore(IOucDataStore dataStore) {
        this.oucDataStore = dataStore;
    }

    public void setServSyncDAO(IServerSyncDAO servSyncDAO) {
        this.servSyncDAO = servSyncDAO;
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public ISessionService getSessionService() {
        return this.sessionService;
    }

    public void setEodReportSearch(IEodReportSearch eodReportSearch) {
        this.eodReportSearch = eodReportSearch;
    }

    public void setEnrolServiceClientApiService(EnrolServiceClientApiService enrolServiceClientApiService) {
        this.enrolServiceClientApiService = enrolServiceClientApiService;
    }

    public void setGpsPref(IGpsPreference gpsPref) {
        this.gpsPref = gpsPref;
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.preferenceStore = store;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public boolean verifyJarIntegrity() throws IntegrityVerificationException {
        JarIntegrityCheck integrityCheck = new JarIntegrityCheck();
        try {
            if (!integrityCheck.verifyJar(ApplicationVersion.VERSION)) {
                throw new JarIntegrityCheckFailedException();
            }
        }
        catch (JarIntegrityCheckFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JarIntegrityCalculationException(e);
        }
        return true;
    }

    public void verifyAppVersion() throws ClientVersionMismatchException {
        long dbVersion;
        long appVersion = Long.parseLong(ApplicationVersion.VERSION.replace(".", ""));
        if (appVersion == (dbVersion = this.servSyncDAO.getServerSyncDetails("APPLICATION_VERSION"))) {
            return;
        }
        LOGGER.error(String.format("Client Application version %d doesn't match with Database version %d", appVersion, dbVersion));
        throw new ClientVersionMismatchException();
    }

    public void isRegistered() throws ClientNotRegisteredException {
        if (!this.registrationService.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
    }

    public void verifyOnStartup(Type type) throws VerificationException, IOException, StationInfoStoreException {
        boolean presyncStatus = this.preSyncPref.getPresyncStatus(true);
        this.isSystemBackDated();
        this.isOTAUpdateAvailable();
        if (type == Type.StartUp) {
            this.isMachineCodeChanged();
            this.registrationService.makeSeqNumberConsistentInDBAndSavedDat();
            this.isMachineCheckSumValid();
            this.isLVSCheckSumValid();
            this.isDeRegInProgress();
            this.isOperatorSyncExpired();
        }
        if (presyncStatus) {
            this.isForceClosed();
            this.isGPSUpdated();
            if (type == Type.StartUp) {
                this.isSuspendedOperator();
                this.isInactiveOperator();
                this.isDayLimitReached();
                this.handleUnUploadedActivity();
            }
        }
    }

    public void updateChecksumOnOnboarding() throws IOException, StationInfoStoreException {
        LOGGER.debug("Updating LVS checksum on Onboarding.");
        List<UserCredentials> credList = this.onboardingService.getAllUsers();
        ArrayList<String> userIdList = this.getUserListForUid(credList);
        String lvsChecksum = this.checkSum.calculateLVSChecksum(this.registrationService, this.preSyncPref, userIdList);
        ChecksumInfo checksumInfo = this.oucDataStore.getCheckSumInfo();
        checksumInfo.setLvsChecksum(lvsChecksum);
        this.preSyncPref.setLvsCheckSum(lvsChecksum);
        this.oucDataStore.setCheckSumInfo(checksumInfo);
        this.serverSyncDAO.insertCheckSumDetails("LVS_CHECKSUM", lvsChecksum);
    }

    private ArrayList<String> getUserListForUid(List<UserCredentials> credList) {
        ArrayList<String> userIdList = new ArrayList<String>();
        Map userList = null;
        try {
            ILocalVerificationService lvs = LVSLocator.instance();
            userList = lvs.listUsers();
        }
        catch (LVSException e) {
            LOGGER.debug("Error while getting onboarded users", (Throwable)e);
        }
        if (userList == null || userList.size() == 0) {
            return userIdList;
        }
        for (UserCredentials cred : credList) {
            if (!userList.containsKey(cred.getUid()) || userList.get(cred.getUid()) == OnBoardingStatus.PARTIALLY_BOARDED) continue;
            userIdList.add(cred.getUid());
        }
        return userIdList;
    }

    public void isDeRegistered() throws DeRegisteredException {
        LOGGER.debug("Verifying is de-registered.");
        if (this.registrationService.isDeregistered()) {
            throw new DeRegisteredException();
        }
    }

    public void isLVSCheckSumValid() throws LVSChecksumVerificationFailedException {
        LOGGER.debug("Verifying LVS checksum.");
        List<UserCredentials> credList = this.onboardingService.getAllUsers();
        ArrayList<String> userIdList = this.getUserListForUid(credList);
        if (this.onboardingService.isAnyOperatorOnboarded() && !this.checkSum.verifyLvsChecksum(this.registrationService, this.preSyncPref, this.serverSyncDAO, userIdList)) {
            throw new LVSChecksumVerificationFailedException();
        }
    }

    public void isMachineCheckSumValid() throws ClientChecksumVerificationFailedException {
        LOGGER.debug("Verifying machine checksum.");
        if (!this.checkSum.verifyClientChecksum(this.registrationService, this.preSyncPref, this.serverSyncDAO)) {
            throw new ClientChecksumVerificationFailedException();
        }
    }

    public void isMachineCodeChanged() throws MachineCodeChangedException, MachineCodeCalculationException {
        LOGGER.debug("Verifying machine code changed.");
        try {
            if (this.registrationService.hasMachineCodeChanged()) {
                throw new MachineCodeChangedException();
            }
        }
        catch (MachineCodeChangedException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("error performing machine code check: ", (Throwable)e);
            throw new MachineCodeCalculationException(e);
        }
    }

    private void isOperatorSyncExpired() throws SessionNotFoundException {
        LOGGER.debug("Verifying operator sync expiry.");
        try {
            if (!this.sessionService.isSessionValid()) {
                throw new SessionExpiredException(this.sessionService.getOpSyncInterval(), this.sessionService.getStartTime());
            }
        }
        catch (Exception e) {
            throw new SessionNotFoundException(e);
        }
    }

    private void isDeRegInProgress() throws DeRegistrationInProgressException {
        LOGGER.debug("Verifying de registration in progress.");
        if (!this.registrationService.isDeregistrationPrerequisitesNotStarted()) {
            throw new DeRegistrationInProgressException();
        }
    }

    private void isForceClosed() throws ForceShutDownException {
        LOGGER.debug("Verifying is force code needed.");
        if (StringUtils.equalsIgnoreCase((String)this.preSyncPref.getClientForceShutdown(), (String)"QZNMUIF899")) {
            throw new ForceShutDownException();
        }
    }

    public PingResponse verifyEnrolServiceClientStatus() throws VerificationException {
        LOGGER.debug("Verifying Aadhaar Enrol Service Client running status");
        PingResponse pingResponse = null;
        try {
            pingResponse = this.enrolServiceClientApiService.ping();
        }
        catch (EnrolServiceClientApiException e) {
            switch (e.getError()) {
                case ConnectionError: {
                    throw new EnrolServiceClientStatusVerificationException((Exception)((Object)e));
                }
                case UnexpectedResponse: {
                    LOGGER.info("unexpected response while getting ping response from Aadhaar Enrol Service Client: " + e.getMessage());
                    return null;
                }
            }
            LOGGER.info("unknown error while getting ping response from Aadhaar Enrol Service Client: " + e.getMessage());
        }
        if (pingResponse == null || pingResponse.getNetworkStatus() == null) {
            throw new EnrolServiceClientStatusVerificationException("invalid network status response: " + pingResponse);
        }
        return pingResponse;
    }

    private void handleUnUploadedActivity() throws VerificationException {
        LOGGER.debug("Verifying un uploaded activity.");
        PingResponse pingResponse = this.verifyEnrolServiceClientStatus();
        if (pingResponse == null) {
            return;
        }
        UploadActivityResponse uploadActivityResponse = null;
        try {
            uploadActivityResponse = this.enrolServiceClientApiService.getPacketUploadActivity();
        }
        catch (EnrolServiceClientApiException e) {
            switch (e.getError()) {
                case ConnectionError: {
                    throw new EnrolServiceClientStatusVerificationException((Exception)((Object)e));
                }
                case UnexpectedResponse: {
                    LOGGER.info("connection error while getting packet upload activity: " + e.getMessage());
                    return;
                }
            }
            LOGGER.info("unknown error while getting packet upload activity: " + e.getMessage());
        }
        if (uploadActivityResponse == null || uploadActivityResponse.getUploadActivity() == null) {
            throw new EnrolServiceClientInvalidPingResponseException("invalid upload activity status response: " + uploadActivityResponse);
        }
        this.handleUnUploadedActivityForOnline(uploadActivityResponse);
        if (!pingResponse.getNetworkStatus().isOnline() && this.sessionService.getMaxUnUploadedDaysAllowedWhenStationOffline() != null) {
            this.handleUnUploadedActivityForOffline(uploadActivityResponse);
        }
    }

    private void handleUnUploadedActivityForOnline(UploadActivityResponse uploadActivityResponse) throws VerificationException {
        this.isMaxUnUploadedCountReached(uploadActivityResponse.getUploadActivity().getPendingUploadCount());
        this.isUnUploadedMaxAllowedDaysReached(uploadActivityResponse.getUploadActivity().getOldestUnUploadedPacketEid());
    }

    private void handleUnUploadedActivityForOffline(UploadActivityResponse uploadActivityResponse) throws VerificationException {
        int pendingUploadCountForToday;
        String oldestToBeUploadedPacketEid = uploadActivityResponse.getUploadActivity().getOldestUnUploadedPacketEid();
        if (StringUtils.isNotBlank((String)oldestToBeUploadedPacketEid)) {
            try {
                long daysDiff = this.getDaysDiff(oldestToBeUploadedPacketEid);
                long maxAllowedDaysDiff = Long.parseLong(this.sessionService.getMaxUnUploadedDaysAllowedWhenStationOffline());
                if (daysDiff >= maxAllowedDaysDiff) {
                    throw new PendingUploadsException(this.getDate(oldestToBeUploadedPacketEid), oldestToBeUploadedPacketEid);
                }
            }
            catch (ParseException e) {
                LOGGER.error("unable to parse date from oldest un-uploaded eid: " + oldestToBeUploadedPacketEid, (Throwable)e);
            }
        }
        if ((pendingUploadCountForToday = uploadActivityResponse.getUploadActivity().getPendingUploadCountForToday()) > 0) {
            throw new PendingUploadsForTodayException(pendingUploadCountForToday);
        }
    }

    private void isMaxUnUploadedCountReached(int unUploadedCount) throws MaxUnUploadedCountReachedException {
        int maxUnUploadCount;
        LOGGER.debug("Verifying max un uploaded count reached.");
        int n = maxUnUploadCount = this.sessionService.getMaxUnUploadedPacketCount() != null ? Integer.parseInt(this.sessionService.getMaxUnUploadedPacketCount()) : this.preSyncPref.getMaxUnuploadedPackets();
        if (maxUnUploadCount > 0 && unUploadedCount >= maxUnUploadCount) {
            throw new MaxUnUploadedCountReachedException(unUploadedCount, maxUnUploadCount);
        }
    }

    private void isUnUploadedMaxAllowedDaysReached(String oldestToBeUploadedPacketEid) throws UnUploadedMaxAllowedDaysReachedException {
        LOGGER.debug("Verifying max allowed days reached.");
        try {
            long maxAllowedDays;
            if (StringUtils.isBlank((String)oldestToBeUploadedPacketEid)) {
                return;
            }
            long days = this.getDaysDiff(oldestToBeUploadedPacketEid);
            long l = maxAllowedDays = this.sessionService.getMaxUnUploadedDaysAllowedWhenStationOnline() != null ? Long.parseLong(this.sessionService.getMaxUnUploadedDaysAllowedWhenStationOnline()) : Long.parseLong(this.preSyncPref.getMaxUnuploadedDateAllowed().substring(0, this.preSyncPref.getMaxUnuploadedDateAllowed().length() - 1));
            if (days > maxAllowedDays) {
                throw new UnUploadedMaxAllowedDaysReachedException(maxAllowedDays);
            }
        }
        catch (ParseException e) {
            LOGGER.error("unable to parse date from oldest un-uploaded eid: " + oldestToBeUploadedPacketEid, (Throwable)e);
        }
    }

    private void isDayLimitReached() throws DayLimitReachedException {
        LOGGER.debug("Verifying packet day limit count reached.");
        int maxPacketsPerDay = this.sessionService.getMaxEnrollmentPacketsPerDay() != null ? Integer.parseInt(this.sessionService.getMaxEnrollmentPacketsPerDay()) : this.preSyncPref.getMaxPacketsPerDay();
        int packetsAsOfToday = this.eodReportSearch.getCountOfEnrolmentsAsOn(new SimpleDateFormat("yyyyMMdd").format(new Date()));
        if (maxPacketsPerDay > 0 && packetsAsOfToday >= maxPacketsPerDay) {
            throw new DayLimitReachedException(maxPacketsPerDay, packetsAsOfToday);
        }
    }

    private long getDaysDiff(String eid) throws ParseException {
        Date date = new Date();
        Date oldestDate = this.getDate(eid);
        long diff = date.getTime() - oldestDate.getTime();
        return TimeUnit.MILLISECONDS.toDays(diff);
    }

    private Date getDate(String eid) throws ParseException {
        String oldestToBeUploadedPacketDate = eid.substring(14, 22);
        return new SimpleDateFormat("yyyyMMdd").parse(oldestToBeUploadedPacketDate);
    }

    private void isSystemBackDated() throws SystemBackDatedException {
        LOGGER.debug("Verifying system backdated.");
        long lastTransactionOn = this.preSyncPref.getLastEnrolmentTime();
        if (System.currentTimeMillis() < lastTransactionOn) {
            String lastTransTime = ECMPDateFormatHelper.getDateStr(new Date(lastTransactionOn), ECMPDateFormats.FULL_DELIM_DATE_FORMAT);
            String appStartTime = ECMPDateFormatHelper.getDateStr(new Date(System.currentTimeMillis()), ECMPDateFormats.FULL_DELIM_DATE_FORMAT);
            throw new SystemBackDatedException(lastTransTime, appStartTime);
        }
    }

    private void isGPSUpdated() throws GpsUpdateRequiredException, IOException, StationInfoStoreException {
        LOGGER.debug("Verifying GPS updated.");
        if (!StringUtils.equals((String)this.preSyncPref.getGPSUpdateVerifyRequired(), (String)"Y")) {
            return;
        }
        String gpsDateCaptureIntervalOffline = this.preSyncPref.getGpsCaptureIntervalOffline();
        TimeInterval timeInterval = new TimeInterval(gpsDateCaptureIntervalOffline);
        GpsInfo gpsInfo = this.oucDataStore.getGpsInfo();
        long gpsDateRange = timeInterval.getValue();
        long gpsLastUpdateDate = gpsInfo.getCaptureTime();
        int syncIntervalInHours = (int)TimeUnit.HOURS.convert(gpsDateRange, TimeUnit.MILLISECONDS);
        Date gpsToBeUpdatedOn = DateUtils.addHours((Date)new Date(gpsLastUpdateDate), (int)syncIntervalInHours);
        long gpsUpdatePeriod = System.currentTimeMillis() - gpsLastUpdateDate;
        if (System.currentTimeMillis() > gpsToBeUpdatedOn.getTime()) {
            this.gpsPref.setAltitude(0.0f);
            this.gpsPref.setLatitude(0.0f);
            this.gpsPref.setLongitude(0.0f);
            gpsInfo.setAltitude(Float.valueOf(0.0f));
            gpsInfo.setLongitude(Float.valueOf(0.0f));
            gpsInfo.setLatitude(Float.valueOf(0.0f));
            this.oucDataStore.setGpsInfo(gpsInfo);
            throw new GpsUpdateRequiredException(gpsLastUpdateDate == 0L ? gpsLastUpdateDate : gpsUpdatePeriod);
        }
    }

    private void isSuspendedOperator() throws OperatorSuspendedException {
        LOGGER.debug("Verifying is operator suspended.");
        String operatorUID = this.sessionService.getOperatorCredentials().getUid();
        String[] suspendedOperators = this.preSyncPref.getSuspendedOperatorIDs();
        if (suspendedOperators != null && Arrays.asList(suspendedOperators).contains(operatorUID)) {
            throw new OperatorSuspendedException();
        }
    }

    private void isInactiveOperator() throws OperatorInactiveException {
        LOGGER.debug("Verifying is operator inactive.");
        String operatorUID = this.sessionService.getOperatorCredentials().getUid();
        InActiveOperator op = new InActiveOperator();
        op.setUserCode(operatorUID);
        if (InActiveOperators.getInActiveOperatorList((String[])this.preSyncPref.getInactiveOperatorList(), (String)";").contains(op)) {
            throw new OperatorInactiveException();
        }
    }

    private void isOTAUpdateAvailable() throws OTAUpdateAvailableException {
        LOGGER.debug("Verifying OTA update availability.");
        if (new File("ota.done").exists()) {
            throw new OTAUpdateAvailableException();
        }
    }

    public static enum Type {
        StartUp,
        OperatorSync,
        ViewEnrolmentDetails;

    }
}

