/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.utils;

import in.gov.uidai.ec.icas.error.ClientException;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);

    public static XMLGregorianCalendar getXMLTimeStamp() {
        XMLGregorianCalendar xmlCalendar;
        try {
            DatatypeFactory dataFactory = DatatypeFactory.newInstance();
            GregorianCalendar cal = new GregorianCalendar();
            xmlCalendar = dataFactory.newXMLGregorianCalendar(cal);
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.error("Default DataTypeFactory for generating XMLGregorianCalendar is missing. Configure a DataTypeFactory.", (Throwable)e);
            throw new ClientException("Exception during creating timestamp", (Throwable)e);
        }
        return xmlCalendar;
    }

    public static XMLGregorianCalendar getXMLTimeStamp(long timeStamp) throws DatatypeConfigurationException {
        XMLGregorianCalendar xmlCalendar = null;
        try {
            DatatypeFactory dataFactory = DatatypeFactory.newInstance();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(timeStamp);
            xmlCalendar = dataFactory.newXMLGregorianCalendar(cal);
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.error("Default DataTypeFactory for generating XMLGregorianCalendar is missing. Configure a DataTypeFactory.", (Throwable)e);
            throw e;
        }
        return xmlCalendar;
    }

    public static String toString(Object obj) {
        return ToStringBuilder.reflectionToString((Object)obj, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

