drop table SEQMASTER;
drop table TOKEN_MANAGER;
drop table SERVER_SYNC_DETAILS;
drop table PACKET_STATUS;
drop table ENROL_SUMMARY;
drop table UENROL_SUMMARY;
drop table PACKET_EOD_INTRODUCER;
drop table PACKET_DEMO_VERIFY;
drop table PACKET_SUMMARY;

CREATE TABLE SEQMASTER
(
    SEQ_ID VARCHAR(50) NOT NULL,
    SEQ_VALUE BIGINT,
    MAC_CODE VARCHAR(200)
);

CREATE TABLE TOKEN_MANAGER
(
    TOKEN VARCHAR(50) NOT NULL,
    TOKEN_API VARCHAR(50) NOT NULL
);

-- STATUS CODES
-- 0: PENDING APPROVAL, 1: ON HOLD, 2: APPROVE, 3: REJECT, 4: EXPORTED, 5: DELETED, 6: AUTO REJECT, 7: REVIEWER APPROVE, 8: INTRO APPROVE

CREATE TABLE PACKET_SUMMARY
(
    ENROL_ID VARCHAR(50) NOT NULL,
    TYPE INTEGER,
    STATUS INTEGER,
    REVIEWER_ID VARCHAR(50),
    REVIEWER_STATUS INTEGER,
    INTRODUCER_STATUS INTEGER,
    REVIEWER_BIO_FLAG SMALLINT ,
    RESIDENT_NAME VARCHAR(99) NOT NULL,
    OPERATOR_ID VARCHAR(50) NOT NULL,
    OPERATOR_NAME VARCHAR(99) NOT NULL,
    TIN_NO VARCHAR(99),
    ADDR_BUILDING VARCHAR(100),
    ADDR_STREET VARCHAR(100),
    ADDR_LANDMARK VARCHAR(100),
    ADDR_LOCALITY VARCHAR(100),
    ADDR_VTC VARCHAR(40),
    ADDR_DISTRICT VARCHAR(50),
    ADDR_SUB_DISTRICT VARCHAR(50),
    ADDR_STATE VARCHAR(50),
    ADDR_PINCODE CHAR(6),
    ADDR_COUNTRY VARCHAR(50),
    IS_NRI VARCHAR(6),
    ISD_CODE VARCHAR(4),
    MOBILE VARCHAR(15),
    EMAIL VARCHAR(50),
    REGISTRAR_ID VARCHAR(50),
    CLIENT_VERSION VARCHAR(15),
    GPS_LONGITUDE FLOAT,
    GPS_LATITUDE FLOAT,
    GPS_ALTITUDE FLOAT,
    LOCATION_CODE VARCHAR(50),
    LAST_SYNC_DATE BIGINT,
    LANG_CODE VARCHAR(2),
    DMS_SCANNED VARCHAR(40),
    PACKET_SIZE VARCHAR(20),
    UPLOAD_STATUS INTEGER,
    GST_APPLIED FLOAT,
    AMOUNT_CHARGED_FOR_NEW_ENROLMENT FLOAT,
    AMOUNT_CHARGED_FOR_UPDATE_ENROLMENT FLOAT,
    TOTAL_AMOUNT_CHARGED FLOAT,
    IS_ONLY_MANDATORY_BIOMETRIC_UPDATE VARCHAR(3) DEFAULT 'No',
    AUTO_MIGRATION_STATUS VARCHAR(20) DEFAULT NULL,
    APPOINTMENT_ID VARCHAR(50) DEFAULT NULL,
    PACKET_CREATION_DATE BIGINT,
    IS_AUTO_SYNC_UPLOAD_SKIPPED SMALLINT DEFAULT 0,
    PROCESSING_STATE VARCHAR(200) DEFAULT NULL,
    PROCESSING_STATE_DESC VARCHAR(1000) DEFAULT NULL,
    HOLD_OR_REJECT_REASON_CODE VARCHAR(200) DEFAULT NULL,
    HOLD_OR_REJECT_REASON_DESC VARCHAR(3000) DEFAULT NULL,
    LAST_PROCESSED_TIME BIGINT DEFAULT NULL,
    SKIP_REASON_CODE VARCHAR(50) DEFAULT NULL,
    SKIP_REASON_DESCRIPTION VARCHAR(1000) DEFAULT NULL,
    PRIMARY KEY (ENROL_ID)
);

-- ACTOR TYPE
-- 0: AUTO, 1:REVIEWER , 2:INTRODUCER
CREATE TABLE PACKET_STATUS
(
    ENROL_ID VARCHAR(50) NOT NULL,
    STATUS INTEGER,
    STATUS_ENTRY_DATE BIGINT,
    REASON VARCHAR(12288),
    ACTOR_TYPE INTEGER,
    ACTOR_NAME VARCHAR(99),
    ACTOR_ID VARCHAR(50),
    ACTOR_ID_TYPE INTEGER
);

CREATE TABLE ENROL_SUMMARY
(
    ENROL_ID VARCHAR(50) NOT NULL,
    PRENROL_ID VARCHAR(40),
    SUPERVISOR_ID VARCHAR(50),
    BIO_EXCEPTION VARCHAR(12),
    PRIMARY KEY (ENROL_ID)
);

CREATE TABLE UENROL_SUMMARY
(
    ENROL_ID VARCHAR(50) NOT NULL,
    PREV_UID VARCHAR(14) NOT NULL,
    SUPERVISOR_ID VARCHAR(50),
    BIO_EXCEPTION VARCHAR(12),
    UPDATE_MODE INTEGER,
    PRIMARY KEY (ENROL_ID)
);

CREATE TABLE PACKET_EOD_INTRODUCER
(
    ENROL_ID VARCHAR(50) NOT NULL,
    INTRO_UID VARCHAR(14) NOT NULL,
    INTRO_NAME VARCHAR(99) NOT NULL,
    BIO_FLAG SMALLINT ,
    PRIMARY KEY (ENROL_ID)
);

CREATE TABLE PACKET_DEMO_VERIFY
(
    ENROL_ID VARCHAR(50) NOT NULL,
    VERIFY_TYPE INTEGER,
    VERIFIER_NAME VARCHAR(99),
    VERIFIER_ID VARCHAR(50),
    VERIFIER_ID_TYPE INTEGER,
    PRIMARY KEY (ENROL_ID)
);

alter table UENROL_SUMMARY add foreign key(ENROL_ID) references PACKET_SUMMARY(ENROL_ID);
alter table PACKET_EOD_INTRODUCER add foreign key(ENROL_ID) references PACKET_SUMMARY(ENROL_ID);
alter table PACKET_STATUS add foreign key(ENROL_ID) references PACKET_SUMMARY(ENROL_ID);
alter table PACKET_DEMO_VERIFY add foreign key(ENROL_ID) references PACKET_SUMMARY(ENROL_ID);

CREATE TABLE SERVER_SYNC_DETAILS
(
    ACTIVITY_NAME VARCHAR(50),
    ACTIVITY_TIME BIGINT,
    CONSTRAINT UQ_SERVER_SYNC_DETAILS_ACTIVITY_NAME UNIQUE  (ACTIVITY_NAME)
);

-- Create FIND_AADHAAR_ATTEMPTS table
CREATE TABLE FIND_AADHAAR_ATTEMPTS
(
    ID int primary key GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
    UID varchar(4),
    ENROL_ID varchar(30),
    ENO varchar(20),
    OPERATOR_ID varchar(50),
    RESIDENT_NAME varchar(99),
    CREATED_TIME timestamp not null with default current timestamp
);